/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import org.truffleruby.RubyContext;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;

public final class ConstantLookupResult {
    private final RubyConstant constant;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Assumption[] assumptions;

    public ConstantLookupResult(RubyConstant constant, Assumption ... assumptions) {
        assert (constant == null || !constant.isAutoload() || !constant.getAutoloadConstant().isAutoloadingThread());
        this.constant = constant;
        this.assumptions = assumptions;
    }

    public boolean isFound() {
        return this.constant != null && !this.constant.isUndefined();
    }

    public boolean isDeprecated() {
        return this.constant != null && this.constant.isDeprecated();
    }

    public boolean isAutoload() {
        return this.constant != null && this.constant.isAutoload();
    }

    public boolean isVisibleTo(RubyContext context, LexicalScope lexicalScope, RubyModule module) {
        return this.constant == null || this.constant.isVisibleTo(context, lexicalScope, module);
    }

    public RubyConstant getConstant() {
        return this.constant;
    }

    public Assumption[] getAssumptions() {
        return this.assumptions;
    }
}

