/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyUnboundMethod
extends RubyDynamicObject
implements ObjectGraphNode {
    final RubyModule origin;
    public final InternalMethod method;

    public RubyUnboundMethod(RubyClass rubyClass, Shape shape, RubyModule origin, InternalMethod method) {
        super(rubyClass, shape);
        this.origin = origin;
        this.method = method;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.origin);
        ObjectGraph.addProperty(reachable, this.method);
    }

    @Override
    public String toString() {
        return "RubyUnboundMethod(" + String.valueOf(this.method) + ")";
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage
    public SourceSection getSourceLocation() {
        return this.method.getSharedMethodInfo().getSourceSection();
    }
}

