/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.klass;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.Set;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.ConcurrentWeakSet;
import org.truffleruby.core.klass.ClassNodes;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.debug.SingleElementArray;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyClass
extends RubyModule
implements ObjectGraphNode {
    private static final RubyClass[] EMPTY_CLASS_ARRAY = new RubyClass[0];
    public final boolean isSingleton;
    public final RubyClass nonSingletonClass;
    public final RubyDynamicObject attached;
    public final Object superclass;
    public final RubyClass[] ancestorClasses;
    public final ConcurrentWeakSet<RubyClass> directNonSingletonSubclasses;
    public final int depth;

    @CompilerDirectives.TruffleBoundary
    public RubyClass(RubyClass classClass, RubyLanguage language, SourceSection sourceSection, RubyModule lexicalParent, String givenBaseName, boolean isSingleton, RubyDynamicObject attached, Object superclass) {
        super(classClass, language.classShape, language, sourceSection, lexicalParent, givenBaseName);
        assert (!isSingleton || givenBaseName == null);
        assert (isSingleton == (attached != null));
        this.isSingleton = isSingleton;
        this.attached = attached;
        this.nonSingletonClass = this.computeNonSingletonClass(isSingleton, superclass);
        this.directNonSingletonSubclasses = new ConcurrentWeakSet();
        if (superclass instanceof RubyClass) {
            this.superclass = superclass;
            this.ancestorClasses = this.computeAncestorClasses((RubyClass)superclass);
            this.depth = ((RubyClass)superclass).depth + 1;
            this.fields.setSuperClass((RubyClass)superclass);
            if (!isSingleton) {
                ((RubyClass)superclass).directNonSingletonSubclasses.add(this);
            }
        } else {
            assert (superclass == RubyBaseNode.nil);
            assert (givenBaseName == "BasicObject");
            this.superclass = superclass;
            this.ancestorClasses = EMPTY_CLASS_ARRAY;
            this.depth = 0;
        }
        this.fields.afterConstructed();
    }

    RubyClass(RubyLanguage language, Shape classShape) {
        super(language, classShape, "constructor only for the class Class");
        RubyClass moduleClass;
        this.isSingleton = false;
        this.attached = null;
        this.nonSingletonClass = this;
        this.directNonSingletonSubclasses = new ConcurrentWeakSet();
        RubyClass basicObjectClass = ClassNodes.createBootClass(language, this, RubyBaseNode.nil, "BasicObject");
        RubyClass objectClass = ClassNodes.createBootClass(language, this, basicObjectClass, "Object");
        RubyClass superclass = moduleClass = ClassNodes.createBootClass(language, this, objectClass, "Module");
        this.superclass = superclass;
        this.ancestorClasses = this.computeAncestorClasses(superclass);
        this.depth = superclass.depth + 1;
        this.fields.setSuperClass(superclass);
        this.fields.afterConstructed();
    }

    private RubyClass computeNonSingletonClass(boolean isSingleton, Object superclassObject) {
        if (isSingleton) {
            RubyClass superclass = (RubyClass)superclassObject;
            if (superclass.isSingleton) {
                return superclass.nonSingletonClass;
            }
            return superclass;
        }
        return this;
    }

    private RubyClass[] computeAncestorClasses(RubyClass superclass) {
        RubyClass[] superAncestors = superclass.ancestorClasses;
        RubyClass[] ancestors = Arrays.copyOf(superAncestors, superAncestors.length + 1);
        ancestors[superAncestors.length] = superclass;
        return ancestors;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        super.getAdjacentObjects(reachable);
        ObjectGraph.addProperty(reachable, (Object)this.attached);
        ObjectGraph.addProperty(reachable, this.superclass);
    }

    @ExportMessage
    public boolean hasMetaParents() {
        return true;
    }

    @ExportMessage
    public Object getMetaParents() {
        return new SingleElementArray(this.superclass);
    }
}

