/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.kernel;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.PropertyGetter;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.AssumedValue;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.BasicObjectNodes;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.BooleanCastWithDefaultNode;
import org.truffleruby.core.cast.DurationToNanoSecondsNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.cast.ToStringOrSymbolNode;
import org.truffleruby.core.cast.ToSymbolNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.format.BytesResult;
import org.truffleruby.core.format.FormatExceptionTranslator;
import org.truffleruby.core.format.exceptions.FormatException;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.printf.PrintfCompiler;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.PackedHashStoreLibrary;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.kernel.KernelNodesFactory;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.MethodFilter;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.ProcNodes;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringNodes;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.symbol.SymbolNodes;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.WarnNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.InternalRespondToNode;
import org.truffleruby.language.dispatch.LazyDispatchNode;
import org.truffleruby.language.dispatch.RubyCallNode;
import org.truffleruby.language.globals.ReadGlobalVariableNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.EvalLoader;
import org.truffleruby.language.loader.RequireNode;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.methods.GetMethodObjectNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.CheckIVarNameNode;
import org.truffleruby.language.objects.FreezeNode;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.IsCopyableObjectNode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.LazySingletonClassNode;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.ShapeCachingGuards;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.utils.Utils;

@CoreModule(value="Kernel")
public abstract class KernelNodes {

    @Primitive(name="warn_block_supersedes_default_value_argument")
    public static abstract class WarnBlockSupersedesDefaultValueArgumentNode
    extends PrimitiveNode {
        @Specialization
        Object warn(@Cached WarnNode warnNode) {
            if (warnNode.shouldWarn()) {
                warnNode.warningMessage(this.getContext().getCallStack().getTopMostUserSourceSection(), "block supersedes default value argument");
            }
            return Nil.INSTANCE;
        }
    }

    @Primitive(name="warn_given_block_not_used")
    public static abstract class WarnGivenBlockNotUsedNode
    extends PrimitiveNode {
        @Specialization
        Object warn(@Cached WarnNode warnNode) {
            if (warnNode.shouldWarn()) {
                warnNode.warningMessage(this.getContext().getCallStack().getTopMostUserSourceSection(), "given block not used");
            }
            return Nil.INSTANCE;
        }
    }

    @Primitive(name="warning_set_category")
    public static abstract class WarningSetCategoryNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean setCategory(RubySymbol category, boolean newValue) {
            AssumedValue<Boolean> existingValue;
            if (category == this.coreSymbols().DEPRECATED) {
                existingValue = this.getContext().getWarningCategoryDeprecated();
            } else if (category == this.coreSymbols().EXPERIMENTAL) {
                existingValue = this.getContext().getWarningCategoryExperimental();
            } else if (category == this.coreSymbols().PERFORMANCE) {
                existingValue = this.getContext().getWarningCategoryPerformance();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"unexpected warning category");
            }
            if ((Boolean)existingValue.get() != newValue) {
                existingValue.set((Object)newValue);
            }
            return newValue;
        }
    }

    @Primitive(name="warning_get_category")
    public static abstract class WarningGetCategoryNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"category == coreSymbols().DEPRECATED"})
        boolean getCategoryDeprecated(RubySymbol category) {
            return (Boolean)this.getContext().getWarningCategoryDeprecated().get();
        }

        @Specialization(guards={"category == coreSymbols().EXPERIMENTAL"})
        boolean getCategoryExperimental(RubySymbol category) {
            return (Boolean)this.getContext().getWarningCategoryExperimental().get();
        }

        @Specialization(guards={"category == coreSymbols().PERFORMANCE"})
        boolean getCategoryPerformance(RubySymbol category) {
            return (Boolean)this.getContext().getWarningCategoryPerformance().get();
        }
    }

    @GenerateUncached
    public static abstract class ToSNode
    extends RubyBaseNode {
        @NeverDefault
        public static ToSNode create() {
            return KernelNodesFactory.ToSNodeGen.create();
        }

        public abstract RubyString execute(Object var1);

        @Specialization
        RubyString toS(Object self, @Cached LogicalClassNode classNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached BasicObjectNodes.ObjectIDNode objectIDNode, @Cached ToHexStringNode toHexStringNode) {
            String className = classNode.execute((Object)self).fields.getName();
            Object id = objectIDNode.execute(self);
            String hexID = toHexStringNode.execute(this, id);
            String javaString = Utils.concat("#<", className, ":0x", hexID, ">");
            return this.createString(fromJavaStringNode, javaString, Encodings.UTF_8);
        }

        @CompilerDirectives.TruffleBoundary
        public static String uncachedBasicToS(Object self) {
            String className = LogicalClassNode.getUncached().execute((Object)self).fields.getName();
            Object id = BasicObjectNodes.ObjectIDNode.getUncached().execute(self);
            String hexID = ToHexStringNode.executeUncached(id);
            return "#<" + className + ":0x" + hexID + ">";
        }

        @CompilerDirectives.TruffleBoundary
        public static String uncachedBasicToS(RubyDynamicObject self) {
            String className = self.getLogicalClass().fields.getName();
            long id = BasicObjectNodes.ObjectIDNode.getUncached().execute(self);
            String hexID = Long.toHexString(id);
            return "#<" + className + ":0x" + hexID + ">";
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class KernelToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString toS(Object self, @Cached ToSNode toSNode) {
            return toSNode.execute(self);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToHexStringNode
    extends RubyBaseNode {
        public abstract String execute(Node var1, Object var2);

        public static String executeUncached(Object value) {
            return KernelNodesFactory.ToHexStringNodeGen.getUncached().execute(null, value);
        }

        @Specialization
        static String toHexString(int value) {
            return ToHexStringNode.toHexString((long)value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization
        static String toHexString(RubyBignum value) {
            return BigIntegerOps.toString(value.value, 16);
        }
    }

    @Primitive(name="kernel_to_hex")
    public static abstract class KernelToHexStringNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        String toHexString(Object value, @Cached ToHexStringNode toHexStringNode) {
            return toHexStringNode.execute(this, value);
        }
    }

    @CoreMethod(names={"global_variables"}, isModuleFunction=true)
    public static abstract class KernelGlobalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray globalVariables() {
            String[] keys = this.coreLibrary().globalVariables.keys();
            Object[] store = new Object[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                store[i] = this.getSymbol(keys[i]);
            }
            return this.createArray(store);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ReportPolymorphism
    public static abstract class SprintfInnerNode
    extends RubyBaseNode {
        public abstract BytesResult execute(Node var1, AbstractTruffleString var2, RubyEncoding var3, Object[] var4, boolean var5);

        @Specialization(guards={"equalNode.execute(node, format, encoding, cachedFormat, cachedEncoding)", "isDebug == cachedIsDebug"}, limit="3")
        static BytesResult formatCached(Node node, AbstractTruffleString format, RubyEncoding encoding, Object[] arguments, boolean isDebug, @Cached(value="isDebug") boolean cachedIsDebug, @Cached(value="format.asTruffleStringUncached(encoding.tencoding)") TruffleString cachedFormat, @Cached(value="encoding") RubyEncoding cachedEncoding, @Cached(value="create(compileFormat(cachedFormat, cachedEncoding, arguments, isDebug, node))", inline=false) DirectCallNode callPackNode, @Cached StringHelperNodes.EqualSameEncodingNode equalNode) {
            return (BytesResult)callPackNode.call(new Object[]{arguments, arguments.length, null});
        }

        @Specialization(replaces={"formatCached"})
        static BytesResult formatUncached(Node node, AbstractTruffleString format, RubyEncoding encoding, Object[] arguments, boolean isDebug, @Cached(inline=false) IndirectCallNode callPackNode) {
            return (BytesResult)callPackNode.call((CallTarget)SprintfInnerNode.compileFormat(format, encoding, arguments, isDebug, node), new Object[]{arguments, arguments.length, null});
        }

        @CompilerDirectives.TruffleBoundary
        static RootCallTarget compileFormat(AbstractTruffleString tstring, RubyEncoding encoding, Object[] arguments, boolean isDebug, Node node) {
            try {
                return new PrintfCompiler(SprintfInnerNode.getLanguage(node), node).compile(tstring, encoding, arguments, isDebug);
            }
            catch (InvalidFormatException e) {
                throw new RaiseException(SprintfInnerNode.getContext(node), SprintfInnerNode.coreExceptions(node).argumentError(e.getMessage(), node));
            }
        }
    }

    @CoreMethod(names={"format", "sprintf"}, isModuleFunction=true, rest=true, required=1, split=Split.ALWAYS)
    public static abstract class SprintfNode
    extends CoreMethodArrayArgumentsNode {
        static final String GVAR_DEBUG = "$DEBUG";

        @Specialization(guards={"libFormat.isRubyString(formatAsString)"}, limit="1")
        static RubyString sprintf(VirtualFrame frame, Object format, Object[] arguments, @Cached ToStrNode toStrNode, @Bind(value="toStrNode.execute(this, format)") Object formatAsString, @Cached(parameters={"GVAR_DEBUG"}) ReadGlobalVariableNode readDebugGlobalNode, @Cached BooleanCastNode booleanCastNode, @Cached RubyStringLibrary libFormat, @Cached InlinedBranchProfile exceptionProfile, @Cached InlinedConditionProfile resizeProfile, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached SprintfInnerNode sprintfInnerNode, @Bind(value="this") Node node) {
            BytesResult result;
            AbstractTruffleString tstring = libFormat.getTString(formatAsString);
            RubyEncoding encoding = libFormat.getEncoding(formatAsString);
            boolean isDebug = booleanCastNode.execute(node, readDebugGlobalNode.execute(frame));
            try {
                result = sprintfInnerNode.execute(node, tstring, encoding, arguments, isDebug);
            }
            catch (FormatException e) {
                exceptionProfile.enter(node);
                throw FormatExceptionTranslator.translate(SprintfNode.getContext(node), node, e);
            }
            return SprintfNode.finishFormat(node, tstring.byteLength(encoding.tencoding), result, resizeProfile, fromByteArrayNode);
        }

        private static RubyString finishFormat(Node node, int formatLength, BytesResult result, InlinedConditionProfile resizeProfile, TruffleString.FromByteArrayNode fromByteArrayNode) {
            byte[] bytes = result.getOutput();
            if (resizeProfile.profile(node, bytes.length != result.getOutputLength())) {
                bytes = Arrays.copyOf(bytes, result.getOutputLength());
            }
            return SprintfNode.createString(node, fromByteArrayNode, bytes, result.getEncoding().getEncodingForLength(formatLength));
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long sleep(Object maybeDuration, @Cached DurationToNanoSecondsNode durationToNanoSecondsNode) {
            long durationInNanos = durationToNanoSecondsNode.execute(this, maybeDuration);
            assert (durationInNanos >= 0L);
            RubyThread thread = this.getLanguage().getCurrentThread();
            thread.wakeUp.set(false);
            return SleepNode.sleepFor(this.getContext(), thread, durationInNanos, this);
        }

        @CompilerDirectives.TruffleBoundary
        public static long sleepFor(RubyContext context, RubyThread thread, long durationInNanos, Node currentNode) {
            assert (durationInNanos >= 0L);
            long startInNanos = System.nanoTime();
            context.getThreadManager().runUntilResult(currentNode, () -> {
                long nowInNanos = System.nanoTime();
                long sleptInNanos = nowInNanos - startInNanos;
                if (sleptInNanos >= durationInNanos || thread.wakeUp.getAndSet(false)) {
                    return true;
                }
                TimeUnit.NANOSECONDS.sleep(durationInNanos - sleptInNanos);
                return true;
            });
            return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startInNanos);
        }
    }

    @Primitive(name="singleton_methods?")
    public static abstract class HasSingletonMethodsNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean hasSingletonMethods(Object self, @Cached MetaClassNode metaClassNode) {
            RubyClass metaClass = metaClassNode.execute(this, self);
            if (!metaClass.isSingleton) {
                return false;
            }
            return metaClass.fields.anyMethodDefined();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class SingletonMethodsNode
    extends RubyBaseNode {
        public abstract RubyArray execute(Node var1, Object var2, boolean var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static RubyArray singletonMethods(Node node, Object self, boolean includeAncestors, @Cached MetaClassNode metaClassNode) {
            RubyClass metaClass = metaClassNode.execute(node, self);
            if (!metaClass.isSingleton) {
                return SingletonMethodsNode.createEmptyArray(node);
            }
            Object[] objects = metaClass.fields.filterSingletonMethods(SingletonMethodsNode.getLanguage(node), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return SingletonMethodsNode.createArray(node, objects);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    public static abstract class KernelSingletonMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray singletonMethods(Object self, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached SingletonMethodsNode singletonMethodsNode) {
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            return singletonMethodsNode.execute(this, self, includeAncestors);
        }
    }

    @CoreMethod(names={"singleton_method"}, required=1)
    public static abstract class SingletonMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMethod singletonMethod(Object self, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached InlinedBranchProfile errorProfile, @Cached InlinedConditionProfile singletonProfile, @Cached InlinedConditionProfile methodProfile, @Cached MetaClassNode metaClassNode) {
            InternalMethod method;
            String name = nameToJavaStringNode.execute(this, nameObject);
            RubyClass metaClass = metaClassNode.execute(this, self);
            if (singletonProfile.profile((Node)this, metaClass.isSingleton) && methodProfile.profile((Node)this, (method = metaClass.fields.getMethod(name)) != null && !method.isUndefined())) {
                RubyMethod instance = new RubyMethod(this.coreLibrary().methodClass, this.getLanguage().methodShape, self, method);
                AllocationTracing.trace(instance, this);
                return instance;
            }
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUndefinedSingletonMethod(name, self, this));
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyClass executeSingletonClass(Object var1);

        @Specialization
        RubyClass singletonClass(Object self, @Cached SingletonClassNode singletonClassNode) {
            return singletonClassNode.execute(self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object setTraceFunc(Nil traceFunc) {
            this.getContext().getTraceManager().setTraceFunc(null);
            return nil;
        }

        @Specialization
        RubyProc setTraceFunc(RubyProc traceFunc) {
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=2, alwaysInlined=true)
    @GenerateUncached
    public static abstract class RespondToMissingNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        boolean respondToMissing(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1, alwaysInlined=true)
    @ImportStatic(value={DispatchConfiguration.class})
    @GenerateUncached
    public static abstract class RespondToNode
    extends AlwaysInlinedMethodNode {
        public final boolean executeDoesRespondTo(Object self, RubySymbol name, boolean includeProtectedAndPrivate) {
            Object[] rubyArgs = RubyArguments.allocate(2);
            RubyArguments.setArgument(rubyArgs, 0, name);
            RubyArguments.setArgument(rubyArgs, 1, includeProtectedAndPrivate);
            return (Boolean)this.execute(null, self, rubyArgs, null);
        }

        @Specialization
        boolean doesRespondTo(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached InlinedBranchProfile notSymbolOrStringProfile, @Cached ToJavaStringNode toJavaString, @Cached ToSymbolNode toSymbolNode, @Cached BooleanCastNode castArgumentNode, @Cached InlinedConditionProfile ignoreVisibilityProfile, @Cached InlinedConditionProfile isTrueProfile, @Cached InlinedConditionProfile respondToMissingProfile, @Cached(parameters={"PUBLIC"}) InternalRespondToNode dispatchPublic, @Cached InternalRespondToNode dispatchPrivate, @Cached InternalRespondToNode dispatchRespondToMissing, @Cached DispatchNode respondToMissingNode, @Cached BooleanCastNode castMissingResultNode) {
            boolean includeProtectedAndPrivate;
            Object name = RubyArguments.getArgument(rubyArgs, 0);
            int nArgs = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            boolean bl = includeProtectedAndPrivate = nArgs >= 2 && castArgumentNode.execute(this, RubyArguments.getArgument(rubyArgs, 1));
            if (!RubyGuards.isRubySymbolOrString(name)) {
                notSymbolOrStringProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotAOrB(self, "symbol", "string", this));
            }
            String methodName = toJavaString.execute(this, name);
            boolean found = ignoreVisibilityProfile.profile((Node)this, includeProtectedAndPrivate) ? dispatchPrivate.execute(callerFrame, self, methodName) : dispatchPublic.execute(callerFrame, self, methodName);
            if (isTrueProfile.profile((Node)this, found)) {
                return true;
            }
            if (respondToMissingProfile.profile((Node)this, dispatchRespondToMissing.execute(callerFrame, self, "respond_to_missing?"))) {
                return castMissingResultNode.execute(this, respondToMissingNode.call(self, "respond_to_missing?", toSymbolNode.execute(this, name), (Object)includeProtectedAndPrivate));
            }
            return false;
        }
    }

    @CoreMethod(names={"public_send"}, needsBlock=true, required=1, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class PublicSendNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object send(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached DispatchNode dispatchNode, @Cached NameToJavaStringNode nameToJavaString) {
            Object name = RubyArguments.getArgument(rubyArgs, 0);
            Object[] newArgs = RubyArguments.repack(rubyArgs, self, 1);
            return dispatchNode.execute(callerFrame, self, nameToJavaString.execute(this, name), newArgs, DispatchConfiguration.PUBLIC);
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    public static abstract class PublicMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray publicMethods(Object self, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached MetaClassNode metaClassNode) {
            RubyClass metaClass = metaClassNode.execute(this, self);
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            Object[] objects = metaClass.fields.filterMethodsOnObject(this.getLanguage(), includeAncestors, MethodFilter.PUBLIC).toArray();
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"public_method"}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class PublicMethodNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        RubyMethod method(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached ToStringOrSymbolNode toStringOrSymbolNode, @Cached GetMethodObjectNode getMethodObjectNode) {
            Object name = toStringOrSymbolNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            return getMethodObjectNode.execute(callerFrame, self, name, DispatchConfiguration.PUBLIC);
        }
    }

    @CoreMethod(names={"protected_methods"}, optional=1)
    public static abstract class ProtectedMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray protectedMethods(Object self, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached MetaClassNode metaClassNode) {
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            RubyClass metaClass = metaClassNode.execute(this, self);
            Object[] objects = metaClass.fields.filterMethodsOnObject(this.getLanguage(), includeAncestors, MethodFilter.PROTECTED).toArray();
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true, split=Split.HEURISTIC)
    public static abstract class ProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyProc proc(VirtualFrame frame, Object maybeBlock, @Cached ProcNodes.ProcNewNode procNewNode) {
            return procNewNode.executeProcNew(frame, this.coreLibrary().procClass, ArrayUtils.EMPTY_ARRAY, maybeBlock);
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    public static abstract class PrivateMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray privateMethods(Object self, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached MetaClassNode metaClassNode) {
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            RubyClass metaClass = metaClassNode.execute(this, self);
            Object[] objects = metaClass.fields.filterMethodsOnObject(this.getLanguage(), includeAncestors, MethodFilter.PRIVATE).toArray();
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"p"}, isModuleFunction=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object p(VirtualFrame frame, Object value, @Cached DispatchNode callInspectNode) {
            Object inspected = callInspectNode.call(value, "inspect");
            this.print(inspected);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private void print(Object inspected) {
            this.getContext().getEnvOutStream().println(inspected.toString());
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class IsNilNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isNil() {
            return false;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MethodsNode
    extends RubyBaseNode {
        public abstract RubyArray execute(Node var1, Object var2, boolean var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"regular"})
        static RubyArray methodsRegular(Node node, Object self, boolean regular, @Cached MetaClassNode metaClassNode) {
            RubyClass metaClass = metaClassNode.execute(node, self);
            Object[] objects = metaClass.fields.filterMethodsOnObject(MethodsNode.getLanguage(node), regular, MethodFilter.PUBLIC_PROTECTED).toArray();
            return MethodsNode.createArray(node, objects);
        }

        @Specialization(guards={"!regular"})
        static RubyArray methodsSingleton(Node node, Object self, boolean regular, @Cached SingletonMethodsNode singletonMethodsNode) {
            return singletonMethodsNode.execute(node, self, false);
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    public static abstract class KernelMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray doMethods(Object self, Object maybeRegular, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached MethodsNode methodsNode) {
            boolean regular = booleanCastWithDefaultNode.execute(this, maybeRegular, true);
            return methodsNode.execute(this, self, regular);
        }
    }

    @CoreMethod(names={"method"}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class MethodNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        RubyMethod method(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached ToStringOrSymbolNode toStringOrSymbolNode, @Cached GetMethodObjectNode getMethodObjectNode) {
            Object name = toStringOrSymbolNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            return getMethodObjectNode.execute(callerFrame, self, name, DispatchConfiguration.PRIVATE);
        }
    }

    @CoreMethod(names={"__method__"}, isModuleFunction=true)
    public static abstract class MethodNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol methodName() {
            InternalMethod internalMethod = this.getContext().getCallStack().getCallingMethod();
            return this.getSymbol(internalMethod.getSharedMethodInfo().getMethodNameForNotBlock());
        }
    }

    @CoreMethod(names={"local_variables"}, isModuleFunction=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class KernelLocalVariablesNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object localVariables(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached DispatchNode callLocalVariables) {
            this.needCallerFrame(callerFrame, target);
            RubyBinding binding = BindingNodes.createBinding(this.getContext(), this.getLanguage(), callerFrame.materialize());
            return callLocalVariables.call(binding, "local_variables");
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true, split=Split.HEURISTIC)
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyProc lambda(Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorProcWithoutBlock(this));
        }

        @Specialization(guards={"isLiteralBlock(block)", "block.isLambda()"})
        RubyProc lambdaFromLambdaBlock(RubyProc block) {
            return block;
        }

        @Specialization(guards={"isLiteralBlock(block)", "block.isProc()"})
        RubyProc lambdaFromProcBlock(RubyProc block) {
            return ProcOperations.createLambdaFromBlock(this.getContext(), this.getLanguage(), block);
        }

        @Specialization(guards={"!isLiteralBlock(block)", "block.isProc()"})
        RubyProc lambdaFromExistingProc(RubyProc block, @Cached WarnNode warnNode) {
            if (warnNode.shouldWarnForDeprecation()) {
                warnNode.warningMessage(this.getContext().getCallStack().getTopMostUserSourceSection(), "lambda without a literal block is deprecated; use the proc without lambda instead");
            }
            return block;
        }

        @Specialization(guards={"!isLiteralBlock(block)", "block.isLambda()"})
        RubyProc lambdaFromExistingProc(RubyProc block) {
            return block;
        }

        @CompilerDirectives.TruffleBoundary
        protected boolean isLiteralBlock(RubyProc block) {
            Node callNode = this.getContext().getCallStack().getCallerNode();
            RubyCallNode rubyCallNode = (RubyCallNode)NodeUtil.findParent((Node)callNode, RubyCallNode.class);
            return rubyCallNode != null && rubyCallNode.hasLiteralBlock();
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class KernelIsANode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isA(Object self, RubyModule module, @Cached IsANode isANode) {
            return isANode.executeIsA(self, module);
        }

        @Specialization(guards={"!isRubyModule(module)"})
        boolean isATypeError(Object self, Object module) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("class or module required", this));
        }
    }

    @Primitive(name="any_instance_variable?")
    public static abstract class AnyInstanceVariableNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        static boolean any(RubyDynamicObject self, @CachedLibrary(value="self") DynamicObjectLibrary objectLibrary, @Cached InlinedConditionProfile noPropertiesProfile, @Bind(value="this") Node node) {
            Object[] keys;
            Shape shape = objectLibrary.getShape((DynamicObject)self);
            if (noPropertiesProfile.profile(node, shape.getPropertyCount() == 0)) {
                return false;
            }
            for (Object key : keys = objectLibrary.getKeyArray((DynamicObject)self)) {
                if (!(key instanceof String)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"!isRubyDynamicObject(self)"})
        boolean noVariablesInImmutableObject(Object self) {
            return false;
        }
    }

    @CoreMethod(names={"instance_variables"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray instanceVariables(Object self, @Cached TypeNodes.ObjectInstanceVariablesNode instanceVariablesNode) {
            return instanceVariablesNode.executeGetIVars(self);
        }
    }

    @CoreMethod(names={"remove_instance_variable"}, required=1, split=Split.ALWAYS)
    public static abstract class RemoveInstanceVariableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object removeInstanceVariable(RubyDynamicObject object, Object name, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode, @Cached TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, (Object)object, nameString, name);
            raiseIfFrozenNode.execute(this, (Object)object);
            return this.removeIVar(object, nameString);
        }

        @Fallback
        Object immutable(Object object, Object name, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, object, nameString, name);
            throw new RaiseException(this.getContext(), this.coreExceptions().frozenError(object, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object removeIVar(RubyDynamicObject object, String name) {
            Object value = DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)object, (Object)name, (Object)nil);
            if (SharedObjects.isShared(object)) {
                RubyDynamicObject rubyDynamicObject = object;
                synchronized (rubyDynamicObject) {
                    this.removeField(object, name);
                }
            } else {
                this.removeField(object, name);
            }
            return value;
        }

        private void removeField(RubyDynamicObject object, String name) {
            if (!DynamicObjectLibrary.getUncached().removeKey((DynamicObject)object, (Object)name)) {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorInstanceVariableNotDefined(name, (Object)object, this));
            }
        }
    }

    @CoreMethod(names={"instance_variable_set"}, required=2, split=Split.ALWAYS)
    public static abstract class InstanceVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object instanceVariableSet(RubyDynamicObject object, Object name, Object value, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @Cached WriteObjectFieldNode writeNode, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode, @Cached TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, (Object)object, nameString, name);
            raiseIfFrozenNode.execute(this, (Object)object);
            writeNode.execute(this, object, nameString, value);
            return value;
        }

        @Fallback
        Object immutable(Object object, Object name, Object value, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, object, nameString, name);
            throw new RaiseException(this.getContext(), this.coreExceptions().frozenError(object, this));
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1, split=Split.ALWAYS)
    public static abstract class InstanceVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object instanceVariableGetSymbol(RubyDynamicObject object, Object name, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @CachedLibrary(limit="getDynamicObjectCacheLimit()") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, (Object)object, nameString, name);
            return objectLibrary.getOrDefault((DynamicObject)object, (Object)nameString, (Object)nil);
        }

        @Fallback
        Object immutable(Object object, Object name, @Cached @Cached.Shared CheckIVarNameNode checkIVarNameNode, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, object, nameString, name);
            return nil;
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1, split=Split.ALWAYS)
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isInstanceVariableDefined(RubyDynamicObject object, Object name, @Cached CheckIVarNameNode checkIVarNameNode, @CachedLibrary(limit="getDynamicObjectCacheLimit()") DynamicObjectLibrary objectLibrary, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String nameString = nameToJavaStringNode.execute(this, name);
            checkIVarNameNode.execute(this, (Object)object, nameString, name);
            return objectLibrary.containsKey((DynamicObject)object, (Object)nameString);
        }

        @Fallback
        boolean immutable(Object object, Object name) {
            return false;
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode = LogicalClassNode.create();

        @Specialization
        boolean instanceOf(Object self, RubyModule module) {
            return this.classNode.execute(self) == module;
        }
    }

    @CoreMethod(names={"initialize_dup"}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class InitializeDupNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object initializeDup(Frame callerFrame, RubyDynamicObject self, Object[] rubyArgs, RootCallTarget target, @Cached DispatchNode initializeCopyNode) {
            Object from = RubyArguments.getArgument(rubyArgs, 0);
            return initializeCopyNode.call((Object)self, "initialize_copy", from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, alwaysInlined=true)
    @ImportStatic(value={RubyArguments.class})
    @GenerateUncached
    public static abstract class InitializeCopyNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"equalNode.execute(this, self, from)"})
        Object initializeCopySame(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Bind(value="getArgument(rubyArgs, 0)") Object from, @Cached @Cached.Shared ReferenceEqualNode equalNode) {
            return self;
        }

        @Specialization(guards={"!equalNode.execute(this, self, from)"})
        Object initializeCopy(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Bind(value="getArgument(rubyArgs, 0)") Object from, @Cached @Cached.Shared ReferenceEqualNode equalNode, @Cached TypeNodes.CheckFrozenNode checkFrozenNode, @Cached LogicalClassNode lhsClassNode, @Cached LogicalClassNode rhsClassNode, @Cached InlinedBranchProfile errorProfile) {
            checkFrozenNode.execute(this, self);
            if (lhsClassNode.execute(self) != rhsClassNode.execute(from)) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public static HashNode create() {
            return KernelNodesFactory.HashNodeFactory.create(null);
        }

        public abstract Object execute(Object var1);

        @Specialization
        long hashBoolean(boolean value) {
            return HashOperations.hashBoolean(value, this.getContext(), this);
        }

        @Specialization
        long hashInt(int value) {
            return HashOperations.hashLong(value, this.getContext(), this);
        }

        @Specialization
        long hashLong(long value) {
            return HashOperations.hashLong(value, this.getContext(), this);
        }

        @Specialization
        long hashDouble(double value) {
            return HashOperations.hashDouble(value, this.getContext(), this);
        }

        @Specialization
        long hashBignum(RubyBignum value) {
            return HashOperations.hashBignum(value, this.getContext(), this);
        }

        @Specialization
        static long hashString(RubyString value, @Cached @Cached.Exclusive StringHelperNodes.HashStringNode stringHashNode, @Bind(value="this") Node node) {
            return stringHashNode.execute(node, (Object)value);
        }

        @Specialization
        static long hashImmutableString(ImmutableRubyString value, @Cached @Cached.Exclusive StringHelperNodes.HashStringNode stringHashNode, @Bind(value="this") Node node) {
            return stringHashNode.execute(node, value);
        }

        @Specialization
        long hashSymbol(RubySymbol value, @Cached SymbolNodes.HashSymbolNode symbolHashNode) {
            return symbolHashNode.execute(this, value);
        }

        @Specialization(guards={"!isRubyBignum(value)", "!isImmutableRubyString(value)", "!isRubySymbol(value)"})
        int hashImmutableRubyObject(ImmutableRubyObject value) {
            return System.identityHashCode(value);
        }

        @Specialization(guards={"isNotRubyString(value)"})
        int hashRubyDynamicObject(RubyDynamicObject value) {
            return System.identityHashCode((Object)value);
        }

        @Specialization(guards={"isForeignObject(value)"}, limit="getInteropCacheLimit()")
        static int hashForeign(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            if (interop.hasIdentity(value)) {
                try {
                    return interop.identityHashCode(value);
                }
                catch (UnsupportedMessageException e) {
                    throw translateInteropException.execute(node, (InteropException)((Object)e));
                }
            }
            return System.identityHashCode(value);
        }
    }

    @CoreMethod(names={"frozen?"}, alwaysInlined=true)
    @GenerateUncached
    public static abstract class KernelFrozenNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        boolean isFrozen(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached IsFrozenNode isFrozenNode) {
            return isFrozenNode.execute(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object freeze(Object self, @Cached TypeNodes.ObjectFreezeNode objectFreezeNode) {
            return objectFreezeNode.execute(self);
        }
    }

    @ReportPolymorphism
    @GenerateUncached
    public static abstract class EvalInternalNode
    extends RubyBaseNode {
        public abstract Object execute(Object var1, Object var2, RubyBinding var3, Object var4, int var5);

        @Specialization(guards={"libSource.isRubyString(source)", "libFile.isRubyString(file)", "codeEqualNode.execute(node, libSource, source, cachedSource, cachedSourceEnc)", "fileEqualNode.execute(libFile, file, cachedFile, cachedFileEnc)", "line == cachedLine", "bindingDescriptor == getBindingDescriptor(binding)"}, limit="getCacheLimit()")
        static Object evalCached(Object self, Object source, RubyBinding binding, Object file, int line, @Cached @Cached.Shared RubyStringLibrary libSource, @Cached @Cached.Shared RubyStringLibrary libFile, @Cached(value="asTruffleStringUncached(source)") TruffleString cachedSource, @Cached(value="libSource.getEncoding(source)") RubyEncoding cachedSourceEnc, @Cached(value="asTruffleStringUncached(file)") TruffleString cachedFile, @Cached(value="libFile.getEncoding(file)") RubyEncoding cachedFileEnc, @Cached(value="line") int cachedLine, @Cached(value="getBindingDescriptor(binding)") FrameDescriptor bindingDescriptor, @Bind(value="this") Node node, @Cached(value="parse(node, cachedSource, cachedSourceEnc, binding.getFrame(), getJavaString(file), cachedLine)") RootCallTarget callTarget, @Cached(value="assignsNewUserVariables(getDescriptor(callTarget))") boolean assignsNewUserVariables, @Cached(value="create(callTarget)") DirectCallNode callNode, @Cached StringHelperNodes.EqualSameEncodingNode codeEqualNode, @Cached StringHelperNodes.EqualNode fileEqualNode) {
            Object[] rubyArgs = EvalInternalNode.prepareEvalArgs(node, callTarget, assignsNewUserVariables, self, binding);
            return callNode.call(rubyArgs);
        }

        @Specialization(guards={"libSource.isRubyString(source)", "libFile.isRubyString(file)"}, replaces={"evalCached"})
        static Object evalBindingUncached(Object self, Object source, RubyBinding binding, Object file, int line, @Cached IndirectCallNode callNode, @Cached @Cached.Shared RubyStringLibrary libFile, @Cached @Cached.Shared RubyStringLibrary libSource, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            RootCallTarget callTarget = EvalInternalNode.parse(node, libSource.getTString(source), libSource.getEncoding(source), binding.getFrame(), toJavaStringNode.execute(node, file), line);
            boolean assignsNewUserVariables = EvalInternalNode.assignsNewUserVariables(EvalInternalNode.getDescriptor(callTarget));
            Object[] rubyArgs = EvalInternalNode.prepareEvalArgs(node, callTarget, assignsNewUserVariables, self, binding);
            return callNode.call((CallTarget)callTarget, rubyArgs);
        }

        private static Object[] prepareEvalArgs(Node node, RootCallTarget callTarget, boolean assignsNewUserVariables, Object self, RubyBinding binding) {
            Object[] objectArray;
            MaterializedFrame parentFrame = Objects.requireNonNull(binding.getFrame());
            if (assignsNewUserVariables) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = binding;
            } else {
                objectArray = RubyNode.EMPTY_ARGUMENTS;
            }
            Object[] args = objectArray;
            return EvalInternalNode.getContext(node).getCodeLoader().prepareArgs(callTarget, ParserContext.EVAL, RubyArguments.getDeclarationContext((Frame)parentFrame), parentFrame, self, RubyArguments.getMethod((Frame)parentFrame).getLexicalScope(), args);
        }

        @CompilerDirectives.TruffleBoundary
        protected static RootCallTarget parse(Node node, AbstractTruffleString sourceText, RubyEncoding encoding, MaterializedFrame parentFrame, String file, int line) {
            String sourceFile = file.intern();
            RubySource source = EvalLoader.createEvalSource(EvalInternalNode.getContext(node), sourceText, encoding, "eval", sourceFile, line, node);
            LexicalScope lexicalScope = RubyArguments.getMethod((Frame)parentFrame).getLexicalScope();
            return EvalInternalNode.getContext(node).getCodeLoader().parse(source, ParserContext.EVAL, parentFrame, lexicalScope, node);
        }

        protected FrameDescriptor getBindingDescriptor(RubyBinding binding) {
            return BindingNodes.getFrameDescriptor(binding);
        }

        protected static FrameDescriptor getDescriptor(RootCallTarget callTarget) {
            return RubyRootNode.of(callTarget).getFrameDescriptor();
        }

        public static boolean assignsNewUserVariables(FrameDescriptor descriptor) {
            return BindingNodes.assignsNewUserVariables(descriptor);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.EVAL_CACHE;
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, alwaysInlined=true)
    @GenerateUncached
    public static abstract class EvalPrepareArgsNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object eval(Frame callerFrame, Object callerSelf, Object[] rubyArgs, RootCallTarget target, @Cached ToStrNode toStrNode, @Cached ToIntNode toIntNode, @Cached InlinedBranchProfile errorProfile, @Cached InlinedConditionProfile hasBindingArgument, @Cached EvalInternalNode evalInternalNode, @Cached InlinedConditionProfile fileAndLineProfile, @Cached InlinedConditionProfile fileNoLineProfile) {
            Object file;
            int line;
            Object self;
            RubyBinding binding;
            Object[] args = RubyArguments.getPositionalArguments(rubyArgs);
            Object source = toStrNode.execute(this, args[0]);
            if (hasBindingArgument.profile((Node)this, args.length > 1 && args[1] != nil)) {
                Object bindingArg = args[1];
                if (!(bindingArg instanceof RubyBinding)) {
                    errorProfile.enter((Node)this);
                    throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorWrongArgumentType(bindingArg, "binding", this));
                }
                binding = (RubyBinding)bindingArg;
                self = RubyArguments.getSelf((Frame)binding.getFrame());
            } else {
                this.needCallerFrame(callerFrame, "Kernel#eval with no Binding argument");
                binding = BindingNodes.createBinding(this.getContext(), this.getLanguage(), callerFrame.materialize());
                self = callerSelf;
            }
            if (fileAndLineProfile.profile((Node)this, args.length > 3 && args[3] != nil)) {
                line = toIntNode.execute(args[3]);
                file = toStrNode.execute(this, args[2]);
            } else if (fileNoLineProfile.profile((Node)this, args.length > 2 && args[2] != nil)) {
                file = toStrNode.execute(this, args[2]);
                line = 1;
            } else {
                file = this.coreStrings().EVAL_FILENAME_STRING.createInstance(this.getContext());
                line = 1;
            }
            return evalInternalNode.execute(self, source, binding, file, line);
        }
    }

    @NodeChild(value="selfNode", type=RubyNode.class)
    @GenerateNodeFactory
    public static abstract class DupASTNode
    extends RubyContextSourceNode {
        public static DupASTNode create(RubyNode selfNode) {
            return KernelNodesFactory.DupASTNodeFactory.create(selfNode);
        }

        @Specialization
        Object dupAST(VirtualFrame frame, Object self, @Cached DupNode dupNode) {
            return dupNode.execute((Frame)frame, self, ArrayUtils.EMPTY_ARRAY, null);
        }

        abstract RubyNode getSelfNode();

        @Override
        public RubyNode cloneUninitialized() {
            DupASTNode copy = DupASTNode.create(this.getSelfNode().cloneUninitialized());
            return copy.copyFlags(this);
        }
    }

    @CoreMethod(names={"dup"}, alwaysInlined=true)
    @GenerateUncached
    public static abstract class DupNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object dup(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached IsCopyableObjectNode isCopyableObjectNode, @Cached InlinedConditionProfile isCopyableProfile, @Cached CopyNode copyNode, @Cached DispatchNode initializeDupNode) {
            if (isCopyableProfile.profile((Node)this, isCopyableObjectNode.execute(self))) {
                RubyDynamicObject copy = copyNode.executeCopy(self);
                initializeDupNode.call((Object)copy, "initialize_dup", self);
                return copy;
            }
            return self;
        }
    }

    @Primitive(name="kernel_clone")
    public static abstract class CloneNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isCopyableObjectNode.execute(object)"})
        static RubyDynamicObject copyable(Object object, Object freeze, @Cached @Cached.Shared IsCopyableObjectNode isCopyableObjectNode, @Cached MetaClassNode metaClassNode, @Cached CopyNode copyNode, @Cached DispatchNode initializeCloneNode, @Cached InlinedConditionProfile isSingletonProfile, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached IsFrozenNode isFrozenNode, @Cached FreezeNode freezeNode, @Cached LazySingletonClassNode lazySingletonClassNode, @Bind(value="this") Node node) {
            boolean copyFrozen;
            RubyDynamicObject newObject = copyNode.executeCopy(object);
            RubyClass selfMetaClass = metaClassNode.execute(node, object);
            if (isSingletonProfile.profile(node, selfMetaClass.isSingleton)) {
                RubyClass newObjectMetaClass = lazySingletonClassNode.get(node).execute((Object)newObject);
                newObjectMetaClass.fields.initCopy(selfMetaClass);
            }
            if (copyFrozen = freeze instanceof Nil) {
                initializeCloneNode.call((Object)newObject, "initialize_clone", object);
            } else {
                RubyHash keywordArguments = CloneNode.createFreezeBooleanHash(node, (Boolean)freeze, hashNode);
                initializeCloneNode.callWithKeywords((Object)newObject, "initialize_clone", object, keywordArguments);
            }
            if (CloneNode.forceFrozen(freeze) || copyFrozen && isFrozenNode.execute(object)) {
                freezeNode.execute(node, (Object)newObject);
            }
            return newObject;
        }

        @Specialization(guards={"!isCopyableObjectNode.execute(object)"})
        Object notCopyable(Object object, Object freeze, @Cached @Cached.Shared IsCopyableObjectNode isCopyableObjectNode, @Cached InlinedBranchProfile cantUnfreezeErrorProfile) {
            if (this.forceNotFrozen(freeze)) {
                this.raiseCantUnfreezeError(cantUnfreezeErrorProfile, object);
            }
            return object;
        }

        private static RubyHash createFreezeBooleanHash(Node node, boolean freeze, HashingNodes.ToHashByHashCode hashNode) {
            RubySymbol key = CloneNode.coreSymbols((Node)node).FREEZE;
            Object[] newStore = PackedHashStoreLibrary.createStore();
            int hashed = hashNode.execute(node, key);
            PackedHashStoreLibrary.setHashedKeyValue(newStore, 0, hashed, key, freeze);
            return new RubyHash(CloneNode.coreLibrary((Node)node).hashClass, CloneNode.getLanguage((Node)node).hashShape, CloneNode.getContext(node), newStore, 1, false);
        }

        private static boolean forceFrozen(Object freeze) {
            return freeze instanceof Boolean && (Boolean)freeze != false;
        }

        private boolean forceNotFrozen(Object freeze) {
            return freeze instanceof Boolean && (Boolean)freeze == false;
        }

        private void raiseCantUnfreezeError(InlinedBranchProfile cantUnfreezeErrorProfile, Object object) {
            cantUnfreezeErrorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorCantUnfreeze(object, this));
        }
    }

    @GenerateUncached
    public static abstract class CopyNode
    extends RubyBaseNode {
        public abstract RubyDynamicObject executeCopy(Object var1);

        @Specialization(guards={"!isRubyClass(self)"})
        RubyDynamicObject copyRubyDynamicObject(RubyDynamicObject self, @Cached DispatchNode allocateNode, @Cached @Cached.Exclusive CopyInstanceVariablesNode copyInstanceVariablesNode) {
            RubyDynamicObject newObject = (RubyDynamicObject)((Object)allocateNode.call(self.getLogicalClass(), "__allocate__"));
            copyInstanceVariablesNode.execute(this, newObject, self);
            return newObject;
        }

        @Specialization
        RubyDynamicObject copyRubyClass(RubyClass self, @Cached @Cached.Exclusive CopyInstanceVariablesNode copyInstanceVariablesNode, @Cached InlinedBranchProfile rootClassProfile) {
            if (self == this.coreLibrary().basicObjectClass) {
                rootClassProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't copy the root class", this));
            }
            RubyClass newClass = new RubyClass(this.coreLibrary().classClass, this.getLanguage(), this.getEncapsulatingSourceSection(), null, null, false, null, self.superclass);
            copyInstanceVariablesNode.execute(this, newClass, self);
            return newClass;
        }

        @Specialization
        RubyDynamicObject copy(ImmutableRubyString string, @Cached StringNodes.AllocateNode allocateStringNode) {
            return allocateStringNode.execute(this, this.coreLibrary().stringClass);
        }

        @Specialization
        RubyDynamicObject copy(RubyIntOrLongRange range, @Cached RangeNodes.AllocateNode allocateRangeNode) {
            return allocateRangeNode.execute(this, this.coreLibrary().rangeClass);
        }
    }

    @ImportStatic(value={ShapeCachingGuards.class})
    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ReportPolymorphism
    public static abstract class CopyInstanceVariablesNode
    extends RubyBaseNode {
        public static final DynamicObjectLibrary[] EMPTY_DYNAMIC_OBJECT_LIBRARY_ARRAY = new DynamicObjectLibrary[0];
        public static final PropertyGetter[] EMPTY_PROPERTY_GETTER_ARRAY = new PropertyGetter[0];

        public abstract RubyDynamicObject execute(Node var1, RubyDynamicObject var2, RubyDynamicObject var3);

        public final RubyDynamicObject executeCached(RubyDynamicObject newObject, RubyDynamicObject from) {
            return this.execute(this, newObject, from);
        }

        @ExplodeLoop
        @Specialization(guards={"from.getShape() == cachedShape", "propertyGetters.length <= MAX_EXPLODE_SIZE"}, limit="getDynamicObjectCacheLimit()")
        static RubyDynamicObject copyCached(RubyDynamicObject newObject, RubyDynamicObject from, @Cached(value="from.getShape()") Shape cachedShape, @Cached(value="getCopiedProperties(cachedShape)", dimensions=1) PropertyGetter[] propertyGetters, @Cached(value="createWriteFieldNodes(propertyGetters)") DynamicObjectLibrary[] writeFieldNodes) {
            for (int i = 0; i < propertyGetters.length; ++i) {
                PropertyGetter propertyGetter = propertyGetters[i];
                Object value = propertyGetter.get((DynamicObject)from);
                writeFieldNodes[i].putWithFlags((DynamicObject)newObject, propertyGetter.getKey(), value, propertyGetter.getFlags());
            }
            return newObject;
        }

        @Specialization(guards={"updateShape(from)"})
        static RubyDynamicObject updateShapeAndCopy(RubyDynamicObject newObject, RubyDynamicObject from, @Cached(inline=false) CopyInstanceVariablesNode copyInstanceVariablesNode) {
            return copyInstanceVariablesNode.executeCached(newObject, from);
        }

        @Specialization(replaces={"copyCached", "updateShapeAndCopy"})
        static RubyDynamicObject copyUncached(RubyDynamicObject newObject, RubyDynamicObject from) {
            CopyInstanceVariablesNode.copyInstanceVariables(from, newObject);
            return newObject;
        }

        protected static PropertyGetter[] getCopiedProperties(Shape shape) {
            ArrayList<PropertyGetter> copiedProperties = new ArrayList<PropertyGetter>();
            for (Property property : shape.getProperties()) {
                if (!(property.getKey() instanceof String)) continue;
                copiedProperties.add(Objects.requireNonNull(shape.makePropertyGetter(property.getKey())));
            }
            return copiedProperties.toArray(EMPTY_PROPERTY_GETTER_ARRAY);
        }

        protected DynamicObjectLibrary[] createWriteFieldNodes(PropertyGetter[] propertyGetters) {
            if (propertyGetters.length == 0) {
                return EMPTY_DYNAMIC_OBJECT_LIBRARY_ARRAY;
            }
            DynamicObjectLibrary[] nodes = new DynamicObjectLibrary[propertyGetters.length];
            for (int i = 0; i < propertyGetters.length; ++i) {
                nodes[i] = (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(1);
            }
            return nodes;
        }

        @CompilerDirectives.TruffleBoundary
        private static void copyInstanceVariables(RubyDynamicObject from, RubyDynamicObject to) {
            Shape shape = from.getShape();
            for (PropertyGetter propertyGetter : CopyInstanceVariablesNode.getCopiedProperties(shape)) {
                DynamicObjectLibrary.getUncached().putWithFlags((DynamicObject)to, propertyGetter.getKey(), propertyGetter.get((DynamicObject)from), propertyGetter.getFlags());
            }
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode = LogicalClassNode.create();

        @Specialization
        RubyClass getClass(Object self) {
            return this.classNode.execute(self);
        }
    }

    @Primitive(name="kernel_caller_locations", lowerFixnum={0, 1})
    public static abstract class CallerLocationsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object callerLocations(int omit, NotProvided length) {
            return this.innerCallerLocations(omit, -1);
        }

        @Specialization
        Object callerLocations(int omit, int length) {
            return this.innerCallerLocations(omit, length);
        }

        private Object innerCallerLocations(int omit, int length) {
            int omitted = omit + 1;
            Backtrace backtrace = this.getContext().getCallStack().getBacktrace(this, omitted);
            return backtrace.getBacktraceLocations(this.getContext(), this.getLanguage(), length, this);
        }
    }

    @Primitive(name="canonicalize_path")
    public static abstract class CanonicalizePathNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(string)"}, limit="1")
        @CompilerDirectives.TruffleBoundary
        RubyString canonicalPath(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String expandedPath = this.getContext().getFeatureLoader().canonicalize(RubyGuards.getJavaString(string), null);
            return this.createString(fromJavaStringNode, expandedPath, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"__callee__"}, isModuleFunction=true)
    public static abstract class CalleeNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol calleeName() {
            return this.getSymbol(this.getContext().getCallStack().getCallingMethod().getName());
        }
    }

    @CoreMethod(names={"block_given?", "iterator?"}, isModuleFunction=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class BlockGivenNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        boolean blockGiven(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached FindDeclarationVariableNodes.FindAndReadDeclarationVariableNode readNode, @Cached InlinedConditionProfile blockProfile) {
            this.needCallerFrame(callerFrame, target);
            return blockProfile.profile((Node)this, readNode.execute(callerFrame, this, "%method_block_arg", nil) != nil);
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class BindingNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        RubyBinding binding(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached(value="getAdoptedNode(this).getEncapsulatingSourceSection()", allowUncached=true, neverDefault=false) SourceSection sourceSection) {
            this.needCallerFrame(callerFrame, target);
            return BindingNodes.createBinding(this.getContext(), this.getLanguage(), callerFrame.materialize(), sourceSection);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object compare(Object self, Object other, @Cached SameOrEqualNode sameOrEqualNode) {
            if (sameOrEqualNode.execute(this, self, other)) {
                return 0;
            }
            return nil;
        }
    }

    @Primitive(name="load_feature")
    public static abstract class LoadFeatureNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libFeatureString.isRubyString(featureString)"}, limit="1")
        static boolean loadFeature(Object featureString, Object expandedPathString, @Cached RubyStringLibrary libFeatureString, @Cached ToJavaStringNode toJavaStringNode, @Cached RequireNode requireNode, @Bind(value="this") Node node) {
            return requireNode.executeRequire(toJavaStringNode.execute(node, featureString), expandedPathString);
        }
    }

    @Primitive(name="get_caller_path")
    public static abstract class GetCallerPathNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libFeature.isRubyString(feature)"}, limit="1")
        @CompilerDirectives.TruffleBoundary
        RubyString getCallerPath(Object feature, @Cached RubyStringLibrary libFeature, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object featurePath;
            String featureString = RubyGuards.getJavaString(feature);
            if (new File(featureString).isAbsolute()) {
                featurePath = featureString;
            } else {
                SourceSection sourceSection = this.getContext().getCallStack().getCallerNode().getEncapsulatingSourceSection();
                if (!BacktraceFormatter.isAvailable(sourceSection)) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().loadError("cannot infer basepath", featureString, (Node)this));
                }
                Source source = sourceSection.getSource();
                String sourcePath = this.getLanguage().getSourcePath(source);
                sourcePath = this.getContext().getFeatureLoader().canonicalize(sourcePath, source);
                featurePath = this.getContext().getFeatureLoader().dirname(sourcePath) + "/" + featureString;
            }
            return this.createString(fromJavaStringNode, Paths.get((String)featurePath, new String[0]).normalize().toString(), Encodings.UTF_8);
        }
    }

    @Primitive(name="find_file")
    public static abstract class FindFileNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libFeatureString.isRubyString(featureString)"}, limit="1")
        static Object findFile(Object featureString, @Cached InlinedBranchProfile notFoundProfile, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached RubyStringLibrary libFeatureString, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String feature = toJavaStringNode.execute(node, featureString);
            String expandedPath = FindFileNode.getContext(node).getFeatureLoader().findFeature(feature);
            if (expandedPath == null) {
                notFoundProfile.enter(node);
                return nil;
            }
            return FindFileNode.createString(node, fromJavaStringNode, expandedPath, Encodings.UTF_8);
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class SameOrEqlNode
    extends RubyBaseNode {
        public static boolean executeUncached(Object a, Object b) {
            return KernelNodesFactory.SameOrEqlNodeGen.getUncached().execute(null, a, b);
        }

        public abstract boolean execute(Node var1, Object var2, Object var3);

        @Specialization
        static boolean refEqualOrEql(Node node, Object a, Object b, @Cached ReferenceEqualNode referenceEqual, @Cached(inline=false) DispatchNode eql, @Cached BooleanCastNode booleanCast) {
            return referenceEqual.execute(node, a, b) || booleanCast.execute(node, eql.call(a, "eql?", b));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class CaseCompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean caseCmp(Object a, Object b, @Cached SameOrEqualNode sameOrEqualNode) {
            return sameOrEqualNode.execute(this, a, b);
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class SameOrEqualNode
    extends RubyBaseNode {
        public abstract boolean execute(Node var1, Object var2, Object var3);

        @Specialization
        static boolean sameOrEqual(Node node, Object a, Object b, @Cached LazyDispatchNode lazyEqualNode, @Cached BooleanCastNode booleanCastNode, @Cached InlinedConditionProfile sameProfile, @Cached ReferenceEqualNode referenceEqualNode) {
            if (sameProfile.profile(node, referenceEqualNode.execute(node, a, b))) {
                return true;
            }
            DispatchNode equalNode = lazyEqualNode.get(node);
            return booleanCastNode.execute(node, equalNode.call(a, "==", b));
        }
    }

    @Primitive(name="same_or_equal?")
    public static abstract class SameOrEqualPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean doSameOrEqual(Object a, Object b, @Cached SameOrEqualNode sameOrEqualNode) {
            return sameOrEqualNode.execute(this, a, b);
        }
    }
}

