/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedMulNodeGen;
import org.truffleruby.core.numeric.IntegerNodes;
import org.truffleruby.core.numeric.IntegerNodesFactory;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedMulNode
extends BinaryInlinedOperationNode {
    @Node.Child
    IntegerNodes.MulNode fixnumMul;

    public InlinedMulNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.integerMulAssumption, language.coreMethodAssumptions.floatMulAssumption);
    }

    @Specialization(assumptions={"assumptions"})
    Object intMul(int a, int b) {
        return this.getMulNode().executeMul(a, b);
    }

    @Specialization(assumptions={"assumptions"})
    Object longMul(long a, long b) {
        return this.getMulNode().executeMul(a, b);
    }

    @Specialization(assumptions={"assumptions"})
    double floatMul(double a, double b) {
        return a * b;
    }

    @Specialization(assumptions={"assumptions"})
    double longDouble(long a, double b) {
        return (double)a * b;
    }

    @Specialization(assumptions={"assumptions"})
    double doubleLong(double a, long b) {
        return a * (double)b;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    private IntegerNodes.MulNode getMulNode() {
        if (this.fixnumMul == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fixnumMul = (IntegerNodes.MulNode)this.insert(IntegerNodesFactory.MulNodeFactory.create(null));
        }
        return this.fixnumMul;
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedMulNode copy = InlinedMulNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

