/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedModNodeGen;
import org.truffleruby.core.numeric.FloatNodes;
import org.truffleruby.core.numeric.IntegerNodes;
import org.truffleruby.core.numeric.IntegerNodesFactory;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedModNode
extends BinaryInlinedOperationNode {
    @Node.Child
    IntegerNodes.ModNode fixnumMod;
    protected static final double ZERO = 0.0;

    public InlinedModNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.integerModAssumption, language.coreMethodAssumptions.floatModAssumption);
    }

    @Specialization(guards={"b != 0"}, assumptions={"assumptions"})
    Object intMod(int a, int b) {
        return this.getModNode().executeMod(a, b);
    }

    @Specialization(guards={"b != 0"}, assumptions={"assumptions"})
    Object longMod(long a, long b) {
        return this.getModNode().executeMod(a, b);
    }

    @Specialization(guards={"b != ZERO"}, assumptions={"assumptions"})
    Object floatMod(double a, double b, @Cached FloatNodes.ModNode modNode) {
        return modNode.executeMod(a, b);
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    private IntegerNodes.ModNode getModNode() {
        if (this.fixnumMod == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fixnumMod = (IntegerNodes.ModNode)this.insert(IntegerNodesFactory.ModNodeFactory.create(null));
        }
        return this.fixnumMod;
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedModNode copy = InlinedModNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

