/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.InlinedLambdaNodeGen;
import org.truffleruby.core.inlined.UnaryInlinedOperationNode;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;

@NodeChild(value="block", type=RubyNode.class)
public abstract class InlinedLambdaNode
extends UnaryInlinedOperationNode {
    protected static final String METHOD = "lambda";

    public InlinedLambdaNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, new Assumption[0]);
    }

    protected abstract RubyNode getBlock();

    @Specialization(guards={"lookupNode.lookupIgnoringVisibility(frame, self, METHOD) == coreMethods().LAMBDA"}, assumptions={"assumptions"}, limit="1")
    RubyProc lambda(VirtualFrame frame, Object self, RubyProc block, @Cached LookupMethodOnSelfNode lookupNode) {
        assert (block.type == ProcType.LAMBDA);
        return block;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object self, RubyProc block) {
        assert (block.type == ProcType.LAMBDA);
        block = ProcOperations.createProcFromBlock(this.getContext(), this.getLanguage(), block);
        return this.rewriteAndCallWithBlock(frame, self, block, new Object[0]);
    }

    @Override
    protected RubyNode getBlockNode() {
        return this.getBlock();
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedLambdaNode copy = InlinedLambdaNodeGen.create(this.getLanguage(), this.parameters, this.getSelfNode().cloneUninitialized(), this.getBlock().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

