/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayWriteNormalizedNode;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.inlined.InlinedIndexSetNodeGen;
import org.truffleruby.core.inlined.TernaryInlinedOperationNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;

public abstract class InlinedIndexSetNode
extends TernaryInlinedOperationNode
implements AssignableNode {
    protected static final String METHOD = "[]=";

    public InlinedIndexSetNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, new Assumption[0]);
    }

    protected abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization(guards={"lookupNode.lookupProtected(frame, array, METHOD) == coreMethods().ARRAY_INDEX_SET", "normalizedIndex >= 0"}, assumptions={"assumptions"}, limit="1")
    static Object arrayWrite(VirtualFrame frame, RubyArray array, int index, Object value, @Cached LookupMethodOnSelfNode lookupNode, @Cached InlinedConditionProfile denormalized, @Bind(value="this") Node node, @Bind(value="normalize(node, array, index, denormalized)") int normalizedIndex, @Cached ArrayWriteNormalizedNode writeNode) {
        return writeNode.executeWrite(array, normalizedIndex, value);
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b, Object c) {
        return this.rewriteAndCall(frame, a, b, c);
    }

    protected int normalize(Node node, RubyArray array, int index, InlinedConditionProfile denormalized) {
        if (denormalized.profile(node, index < 0)) {
            index += array.size;
        }
        return index;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        Object receiver = this.getReceiver().execute(frame);
        Object index = this.getOperand1Node().execute(frame);
        this.execute(frame, receiver, index, value);
    }

    @Override
    public AssignableNode toAssignableNode() {
        assert (this.getOperand2Node() instanceof NilLiteralNode) : this.getOperand2Node();
        return this;
    }

    @Override
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return this.rewriteToCallNode().createWrapper(probeNode);
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedIndexSetNode copy = InlinedIndexSetNodeGen.create(this.getLanguage(), this.parameters, this.getReceiver().cloneUninitialized(), this.getOperand1Node().cloneUninitialized(), this.getOperand2Node().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

