/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedIndexGetNodeGen;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;

public abstract class InlinedIndexGetNode
extends BinaryInlinedOperationNode {
    protected static final String METHOD = "[]";

    public InlinedIndexGetNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, new Assumption[0]);
    }

    @Specialization(guards={"lookupNode.lookupProtected(frame, array, METHOD) == coreMethods().ARRAY_INDEX_GET"}, assumptions={"assumptions"}, limit="1")
    static Object arrayRead(VirtualFrame frame, RubyArray array, int index, @Cached LookupMethodOnSelfNode lookupNode, @Cached ArrayIndexNodes.ReadNormalizedNode readNormalizedNode, @Cached InlinedConditionProfile denormalized, @Bind(value="this") Node node) {
        if (denormalized.profile(node, index < 0)) {
            index += array.size;
        }
        return readNormalizedNode.executeRead(array, index);
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedIndexGetNode copy = InlinedIndexGetNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

