/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedDivNodeGen;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedDivNode
extends BinaryInlinedOperationNode {
    public InlinedDivNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.integerDivAssumption, language.coreMethodAssumptions.floatDivAssumption);
    }

    @Specialization(guards={"a >= 0", "b > 0"}, assumptions={"assumptions"})
    int intDiv(int a, int b) {
        return a / b;
    }

    @Specialization(guards={"a >= 0", "b > 0"}, assumptions={"assumptions"})
    long longDiv(long a, long b) {
        return a / b;
    }

    @Specialization(assumptions={"assumptions"})
    double floatDiv(double a, double b) {
        return a / b;
    }

    @Specialization(assumptions={"assumptions"})
    double longDouble(long a, double b) {
        return (double)a / b;
    }

    @Specialization(assumptions={"assumptions"})
    double doubleLong(double a, long b) {
        return a / (double)b;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedDivNode copy = InlinedDivNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

