/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.methods.InternalMethod;

public final class CoreMethods {
    public final InternalMethod EXCEPTION_BACKTRACE;
    public final InternalMethod LAMBDA;
    public final InternalMethod NOT;
    public final InternalMethod KERNEL_IS_NIL;
    public final InternalMethod KERNEL_IS_A;
    public final InternalMethod KERNEL_KIND_OF;
    public final InternalMethod STRING_BYTESIZE;
    public final InternalMethod MODULE_CASE_EQUAL;
    public final InternalMethod STRING_EQUAL;
    public final InternalMethod SYMBOL_TO_PROC;
    public final InternalMethod ARRAY_AT;
    public final InternalMethod ARRAY_INDEX_GET;
    public final InternalMethod ARRAY_INDEX_SET;

    public CoreMethods(RubyLanguage language, RubyContext context) {
        RubyClass basicObjectClass = context.getCoreLibrary().basicObjectClass;
        RubyClass exceptionClass = context.getCoreLibrary().exceptionClass;
        RubyModule kernelModule = context.getCoreLibrary().kernelModule;
        RubyClass moduleClass = context.getCoreLibrary().moduleClass;
        RubyClass stringClass = context.getCoreLibrary().stringClass;
        RubyClass symbolClass = context.getCoreLibrary().symbolClass;
        RubyClass arrayClass = context.getCoreLibrary().arrayClass;
        this.LAMBDA = this.getMethod(kernelModule, "lambda");
        this.NOT = this.getMethod(basicObjectClass, "!");
        this.EXCEPTION_BACKTRACE = this.getMethod(exceptionClass, "backtrace");
        this.KERNEL_IS_NIL = this.getMethod(kernelModule, "nil?");
        this.STRING_BYTESIZE = this.getMethod(stringClass, "bytesize");
        this.KERNEL_IS_A = this.getMethod(kernelModule, "is_a?");
        this.KERNEL_KIND_OF = this.getMethod(kernelModule, "kind_of?");
        this.MODULE_CASE_EQUAL = this.getMethod(moduleClass, "===");
        this.STRING_EQUAL = this.getMethod(stringClass, "==");
        this.SYMBOL_TO_PROC = this.getMethod(symbolClass, "to_proc");
        this.ARRAY_AT = this.getMethod(arrayClass, "at");
        this.ARRAY_INDEX_GET = this.getMethod(arrayClass, "[]");
        this.ARRAY_INDEX_SET = this.getMethod(arrayClass, "[]=");
    }

    private InternalMethod getMethod(RubyModule module, String name) {
        InternalMethod method = module.fields.getMethod(name);
        if (method == null || method.isUndefined()) {
            throw new AssertionError();
        }
        return method;
    }
}

