/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.CompareHashKeysNode;
import org.truffleruby.core.hash.FreezeHashKeyIfNeededNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.shared.PropagateSharingNode;

@ExportLibrary(value=HashStoreLibrary.class)
@GenerateUncached
public final class CompactHashStore {
    private int[] index;
    private Object[] kvStore;
    private int kvStoreInsertionPos;
    private int indexGrowthThreshold;
    private static final int INDEX_SLOT_UNUSED = 0;
    static final int KEY_NOT_FOUND = -2;
    static final int HASH_NOT_FOUND = -2;
    public static final float THRESHOLD_LOAD_FACTOR_FOR_INDEX_REBUILD = 0.75f;

    public CompactHashStore(int capacity) {
        if (capacity < 1 || capacity >= 0x10000000) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        int kvCapacity = CompactHashStore.roundUpwardsToNearestPowerOf2(capacity);
        int indexCapacity = 2 * kvCapacity;
        this.index = new int[2 * indexCapacity];
        this.kvStore = new Object[2 * kvCapacity];
        this.kvStoreInsertionPos = 0;
        this.indexGrowthThreshold = (int)((float)indexCapacity * 0.75f);
    }

    private CompactHashStore(int[] index, Object[] kvStore, int kvStoreInsertionPos, int indexGrowthThreshold) {
        this.index = index;
        this.kvStore = kvStore;
        this.kvStoreInsertionPos = kvStoreInsertionPos;
        this.indexGrowthThreshold = indexGrowthThreshold;
    }

    private static int roundUpwardsToNearestPowerOf2(int num) {
        return Integer.highestOneBit(num) << 1;
    }

    private static int indexPosToKeyPos(int[] index, int indexPos) {
        return index[indexPos + 1] - 1;
    }

    private static int indexPosToValuePos(int[] index, int indexPos) {
        return index[indexPos + 1];
    }

    @ExportMessage
    Object lookupOrDefault(Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode, @Cached @Cached.Shared GetIndexPosForKeyNode getIndexPosForKeyNode, @Cached @Cached.Shared HashingNodes.ToHash hashFunction, @Cached @Cached.Exclusive InlinedConditionProfile keyNotFound, @Bind(value="$node") Node node) {
        int keyHash = hashFunction.execute(key, hash.compareByIdentity);
        int indexPos = getIndexPosForKeyNode.execute(node, key, keyHash, hash.compareByIdentity, this.index, this.kvStore, false);
        if (keyNotFound.profile(node, indexPos == -2)) {
            return defaultNode.accept(frame, hash, key);
        }
        int valuePos = CompactHashStore.indexPosToValuePos(this.index, indexPos);
        return this.kvStore[valuePos];
    }

    @ExportMessage
    boolean set(RubyHash hash, Object key, Object value, boolean byIdentity, @Cached @Cached.Shared HashingNodes.ToHash hashFunction, @Cached @Cached.Shared GetIndexPosForKeyNode getIndexPosForKeyNode, @Cached FreezeHashKeyIfNeededNode freezeKey, @Cached @Cached.Exclusive PropagateSharingNode propagateSharingForKey, @Cached @Cached.Exclusive PropagateSharingNode propagateSharingForVal, @Cached SetKvAtNode setKv, @Bind(value="$node") Node node) {
        Object frozenKey = freezeKey.executeFreezeIfNeeded(node, key, byIdentity);
        int keyHash = hashFunction.execute(frozenKey, byIdentity);
        int indexPos = getIndexPosForKeyNode.execute(node, frozenKey, keyHash, byIdentity, this.index, this.kvStore, true);
        int keyPos = CompactHashStore.indexPosToKeyPos(this.index, indexPos);
        propagateSharingForKey.execute(node, hash, frozenKey);
        propagateSharingForVal.execute(node, hash, value);
        return setKv.execute(node, hash, this, indexPos, keyPos, keyHash, frozenKey, value);
    }

    @ExportMessage
    Object delete(RubyHash hash, Object key, @Cached @Cached.Shared GetIndexPosForKeyNode getIndexPosForKeyNode, @Cached @Cached.Shared HashingNodes.ToHash hashFunction, @Cached @Cached.Exclusive InlinedConditionProfile keyNotFound, @Bind(value="$node") Node node) {
        int keyHash = hashFunction.execute(key, hash.compareByIdentity);
        int indexPos = getIndexPosForKeyNode.execute(node, key, keyHash, hash.compareByIdentity, this.index, this.kvStore, false);
        if (keyNotFound.profile(node, indexPos == -2)) {
            return null;
        }
        int keyPos = CompactHashStore.indexPosToKeyPos(this.index, indexPos);
        return this.deleteKvAndGetV(hash, indexPos, keyPos);
    }

    @ExportMessage
    Object deleteLast(RubyHash hash, Object key, @Cached @Cached.Shared HashingNodes.ToHash hashFunction, @Cached @Cached.Shared GetIndexPosFromKeyPosNode getIndexPosFromKeyPosNode, @Cached @Cached.Shared InlinedLoopConditionProfile nonNullKeyNotYetFound, @Bind(value="$node") Node node) {
        assert (hash.size > 0);
        int keyPos = this.firstNonNullKeyPosFromEnd(nonNullKeyNotYetFound, node);
        Object lastKey = this.kvStore[keyPos];
        if (key != lastKey) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("The last key was not " + String.valueOf(key) + " as expected but was " + String.valueOf(lastKey)));
        }
        int keyHash = hashFunction.execute(key, hash.compareByIdentity);
        int indexPos = getIndexPosFromKeyPosNode.execute(node, keyHash, keyPos, this.index);
        return this.deleteKvAndGetV(hash, indexPos, keyPos);
    }

    @ExportMessage
    RubyArray shift(RubyHash hash, @Cached @Cached.Shared HashingNodes.ToHash hashFunction, @Cached @Cached.Shared GetIndexPosFromKeyPosNode getIndexPosFromKeyPosNode, @Cached @Cached.Shared InlinedLoopConditionProfile nonNullKeyNotYetFound, @Bind(value="$node") Node node) {
        assert (hash.size > 0);
        int keyPos = this.firstNonNullKeyPosFromBeginning(nonNullKeyNotYetFound, node);
        Object key = this.kvStore[keyPos];
        int keyHash = hashFunction.execute(key, hash.compareByIdentity);
        int indexPos = getIndexPosFromKeyPosNode.execute(node, keyHash, keyPos, this.index);
        Object val = this.deleteKvAndGetV(hash, indexPos, keyPos);
        return ArrayHelpers.createArray(RubyContext.get(node), RubyLanguage.get(node), new Object[]{key, val});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    Object eachEntry(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @Cached @Cached.Exclusive InlinedConditionProfile keyNotNull, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @Bind(value="$node") Node node) {
        int i = 0;
        int callbackIdx = 0;
        try {
            while (loopProfile.inject(node, i < this.kvStoreInsertionPos)) {
                if (keyNotNull.profile(node, this.kvStore[i] != null)) {
                    callback.accept(callbackIdx, this.kvStore[i], this.kvStore[i + 1], state);
                    ++callbackIdx;
                }
                i += 2;
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(node, loopProfile, i >> 1);
        }
        return state;
    }

    @ExportMessage
    Object eachEntrySafe(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state, @CachedLibrary(value="this") HashStoreLibrary hashlib) {
        return hashlib.eachEntry(this, hash, callback, state);
    }

    @ExportMessage
    void replace(RubyHash hash, RubyHash dest, @Cached @Cached.Exclusive PropagateSharingNode propagateSharing, @Cached @Cached.Exclusive InlinedConditionProfile noReplaceNeeded, @Bind(value="$node") Node node) {
        if (noReplaceNeeded.profile(node, hash == dest)) {
            return;
        }
        propagateSharing.execute(node, dest, hash);
        CompactHashStore copy = this.copy();
        dest.size = hash.size;
        dest.store = copy;
        dest.compareByIdentity = hash.compareByIdentity;
        dest.defaultBlock = hash.defaultBlock;
        dest.defaultValue = hash.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    void rehash(RubyHash hash, @Cached @Cached.Exclusive InlinedConditionProfile slotUsed, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @CachedLibrary(value="this") HashStoreLibrary hashlib, @Bind(value="$node") Node node) {
        Object[] oldKvStore = this.kvStore;
        int oldKvStoreInsertionPos = this.kvStoreInsertionPos;
        this.kvStore = new Object[oldKvStore.length];
        this.kvStoreInsertionPos = 0;
        this.index = new int[this.index.length];
        hash.size = 0;
        int i = 0;
        try {
            while (loopProfile.inject(node, i < oldKvStoreInsertionPos)) {
                if (slotUsed.profile(node, oldKvStore[i] != null)) {
                    hashlib.set(this, hash, oldKvStore[i], oldKvStore[i + 1], hash.compareByIdentity);
                }
                i += 2;
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(node, loopProfile, i >> 1);
        }
    }

    @ExportMessage
    boolean verify(RubyHash hash) {
        assert (hash.store == this);
        assert (this.kvStoreInsertionPos >= 0);
        assert (this.kvStoreInsertionPos <= this.kvStore.length);
        assert (this.kvStoreInsertionPos % 2 == 0);
        assert (this.kvStoreInsertionPos >= hash.size);
        int indexCapacity = this.index.length >> 1;
        assert (hash.size < indexCapacity) : "there must be unused or deleted slots left, otherwise lookup can cycle";
        assert ((float)hash.size / (float)indexCapacity <= 0.75f);
        assert ((this.index.length & this.index.length - 1) == 0);
        this.assertAllKvPositionsAreValid();
        return true;
    }

    private void assertAllKvPositionsAreValid() {
        boolean foundAtLeastOneUnusedSlot = false;
        for (int indexPos = 0; indexPos < this.index.length; indexPos += 2) {
            int startPos;
            int valuePos = CompactHashStore.indexPosToValuePos(this.index, indexPos);
            if (valuePos == 0) {
                foundAtLeastOneUnusedSlot = true;
            }
            if (valuePos == 0) continue;
            assert (valuePos > 0);
            assert (valuePos < this.kvStoreInsertionPos);
            assert ((valuePos & 1) == 1);
            int keyPos = valuePos - 1;
            assert (this.kvStore[keyPos] != null);
            assert (this.kvStore[valuePos] != null);
            int hashCode = this.index[indexPos];
            int i = startPos = CompactHashStore.indexPosFromHashCode(hashCode, this.index.length);
            while (i != indexPos) {
                assert (CompactHashStore.indexPosToValuePos(this.index, i) > 0);
                i = CompactHashStore.incrementIndexPos(i, this.index.length);
            }
        }
        assert (foundAtLeastOneUnusedSlot);
    }

    private Object deleteKvAndGetV(RubyHash hash, int indexPos, int keyPos) {
        assert (this.verify(hash));
        this.index[indexPos] = 0;
        this.index[indexPos + 1] = 0;
        int reusePos = indexPos;
        int nextPos = CompactHashStore.incrementIndexPos(indexPos, this.index.length);
        while (CompactHashStore.indexPosToValuePos(this.index, nextPos) != 0) {
            int hashCode;
            int startPos;
            if (nextPos < reusePos ^ (startPos = CompactHashStore.indexPosFromHashCode(hashCode = this.index[nextPos], this.index.length)) <= reusePos ^ startPos > nextPos) {
                assert (this.index[reusePos + 1] == 0) : "safe to move the slot to reuse slot";
                this.index[reusePos] = this.index[nextPos];
                this.index[reusePos + 1] = this.index[nextPos + 1];
                this.index[nextPos] = 0;
                this.index[nextPos + 1] = 0;
                reusePos = nextPos;
            }
            nextPos = CompactHashStore.incrementIndexPos(nextPos, this.index.length);
            assert (nextPos != indexPos);
        }
        Object deletedValue = this.kvStore[keyPos + 1];
        this.kvStore[keyPos] = null;
        this.kvStore[keyPos + 1] = null;
        if (keyPos + 2 == this.kvStoreInsertionPos) {
            this.kvStoreInsertionPos = keyPos;
        }
        --hash.size;
        assert (this.verify(hash));
        return deletedValue;
    }

    private int firstNonNullKeyPosFromEnd(InlinedLoopConditionProfile nonNullKeyNotYetFound, Node node) {
        int lastKeyPos = this.kvStoreInsertionPos - 2;
        while (nonNullKeyNotYetFound.profile(node, lastKeyPos > 0 && this.kvStore[lastKeyPos] == null)) {
            lastKeyPos -= 2;
        }
        assert (this.kvStore[lastKeyPos] != null);
        return lastKeyPos;
    }

    private int firstNonNullKeyPosFromBeginning(InlinedLoopConditionProfile nonNullKeyNotYetFound, Node node) {
        int firstKeyPos = 0;
        while (nonNullKeyNotYetFound.profile(node, firstKeyPos < this.kvStoreInsertionPos && this.kvStore[firstKeyPos] == null)) {
            firstKeyPos += 2;
        }
        assert (firstKeyPos < this.kvStoreInsertionPos);
        return firstKeyPos;
    }

    private CompactHashStore copy() {
        return new CompactHashStore((int[])this.index.clone(), (Object[])this.kvStore.clone(), this.kvStoreInsertionPos, this.indexGrowthThreshold);
    }

    private static int indexPosFromHashCode(int hashCode, int indexLength) {
        return hashCode & indexLength - 2;
    }

    private static int incrementIndexPos(int pos, int indexLength) {
        return pos + 2 & indexLength - 1;
    }

    public void getAdjacentObjects(Set<Object> reachable) {
        for (int i = 0; i < this.kvStoreInsertionPos; i += 2) {
            if (this.kvStore[i] == null) continue;
            ObjectGraph.addProperty(reachable, this.kvStore[i]);
            ObjectGraph.addProperty(reachable, this.kvStore[i + 1]);
        }
    }

    void insertHashKeyValue(int hashCode, Object key, Object value) {
        int keyPos = this.kvStoreInsertionPos;
        int valuePos = keyPos + 1;
        SetKvAtNode.insertIntoKv(this, keyPos, key, value);
        SetKvAtNode.insertIntoIndex(hashCode, valuePos, this.index);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class GetIndexPosForKeyNode
    extends RubyBaseNode {
        GetIndexPosForKeyNode() {
        }

        public abstract int execute(Node var1, Object var2, int var3, boolean var4, int[] var5, Object[] var6, boolean var7);

        @Specialization
        static int findIndexPos(Node node, Object key, int hash, boolean compareByIdentity, int[] index, Object[] kvStore, boolean insert, @Cached CompareHashKeysNode.AssumingEqualHashes compareHashKeysNode, @Cached @Cached.Exclusive InlinedConditionProfile unused, @Cached @Cached.Exclusive InlinedConditionProfile sameHash) {
            int startPos;
            CompilerAsserts.partialEvaluationConstant((boolean)insert);
            int indexPos = startPos = CompactHashStore.indexPosFromHashCode(hash, index.length);
            while (true) {
                int valuePos;
                if (unused.profile(node, (valuePos = CompactHashStore.indexPosToValuePos(index, indexPos)) == 0)) {
                    return insert ? indexPos : -2;
                }
                if (sameHash.profile(node, index[indexPos] == hash) && compareHashKeysNode.execute(node, compareByIdentity, key, kvStore[valuePos - 1])) {
                    return indexPos;
                }
                indexPos = CompactHashStore.incrementIndexPos(indexPos, index.length);
                assert (indexPos != startPos);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class SetKvAtNode
    extends RubyBaseNode {
        SetKvAtNode() {
        }

        public abstract boolean execute(Node var1, RubyHash var2, CompactHashStore var3, int var4, int var5, int var6, Object var7, Object var8);

        @Specialization(guards={"keyPos >= 0"})
        static boolean keyAlreadyExistsWithDifferentValue(Node node, RubyHash hash, CompactHashStore store, int indexPos, int keyPos, int keyHash, Object key, Object value) {
            store.kvStore[keyPos + 1] = value;
            return false;
        }

        @Specialization(guards={"keyPos < 0"})
        @SuppressFBWarnings(value={"IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN"})
        static boolean keyDoesntExist(Node node, RubyHash hash, CompactHashStore store, int indexPos, int keyPos, int keyHash, Object key, Object value, @Cached @Cached.Exclusive InlinedConditionProfile kvResizingIsNeeded, @Cached @Cached.Exclusive InlinedConditionProfile indexResizingIsNeeded) {
            if (kvResizingIsNeeded.profile(node, store.kvStoreInsertionPos >= store.kvStore.length)) {
                SetKvAtNode.resizeKvStore(store);
            }
            keyPos = store.kvStoreInsertionPos;
            SetKvAtNode.insertIntoKv(store, keyPos, key, value);
            assert (store.index[indexPos + 1] <= 0);
            store.index[indexPos] = keyHash;
            store.index[indexPos + 1] = keyPos + 1;
            ++hash.size;
            if (indexResizingIsNeeded.profile(node, hash.size >= store.indexGrowthThreshold)) {
                SetKvAtNode.resizeIndex(store);
            }
            return true;
        }

        private static void insertIntoIndex(int hashCode, int valuePos, int[] index) {
            int pos = CompactHashStore.indexPosFromHashCode(hashCode, index.length);
            while (index[pos + 1] > 0) {
                pos = CompactHashStore.incrementIndexPos(pos, index.length);
            }
            index[pos] = hashCode;
            index[pos + 1] = valuePos;
        }

        private static void insertIntoKv(CompactHashStore store, int keyPos, Object key, Object value) {
            store.kvStore[keyPos] = key;
            store.kvStore[keyPos + 1] = value;
            store.kvStoreInsertionPos = keyPos + 2;
        }

        @CompilerDirectives.TruffleBoundary
        private static void resizeIndex(CompactHashStore store) {
            int[] oldIndex = store.index;
            int[] newIndex = new int[2 * oldIndex.length];
            int newIndexCapacity = newIndex.length >> 1;
            for (int i = 0; i < oldIndex.length; i += 2) {
                int hash = oldIndex[i];
                int valuePos = oldIndex[i + 1];
                if (valuePos <= 0) continue;
                SetKvAtNode.insertIntoIndex(hash, valuePos, newIndex);
            }
            store.index = newIndex;
            store.indexGrowthThreshold = (int)((float)newIndexCapacity * 0.75f);
        }

        private static void resizeKvStore(CompactHashStore store) {
            store.kvStore = ArrayUtils.grow(store.kvStore, 2 * store.kvStore.length);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class GetIndexPosFromKeyPosNode
    extends RubyBaseNode {
        GetIndexPosFromKeyPosNode() {
        }

        public abstract int execute(Node var1, int var2, int var3, int[] var4);

        @Specialization
        static int findIndexPos(Node node, int hash, int keyPos, int[] index, @Cached @Cached.Exclusive InlinedConditionProfile unused, @Cached @Cached.Exclusive InlinedConditionProfile found) {
            int startPos;
            int valuePosToSearch = keyPos + 1;
            int indexPos = startPos = CompactHashStore.indexPosFromHashCode(hash, index.length);
            while (true) {
                int valuePos;
                if (!unused.profile(node, (valuePos = CompactHashStore.indexPosToValuePos(index, indexPos)) == 0) && found.profile(node, valuePos == valuePosToSearch)) {
                    return indexPos;
                }
                indexPos = CompactHashStore.incrementIndexPos(indexPos, index.length);
                assert (indexPos != startPos);
            }
        }
    }

    public static final class CompactHashLiteralNode
    extends HashLiteralNode {
        @Node.Child
        HashStoreLibrary hashes = (HashStoreLibrary)this.insert((Node)HashStoreLibrary.createDispatched());

        public CompactHashLiteralNode(RubyNode[] keyValues) {
            super(keyValues);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            CompactHashStore store = new CompactHashStore(this.getNumberOfEntries());
            RubyHash hash = new RubyHash(this.coreLibrary().hashClass, this.getLanguage().hashShape, this.getContext(), store, 0, false);
            for (int i = 0; i < this.keyValues.length; i += 2) {
                Object key = this.keyValues[i].execute(frame);
                Object value = this.keyValues[i + 1].execute(frame);
                this.hashes.set(store, hash, key, value, false);
            }
            return hash;
        }

        @Override
        public RubyNode cloneUninitialized() {
            CompactHashLiteralNode copy = new CompactHashLiteralNode(CompactHashLiteralNode.cloneUninitialized(this.keyValues));
            return copy.copyFlags(this);
        }
    }
}

