/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.HashSubtractKeysNodeGen;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="hashNode", type=RubyNode.class)
public abstract class HashSubtractKeysNode
extends RubyContextSourceNode
implements HashStoreLibrary.EachEntryCallback {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RubySymbol[] excludedKeys;
    @Node.Child
    private HashStoreLibrary hashes = HashStoreLibrary.createDispatched();

    public HashSubtractKeysNode(RubySymbol[] excludedKeys) {
        assert (excludedKeys.length > 0) : "unnecessary";
        this.excludedKeys = excludedKeys;
    }

    abstract RubyNode getHashNode();

    @Specialization
    RubyHash remainingKeys(RubyHash hash) {
        RubyHash rest = HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
        this.hashes.eachEntry(hash.store, hash, this, rest);
        return rest;
    }

    @Override
    public void accept(int index, Object key, Object value, Object state) {
        if (!this.keyExcluded(key)) {
            RubyHash rest = (RubyHash)state;
            this.hashes.set(rest.store, rest, key, value, false);
        }
    }

    @ExplodeLoop
    private boolean keyExcluded(Object key) {
        for (RubySymbol excludedKey : this.excludedKeys) {
            if (excludedKey != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return HashSubtractKeysNodeGen.create(this.excludedKeys, this.getHashNode().cloneUninitialized()).copyFlags(this);
    }
}

