/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.hash.HashPatternLengthCheckNodeGen;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="valueNode", type=RubyNode.class)
public abstract class HashPatternLengthCheckNode
extends RubyContextSourceNode {
    private final int minimumKeys;

    public HashPatternLengthCheckNode(int minimumKeys) {
        this.minimumKeys = minimumKeys;
    }

    abstract RubyNode getValueNode();

    @Specialization
    boolean hashLengthCheck(RubyHash matchHash) {
        return this.minimumKeys <= matchHash.size;
    }

    @Fallback
    boolean notHash(Object value) {
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return HashPatternLengthCheckNodeGen.create(this.minimumKeys, this.getValueNode().cloneUninitialized()).copyFlags(this);
    }
}

