/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.CachedLibrary;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.hash.HashGetOrUndefinedNodeGen;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@ImportStatic(value={HashGuards.class})
@NodeChild(value="hashNode", type=RubyNode.class)
public abstract class HashGetOrUndefinedNode
extends RubyContextSourceNode
implements PEBiFunction {
    private final RubySymbol key;

    public HashGetOrUndefinedNode(RubySymbol key) {
        this.key = key;
    }

    abstract RubyNode getHashNode();

    @Specialization(limit="hashStrategyLimit()")
    Object get(RubyHash hash, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
        return hashes.lookupOrDefault(hash.store, null, hash, this.key, this);
    }

    @Override
    public Object accept(Frame frame, Object hash, Object key) {
        return NotProvided.INSTANCE;
    }

    @Override
    public RubyNode cloneUninitialized() {
        HashGetOrUndefinedNode copy = HashGetOrUndefinedNodeGen.create(this.key, this.getHashNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

