/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.RangeException;

@NodeChild(value="value")
public abstract class WriteUTF8CharacterNode
extends FormatNode {
    @Specialization(guards={"value >= 0", "value <= 0x7f"})
    Object writeSingleByte(VirtualFrame frame, long value) {
        this.writeByte(frame, (byte)value);
        return null;
    }

    @Specialization(guards={"value > 0x7f", "value <= 0x7ff"})
    Object writeTwoBytes(VirtualFrame frame, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 6 & 0xFFL | 0xC0L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        return null;
    }

    @Specialization(guards={"value > 0x7ff", "value <= 0xffff"})
    Object writeThreeBytes(VirtualFrame frame, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 12 & 0xFFL | 0xE0L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        return null;
    }

    @Specialization(guards={"value > 0xffff", "value <= 0x1fffff"})
    Object writeFourBytes(VirtualFrame frame, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 18 & 0xFFL | 0xF0L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        return null;
    }

    @Specialization(guards={"value > 0x1fffff", "value <= 0x3ffffff"})
    Object writeFiveBytes(VirtualFrame frame, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24 & 0xFFL | 0xF8L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        return null;
    }

    @Specialization(guards={"value > 0x3ffffff", "value <= 0x7fffffff"})
    Object writeSixBytes(VirtualFrame frame, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 30 & 0xFFL | 0xFCL), (byte)(value >>> 24 & 0x3FL | 0x80L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        return null;
    }

    @Specialization(guards={"value < 0"})
    Object writeNegative(long value) {
        throw new RangeException("pack(U): value out of range");
    }

    @Specialization(guards={"value > 0x7fffffff"})
    Object writeOutOfRange(long value) {
        throw new RangeException("pack(U): value out of range");
    }
}

