/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.unpack;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.format.FormatFrameDescriptor;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.unpack.ArrayResult;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.backtrace.InternalRootNode;

public final class UnpackRootNode
extends RubyBaseRootNode
implements InternalRootNode {
    private final RubyLanguage language;
    @Node.Child
    private FormatNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength;

    public UnpackRootNode(RubyLanguage language, SourceSection sourceSection, FormatNode child) {
        super(language, FormatFrameDescriptor.FRAME_DESCRIPTOR, sourceSection);
        this.language = language;
        this.child = child;
        this.expectedLength = language.options.ARRAY_UNINITIALIZED_SIZE;
    }

    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        frame.setObject(FormatFrameDescriptor.SOURCE_SLOT, arguments[0]);
        frame.setInt(FormatFrameDescriptor.SOURCE_END_POSITION_SLOT, ((Integer)arguments[1]).intValue());
        frame.setInt(FormatFrameDescriptor.SOURCE_START_POSITION_SLOT, ((Integer)arguments[2]).intValue());
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, ((Integer)arguments[2]).intValue());
        frame.setObject(FormatFrameDescriptor.SOURCE_ASSOCIATED_SLOT, arguments[3]);
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, (Object)new Object[this.expectedLength]);
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, 0);
        this.child.execute(frame);
        int outputLength = frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = ArrayUtils.capacity(this.language, this.expectedLength, outputLength);
        }
        Object[] output = (Object[])frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
        return new ArrayResult(output, outputLength);
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public String getName() {
        return "unpack";
    }

    public String toString() {
        return this.getName();
    }
}

