/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.unpack;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.format.LoopRecovery;
import org.truffleruby.core.format.pack.SimplePackParser;
import org.truffleruby.core.format.unpack.SimpleUnpackTreeBuilder;
import org.truffleruby.core.format.unpack.UnpackRootNode;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.control.DeferredRaiseException;

public final class UnpackCompiler {
    private final RubyLanguage language;
    private final Node currentNode;

    public UnpackCompiler(RubyLanguage language, Node currentNode) {
        this.language = language;
        this.currentNode = currentNode;
    }

    public RootCallTarget compile(String format) throws DeferredRaiseException {
        if (format.length() > this.language.options.PACK_RECOVER_LOOP_MIN) {
            format = LoopRecovery.recoverLoop(format);
        }
        SimpleUnpackTreeBuilder builder = new SimpleUnpackTreeBuilder(this.language, this.currentNode);
        builder.enterSequence();
        SimplePackParser parser = new SimplePackParser(builder, StringOperations.encodeAsciiBytes(format));
        parser.parse();
        builder.exitSequence();
        return new UnpackRootNode(this.language, this.currentNode.getEncapsulatingSourceSection(), builder.getNode()).getCallTarget();
    }
}

