/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatFrameDescriptor;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.MissingValue;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.Nil;
import org.truffleruby.language.control.RaiseException;

@NodeChild(value="value")
public abstract class ReadStringPointerNode
extends FormatNode {
    @Node.Child
    private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();
    private final BranchProfile errorProfile = BranchProfile.create();
    private final int limit;

    public ReadStringPointerNode(int limit) {
        this.limit = limit;
    }

    @Specialization
    MissingValue decode(Nil nil) {
        return MissingValue.INSTANCE;
    }

    @Specialization
    RubyString read(VirtualFrame frame, long address, @CachedLibrary(limit="1") InteropLibrary interop) {
        Pointer pointer = new Pointer(this.getContext(), address);
        this.checkAssociated((Pointer[])frame.getObject(FormatFrameDescriptor.SOURCE_ASSOCIATED_SLOT), pointer);
        byte[] bytes = pointer.readZeroTerminatedByteArray(this.getContext(), interop, 0L, this.limit);
        return this.createString(this.fromByteArrayNode, bytes, Encodings.US_ASCII);
    }

    private void checkAssociated(Pointer[] associated, Pointer reading) {
        if (associated != null) {
            for (Pointer pointer : associated) {
                if (!pointer.equals(reading)) continue;
                return;
            }
        }
        this.errorProfile.enter();
        throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError("no associated pointer", this));
    }
}

