/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadMIMEStringNode
extends FormatNode {
    @Specialization
    Object read(VirtualFrame frame, byte[] source, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        int position = this.getSourcePosition(frame);
        int end = this.getSourceEnd(frame);
        byte[] store = new byte[end - position];
        int storeIndex = this.parseSource(source, position, end, store);
        this.setSourcePosition(frame, end);
        TruffleString tstring = fromByteArrayNode.execute(store, 0, storeIndex, Encodings.BINARY.tencoding, true);
        return this.createString(tstring, Encodings.BINARY);
    }

    @CompilerDirectives.TruffleBoundary
    private int parseSource(byte[] source, int position, int end, byte[] store) {
        int storeLength;
        int sourceLength = end - position;
        int storeIndex = 0;
        int loopIndex = 0;
        if (sourceLength > 0) {
            int i = position;
            int c = source[i] & 0xFF;
            while (i < end) {
                if (c == 61) {
                    if (++i == end) break;
                    c = source[i] & 0xFF;
                    if (i + 1 < end && c == 13 && (source[i + 1] & 0xFF) == 10) {
                        c = source[++i] & 0xFF;
                    }
                    if (c != 10) {
                        byte value;
                        int c2;
                        int c1 = Character.digit(c, 16);
                        if (c1 == -1 || ++i == end || (c2 = Character.digit(c = source[i] & 0xFF, 16)) == -1) break;
                        store[storeIndex] = value = (byte)(c1 << 4 | c2);
                        ++storeIndex;
                    }
                } else {
                    store[storeIndex] = (byte)c;
                    ++storeIndex;
                }
                if (++i < end) {
                    c = source[i] & 0xFF;
                }
                loopIndex = i - position;
            }
        }
        if (loopIndex < (storeLength = store.length)) {
            int left = storeLength - loopIndex;
            System.arraycopy(source, position + loopIndex, store, storeIndex, left);
            storeIndex += left;
        }
        return storeIndex;
    }
}

