/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadBitStringNode
extends FormatNode {
    @Node.Child
    private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public ReadBitStringNode(ByteOrder byteOrder, boolean star, int length) {
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    Object read(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = this.wrapByteBuffer(frame, source);
        int occurrences = this.star || this.length > encode.remaining() * 8 ? encode.remaining() * 8 : this.length;
        byte[] lElem = new byte[occurrences];
        int bitsMask = this.byteOrder == ByteOrder.BIG_ENDIAN ? 128 : 1;
        int bits = 0;
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 7) != 0 ? (this.byteOrder == ByteOrder.BIG_ENDIAN ? (bits <<= 1) : (bits >>>= 1)) : encode.get();
            lElem[lCurByte] = (bits & bitsMask) != 0 ? 49 : 48;
        }
        this.setSourcePosition(frame, encode.position());
        return this.createString(this.fromByteArrayNode, lElem, Encodings.US_ASCII);
    }
}

