/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.LiteralFormatNode;
import org.truffleruby.core.format.convert.ToStringNode;
import org.truffleruby.core.format.convert.ToStringNodeGen;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.format.write.bytes.WriteByteNodeGen;

@NodeChild(value="source", type=SourceNode.class)
@ImportStatic(value={ArrayGuards.class})
public abstract class ReadStringNode
extends FormatNode {
    private final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    private final boolean specialClassBehaviour;
    @Node.Child
    private ToStringNode toStringNode;

    public ReadStringNode(boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        this(convertNumbersToStrings, conversionMethod, inspectOnConversionFailure, valueOnNil, false);
    }

    public ReadStringNode(boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil, boolean specialClassBehaviour) {
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
        this.specialClassBehaviour = specialClassBehaviour;
    }

    @Specialization(limit="storageStrategyLimit()")
    Object read(VirtualFrame frame, Object source, @CachedLibrary(value="source") ArrayStoreLibrary sources) {
        return this.readAndConvert(sources.read(source, this.advanceSourcePosition(frame)));
    }

    private Object readAndConvert(Object value) {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = (ToStringNode)this.insert(ToStringNodeGen.create(this.convertNumbersToStrings, this.conversionMethod, this.inspectOnConversionFailure, this.valueOnNil, this.specialClassBehaviour, WriteByteNodeGen.create(new LiteralFormatNode((byte)0))));
        }
        return this.toStringNode.executeToString(value);
    }
}

