/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.rbsprintf;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.List;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.LiteralFormatNode;
import org.truffleruby.core.format.SharedTreeBuilder;
import org.truffleruby.core.format.convert.ToIntegerNodeGen;
import org.truffleruby.core.format.convert.ToNumberWithCoercionNodeGen;
import org.truffleruby.core.format.convert.ToStringNodeGen;
import org.truffleruby.core.format.format.FormatAFloatNodeGen;
import org.truffleruby.core.format.format.FormatCharacterNode;
import org.truffleruby.core.format.format.FormatCharacterNodeGen;
import org.truffleruby.core.format.format.FormatEFloatNodeGen;
import org.truffleruby.core.format.format.FormatFFloatNodeGen;
import org.truffleruby.core.format.format.FormatGFloatNodeGen;
import org.truffleruby.core.format.format.FormatIntegerBinaryNodeGen;
import org.truffleruby.core.format.format.FormatIntegerNodeGen;
import org.truffleruby.core.format.rbsprintf.RBSprintfConfig;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.format.read.array.ReadArgumentIndexValueNodeGen;
import org.truffleruby.core.format.read.array.ReadCStringNodeGen;
import org.truffleruby.core.format.read.array.ReadCValueNodeGen;
import org.truffleruby.core.format.read.array.ReadIntegerNodeGen;
import org.truffleruby.core.format.read.array.ReadStringNodeGen;
import org.truffleruby.core.format.read.array.ReadValueNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBytesNodeGen;
import org.truffleruby.core.format.write.bytes.WritePaddedBytesNodeGen;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.string.ImmutableRubyString;

public final class RBSprintfSimpleTreeBuilder {
    private final List<FormatNode> sequence = new ArrayList<FormatNode>();
    private final List<RBSprintfConfig> configs;
    private final Object stringReader;
    private final RubyEncoding encoding;
    public static final int DEFAULT = Integer.MIN_VALUE;
    private static final ImmutableRubyString EMPTY_STRING = FrozenStrings.EMPTY_US_ASCII;

    public RBSprintfSimpleTreeBuilder(List<RBSprintfConfig> configs, Object stringReader, RubyEncoding encoding) {
        this.configs = configs;
        this.stringReader = stringReader;
        this.encoding = encoding;
    }

    private void buildTree() {
        for (RBSprintfConfig config : this.configs) {
            FormatNode node;
            if (config.isLiteral()) {
                node = WriteBytesNodeGen.create(new LiteralFormatNode(config.getLiteralBytes()));
            } else {
                FormatNode valueNode = config.getAbsoluteArgumentIndex() != null ? ReadArgumentIndexValueNodeGen.create(config.getAbsoluteArgumentIndex(), new SourceNode()) : ReadValueNodeGen.create(new SourceNode());
                FormatNode widthNode = config.isWidthStar() ? ReadIntegerNodeGen.create(new SourceNode()) : (config.isArgWidth() ? ReadArgumentIndexValueNodeGen.create(config.getWidth(), new SourceNode()) : new LiteralFormatNode(config.getWidth() == null ? -1 : config.getWidth()));
                FormatNode precisionNode = config.isPrecisionStar() ? ReadIntegerNodeGen.create(new SourceNode()) : (config.isPrecisionArg() ? ReadArgumentIndexValueNodeGen.create(config.getPrecision(), new SourceNode()) : new LiteralFormatNode(config.getPrecision() == null ? -1 : config.getPrecision()));
                block0 : switch (config.getFormatType()) {
                    case POINTER: 
                    case INTEGER: {
                        char format = switch (config.getFormat()) {
                            case 'B', 'X', 'b', 'p', 'x' -> config.getFormat();
                            case 'd', 'i', 'u' -> 'd';
                            case 'o' -> 'o';
                            default -> throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(config.getFormat()));
                        };
                        switch (config.getFormat()) {
                            case 'B': 
                            case 'b': {
                                node = WriteBytesNodeGen.create(FormatIntegerBinaryNodeGen.create(format, config.isPlus(), config.isFsharp(), config.isMinus(), config.isHasSpace(), config.isZero(), widthNode, precisionNode, ToIntegerNodeGen.create(valueNode)));
                                break block0;
                            }
                            case 'p': {
                                node = WriteBytesNodeGen.create(FormatIntegerNodeGen.create(format, config.isPlus(), config.isFsharp(), config.isMinus(), config.isHasSpace(), true, widthNode, precisionNode, ToIntegerNodeGen.create(valueNode)));
                                break block0;
                            }
                        }
                        node = WriteBytesNodeGen.create(FormatIntegerNodeGen.create(format, config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToIntegerNodeGen.create(valueNode)));
                        break;
                    }
                    case FLOAT: {
                        switch (config.getFormat()) {
                            case 'A': 
                            case 'a': {
                                node = WriteBytesNodeGen.create(FormatAFloatNodeGen.create(config.getFormat(), config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToNumberWithCoercionNodeGen.create(valueNode)));
                                break block0;
                            }
                            case 'E': 
                            case 'e': {
                                node = WriteBytesNodeGen.create(FormatEFloatNodeGen.create(config.getFormat(), config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToNumberWithCoercionNodeGen.create(valueNode)));
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                node = WriteBytesNodeGen.create(FormatGFloatNodeGen.create(config.getFormat(), config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToNumberWithCoercionNodeGen.create(valueNode)));
                                break block0;
                            }
                            case 'f': {
                                node = WriteBytesNodeGen.create(FormatFFloatNodeGen.create(config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToNumberWithCoercionNodeGen.create(valueNode)));
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case OTHER: {
                        FormatNode conversionNode;
                        switch (config.getFormat()) {
                            case 'c': {
                                FormatCharacterNode characterConversionNode = FormatCharacterNodeGen.create(this.encoding, valueNode);
                                if (config.getWidth() != null || config.isWidthStar()) {
                                    LiteralFormatNode characterPrecisionNode = new LiteralFormatNode(Integer.MIN_VALUE);
                                    node = WritePaddedBytesNodeGen.create(config.isMinus(), widthNode, characterPrecisionNode, characterConversionNode);
                                    break block0;
                                }
                                node = WriteBytesNodeGen.create(characterConversionNode);
                                break block0;
                            }
                            case 's': {
                                conversionNode = ReadCStringNodeGen.create(this.stringReader, valueNode);
                                if (config.getWidth() != null || config.isWidthStar() || config.getPrecision() != null || config.isPrecisionStar()) {
                                    node = WritePaddedBytesNodeGen.create(config.isMinus(), widthNode, precisionNode, conversionNode);
                                    break block0;
                                }
                                node = WriteBytesNodeGen.create(conversionNode);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case RUBY_VALUE: {
                        String conversionMethodName;
                        String string = conversionMethodName = config.isPlus() ? "inspect" : "to_s";
                        FormatNode conversionNode = config.getFormatArgumentType() == RBSprintfConfig.FormatArgumentType.VALUE ? (config.getAbsoluteArgumentIndex() == null ? ReadStringNodeGen.create(true, conversionMethodName, false, EMPTY_STRING, config.isPlus(), new SourceNode()) : ToStringNodeGen.create(true, conversionMethodName, false, EMPTY_STRING, config.isPlus(), valueNode)) : ToStringNodeGen.create(true, conversionMethodName, false, EMPTY_STRING, config.isPlus(), config.getAbsoluteArgumentIndex() == null ? ReadCValueNodeGen.create(ReadIntegerNodeGen.create(new SourceNode())) : ReadCValueNodeGen.create(valueNode));
                        if (config.getWidth() != null || config.isWidthStar() || config.getPrecision() != null || config.isPrecisionStar()) {
                            node = WritePaddedBytesNodeGen.create(config.isMinus(), widthNode, precisionNode, conversionNode);
                            break;
                        }
                        node = WriteBytesNodeGen.create(conversionNode);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported type: " + config.getFormatType().toString());
                    }
                }
            }
            this.sequence.add(node);
        }
    }

    public FormatNode getNode() {
        this.buildTree();
        return SharedTreeBuilder.createSequence(this.sequence.toArray(FormatNode.EMPTY_ARRAY));
    }
}

