/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.rbsprintf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.rbsprintf.RBSprintfConfig;

public final class RBSprintfSimpleParser {
    private final char[] source;

    public RBSprintfSimpleParser(char[] source) {
        this.source = source;
    }

    public List<RBSprintfConfig> parse() {
        ArrayList<RBSprintfConfig> configs = new ArrayList<RBSprintfConfig>();
        ArgType argType = ArgType.NONE;
        int end = this.source.length;
        int i = 0;
        while (i < end) {
            RBSprintfConfig config;
            int literalEnd;
            for (literalEnd = i; literalEnd < end && this.source[literalEnd] != '%'; ++literalEnd) {
            }
            int literalLength = literalEnd - i;
            if (literalLength > 0) {
                config = new RBSprintfConfig();
                config.setLiteral(true);
                char[] literalBytes = new char[literalLength];
                System.arraycopy(this.source, i, literalBytes, 0, literalLength);
                config.setLiteralBytes(RBSprintfSimpleParser.charsToBytes(literalBytes));
                configs.add(config);
            }
            if (literalEnd >= end) break;
            i = literalEnd + 1;
            config = new RBSprintfConfig();
            configs.add(config);
            boolean finished = false;
            boolean argTypeSet = false;
            block25: while (!finished) {
                char p = i >= this.source.length ? (char)'\u0000' : this.source[i];
                switch (p) {
                    case ' ': {
                        config.checkForFlags();
                        config.setHasSpace(true);
                        ++i;
                        continue block25;
                    }
                    case '#': {
                        config.checkForFlags();
                        config.setFsharp(true);
                        ++i;
                        continue block25;
                    }
                    case '+': {
                        config.checkForFlags();
                        config.setPlus(true);
                        ++i;
                        continue block25;
                    }
                    case '-': {
                        config.checkForFlags();
                        config.setMinus(true);
                        ++i;
                        continue block25;
                    }
                    case '\'': {
                        config.checkForFlags();
                        config.setSeparator(true);
                        ++i;
                        continue block25;
                    }
                    case '0': {
                        config.checkForFlags();
                        config.setZero(true);
                        ++i;
                        continue block25;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        LookAheadResult r = this.getNum(i, end);
                        i = r.getNextI();
                        if (this.valueAt(i) != null && this.valueAt(i).charValue() == '$') {
                            if (config.getAbsoluteArgumentIndex() != null) {
                                throw new InvalidFormatException("value given twice - " + r.getNumber() + "$");
                            }
                            RBSprintfSimpleParser.checkPosArg(argType, r.getNumber());
                            argType = ArgType.NUMBERED;
                            argTypeSet = true;
                            config.setAbsoluteArgumentIndex(r.getNumber());
                            ++i;
                            continue block25;
                        }
                        config.checkForWidth();
                        config.setWidth(r.getNumber());
                        continue block25;
                    }
                    case '*': {
                        config.checkForWidth();
                        if (config.hasFormatArgumentType()) {
                            throw new InvalidFormatException("width given after length or type");
                        }
                        LookAheadResult numberDollarWidth = this.getNumberDollar(i + 1, end);
                        if (numberDollarWidth.getNumber() != null) {
                            config.setArgWidth(true);
                            config.setWidth(numberDollarWidth.getNumber());
                            RBSprintfSimpleParser.checkPosArg(argType, numberDollarWidth.getNumber());
                            argType = ArgType.NUMBERED;
                            i = numberDollarWidth.getNextI();
                            continue block25;
                        }
                        RBSprintfSimpleParser.checkNextArg(argType, 1);
                        argType = ArgType.UNNUMBERED;
                        config.setWidthStar(true);
                        ++i;
                        continue block25;
                    }
                    case '.': {
                        if (config.hasFormatArgumentType()) {
                            throw new InvalidFormatException("precision given after length or type");
                        }
                        if (config.hasPrecision()) {
                            throw new InvalidFormatException("precision given twice");
                        }
                        config.setPrecisionVisited(true);
                        if (this.valueAt(i + 1) != null && this.valueAt(i + 1).charValue() == '*') {
                            LookAheadResult numberDollar = this.getNumberDollar(i + 2, end);
                            if (numberDollar.getNumber() != null) {
                                config.setPrecision(numberDollar.getNumber());
                                config.setPrecisionArg(true);
                                RBSprintfSimpleParser.checkPosArg(argType, numberDollar.getNumber());
                                argType = ArgType.NUMBERED;
                                i = numberDollar.getNextI();
                                continue block25;
                            }
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                            config.setPrecisionStar(true);
                            i += 2;
                            continue block25;
                        }
                        LookAheadResult re = this.getNum(i + 1, end);
                        config.setPrecision(re.getNumber());
                        i = re.getNextI();
                        continue block25;
                    }
                    case 'h': {
                        char next;
                        config.checkForFormatArgumentType();
                        int j = i + 1;
                        char c = next = j >= this.source.length ? (char)'\u0000' : this.source[j];
                        if (next == 'h') {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.CHAR);
                            ++i;
                        } else {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.SHORT);
                        }
                        ++i;
                        continue block25;
                    }
                    case 'l': {
                        char next;
                        config.checkForFormatArgumentType();
                        int j = i + 1;
                        char c = next = j >= this.source.length ? (char)'\u0000' : this.source[j];
                        if (next == 'l') {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.LONGLONG);
                            ++i;
                        } else {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.LONG);
                        }
                        ++i;
                        continue block25;
                    }
                    case 'L': {
                        config.checkForFormatArgumentType();
                        config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.LONGDOUBLE);
                        ++i;
                        continue block25;
                    }
                    case 'z': {
                        config.checkForFormatArgumentType();
                        config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.SIZE_T);
                        ++i;
                        continue block25;
                    }
                    case 'j': {
                        config.checkForFormatArgumentType();
                        config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.INTMAX_T);
                        ++i;
                        continue block25;
                    }
                    case 't': {
                        config.checkForFormatArgumentType();
                        config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.PTRDIFF_T);
                        ++i;
                        continue block25;
                    }
                    case '%': {
                        if (config.hasFlags()) {
                            throw new InvalidFormatException("invalid format character - %");
                        }
                        config.setLiteral(true);
                        config.setLiteralBytes(new byte[]{37});
                        if (p == '%') {
                            ++i;
                        }
                        finished = true;
                        continue block25;
                    }
                    case 'c': 
                    case 's': {
                        config.checkForFormatArgumentType();
                        if (p == 'c') {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.CHAR);
                        } else {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.STRING);
                        }
                        config.setFormatType(RBSprintfConfig.FormatType.OTHER);
                        config.setFormat(p);
                        ++i;
                        if (!argTypeSet) {
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        finished = true;
                        continue block25;
                    }
                    case 'p': {
                        config.checkForFormatArgumentType();
                        config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.POINTER);
                        config.setFormatType(RBSprintfConfig.FormatType.POINTER);
                        config.setFormat(p);
                        ++i;
                        if (!argTypeSet) {
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        finished = true;
                        continue block25;
                    }
                    case 'i': {
                        if (i + 1 < this.source.length && this.source[i + 1] == '\u000b' && config.getFormatArgumentType() == RBSprintfConfig.FormatArgumentType.LONG) {
                            config.setFormatType(RBSprintfConfig.FormatType.RUBY_VALUE);
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.VALUE);
                            i += 2;
                        } else {
                            config.setFormatType(RBSprintfConfig.FormatType.INTEGER);
                            ++i;
                        }
                        if (!config.hasFormatArgumentType()) {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.INT);
                        }
                        config.setFormat(p);
                        if (!argTypeSet) {
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        finished = true;
                        continue block25;
                    }
                    case 'X': 
                    case 'd': 
                    case 'o': 
                    case 'u': 
                    case 'x': {
                        if (!config.hasFormatArgumentType()) {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.INT);
                        }
                        if (!argTypeSet) {
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        config.setFormatType(RBSprintfConfig.FormatType.INTEGER);
                        config.setFormat(p);
                        finished = true;
                        ++i;
                        continue block25;
                    }
                    case 'A': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'a': 
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        if (!config.hasFormatArgumentType()) {
                            config.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.DOUBLE);
                        }
                        if (!argTypeSet) {
                            RBSprintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        config.setFormatType(RBSprintfConfig.FormatType.FLOAT);
                        config.setFormat(p);
                        finished = true;
                        ++i;
                        continue block25;
                    }
                }
                throw new InvalidFormatException("malformed format string - %" + p);
            }
        }
        return this.normalizeArgumentTypes(configs);
    }

    private static void checkNextArg(ArgType argType, int nextArgumentIndex) {
        switch (argType.ordinal()) {
            case 1: {
                throw new InvalidFormatException("unnumbered(" + nextArgumentIndex + ") mixed with numbered");
            }
            case 3: {
                throw new InvalidFormatException("unnumbered(" + nextArgumentIndex + ") mixed with named");
            }
        }
    }

    private static void checkPosArg(ArgType posarg, int nextArgumentIndex) {
        if (posarg == ArgType.UNNUMBERED) {
            throw new InvalidFormatException("numbered(" + nextArgumentIndex + ") after unnumbered(" + String.valueOf((Object)posarg) + ")");
        }
        if (posarg == ArgType.NAMED) {
            throw new InvalidFormatException("numbered(" + nextArgumentIndex + ") after named");
        }
        if (nextArgumentIndex < 1) {
            throw new InvalidFormatException("invalid index - " + nextArgumentIndex + "$");
        }
    }

    public LookAheadResult getNum(int startI, int end) {
        Integer result;
        char nextChar;
        StringBuilder sb = new StringBuilder();
        int moreChars = 0;
        for (int i = startI; i < end && RBSprintfSimpleParser.isDigit(nextChar = this.source[i]); ++i) {
            sb.append(nextChar);
            ++moreChars;
        }
        int nextI = startI + moreChars;
        if (nextI >= end) {
            throw new InvalidFormatException("malformed format string - %%*[0-9]");
        }
        if (sb.length() > 0) {
            try {
                result = Integer.parseInt(sb.toString());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidFormatException("precision too big");
            }
        } else {
            result = null;
        }
        return new LookAheadResult(result, nextI);
    }

    public LookAheadResult getNumberDollar(int startI, int end) {
        int nextI;
        LookAheadResult lar = this.getNum(startI, end);
        Integer result = null;
        int newI = startI;
        if (lar.getNumber() != null && this.valueAt(nextI = lar.getNextI()) != null && this.valueAt(nextI).charValue() == '$') {
            result = lar.getNumber();
            newI = nextI + 1;
            if (result < 1) {
                throw new InvalidFormatException("invalid index - " + result + "$");
            }
        }
        return new LookAheadResult(result, newI);
    }

    public static boolean isDigit(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    public Character valueAt(int index) {
        assert (index >= 0);
        if (index < this.source.length) {
            return Character.valueOf(this.source[index]);
        }
        return null;
    }

    private static byte[] charsToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int n = 0; n < chars.length; ++n) {
            bytes[n] = (byte)chars[n];
        }
        return bytes;
    }

    private List<RBSprintfConfig> normalizeArgumentTypes(List<RBSprintfConfig> configs) {
        RBSprintfConfig[] inPosition = new RBSprintfConfig[configs.size()];
        HashSet<RBSprintfConfig> conflicts = new HashSet<RBSprintfConfig>();
        int pos = 0;
        for (RBSprintfConfig config : configs) {
            int typePos = config.getAbsoluteArgumentIndex() != null ? config.getAbsoluteArgumentIndex() - 1 : pos++;
            if (inPosition[typePos] == null) {
                inPosition[typePos] = config;
                continue;
            }
            if (config.getFormatArgumentType() == RBSprintfConfig.FormatArgumentType.VALUE) {
                inPosition[typePos] = config;
            }
            conflicts.add(config);
            conflicts.add(inPosition[typePos]);
        }
        if (conflicts.size() > 0) {
            for (RBSprintfConfig config : inPosition) {
                if (config.getFormatArgumentType() != RBSprintfConfig.FormatArgumentType.VALUE || !conflicts.contains(config)) continue;
                boolean typeConflict = false;
                ArrayList<RBSprintfConfig> toFix = new ArrayList<RBSprintfConfig>();
                for (RBSprintfConfig conflict : conflicts) {
                    if (!Objects.equals(conflict.getAbsoluteArgumentIndex(), config.getAbsoluteArgumentIndex())) continue;
                    toFix.add(conflict);
                    typeConflict |= conflict.getFormatArgumentType() != config.getFormatArgumentType();
                }
                if (!typeConflict) continue;
                for (RBSprintfConfig fixConfig : toFix) {
                    fixConfig.setFormatArgumentType(RBSprintfConfig.FormatArgumentType.LONG);
                }
            }
            return configs;
        }
        return configs;
    }

    private static enum ArgType {
        NONE,
        NUMBERED,
        UNNUMBERED,
        NAMED;

    }

    public static final class LookAheadResult {
        private Integer number;
        private int nextI;

        public LookAheadResult(Integer number, int nextI) {
            this.number = number;
            this.nextI = nextI;
        }

        public Integer getNumber() {
            return this.number;
        }

        public int getNextI() {
            return this.nextI;
        }
    }
}

