/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.printf;

import org.truffleruby.core.format.exceptions.InvalidFormatException;

public final class SprintfConfig {
    private boolean literal = false;
    private byte[] literalBytes;
    private byte[] namesBytes;
    private boolean argWidth = false;
    private Integer absoluteArgumentIndex;
    private Integer precision;
    private boolean precisionArg = false;
    private boolean precisionVisited = false;
    private Integer width;
    private boolean hasSpace = false;
    private boolean fsharp = false;
    private boolean plus = false;
    private boolean minus = false;
    private boolean zero = false;
    private boolean widthStar = false;
    private boolean precisionStar = false;
    private char format;
    private FormatType formatType;

    public void checkForFlags() {
        if (this.hasWidth()) {
            throw new InvalidFormatException("flag after width");
        }
        if (this.hasPrecision()) {
            throw new InvalidFormatException("flag after precision");
        }
    }

    public void checkForWidth() {
        if (this.hasWidth()) {
            throw new InvalidFormatException("width given twice");
        }
        if (this.hasPrecision()) {
            throw new InvalidFormatException("width after precision");
        }
    }

    public boolean isHasSpace() {
        return this.hasSpace;
    }

    public void setHasSpace(boolean hasSpace) {
        this.hasSpace = hasSpace;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean isFsharp() {
        return this.fsharp;
    }

    public void setFsharp(boolean fsharp) {
        this.fsharp = fsharp;
    }

    public boolean isPlus() {
        return this.plus;
    }

    public void setPlus(boolean plus) {
        this.plus = plus;
    }

    public boolean isMinus() {
        return this.minus;
    }

    public void setMinus(boolean minus) {
        this.minus = minus;
    }

    public boolean isZero() {
        return this.zero;
    }

    public void setZero(boolean zero) {
        this.zero = zero;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(FormatType formatType) {
        this.formatType = formatType;
    }

    public char getFormat() {
        return this.format;
    }

    public void setFormat(char format) {
        this.format = format;
    }

    public boolean isWidthStar() {
        return this.widthStar;
    }

    public void setWidthStar(boolean widthStar) {
        this.widthStar = widthStar;
    }

    public boolean isPrecisionStar() {
        return this.precisionStar;
    }

    public void setPrecisionStar(boolean precisionStar) {
        this.precisionStar = precisionStar;
    }

    public boolean hasPrecision() {
        return this.precision != null || this.precisionStar || this.precisionVisited;
    }

    public boolean hasWidth() {
        return this.width != null || this.widthStar;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral(boolean literal) {
        this.literal = literal;
    }

    public byte[] getLiteralBytes() {
        return this.literalBytes;
    }

    public void setLiteralBytes(byte[] literalBytes) {
        this.literalBytes = literalBytes;
    }

    public Integer getAbsoluteArgumentIndex() {
        return this.absoluteArgumentIndex;
    }

    public void setAbsoluteArgumentIndex(Integer absoluteArgumentIndex) {
        this.absoluteArgumentIndex = absoluteArgumentIndex;
    }

    public boolean isArgWidth() {
        return this.argWidth;
    }

    public void setArgWidth(boolean argWidth) {
        this.argWidth = argWidth;
    }

    public boolean isPrecisionVisited() {
        return this.precisionVisited;
    }

    public void setPrecisionVisited(boolean precisionVisited) {
        this.precisionVisited = precisionVisited;
    }

    public byte[] getNamesBytes() {
        return this.namesBytes;
    }

    public void setNamesBytes(byte[] namesBytes) {
        this.namesBytes = namesBytes;
    }

    public boolean isPrecisionArg() {
        return this.precisionArg;
    }

    public void setPrecisionArg(boolean precisionArg) {
        this.precisionArg = precisionArg;
    }

    public boolean hasFlags() {
        return this.literal || this.precision != null || this.precisionVisited || this.width != null || this.hasSpace || this.fsharp || this.plus || this.minus || this.zero || this.precisionStar || this.widthStar || this.formatType != null;
    }

    public static enum FormatType {
        INTEGER,
        FLOAT,
        OTHER;

    }
}

