/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.FormatNode;

@NodeChildren(value={@NodeChild(value="width"), @NodeChild(value="precision"), @NodeChild(value="value")})
@ImportStatic(value={Double.class})
public abstract class FormatFloatGenericNode
extends FormatNode {
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    protected final boolean hasSpaceFlag;
    protected final boolean hasZeroFlag;
    protected final boolean hasPlusFlag;
    protected final boolean hasMinusFlag;
    protected final boolean hasFSharpFlag;

    protected FormatFloatGenericNode(boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
        this.hasPlusFlag = hasPlusFlag;
        this.hasMinusFlag = hasMinusFlag;
        this.hasFSharpFlag = hasFSharpFlag;
    }

    @Specialization(guards={"value == POSITIVE_INFINITY"})
    byte[] formatPositiveInfinity(int width, int precision, double value) {
        byte signChar;
        ByteArrayBuilder buf = new ByteArrayBuilder();
        if (width == Integer.MIN_VALUE) {
            width = 0;
        }
        byte[] digits = INFINITY_VALUE;
        int len = INFINITY_VALUE.length;
        if (this.hasPlusFlag) {
            signChar = 43;
            --width;
        } else if (this.hasSpaceFlag) {
            signChar = 32;
            --width;
        } else {
            signChar = 0;
        }
        if ((width -= len) > 0 && !this.hasMinusFlag) {
            buf.append(32, width);
            width = 0;
        }
        if (signChar != 0) {
            buf.append(signChar);
        }
        if (width > 0 && !this.hasMinusFlag) {
            buf.append(48, width);
            width = 0;
        }
        buf.append(digits);
        if (width > 0) {
            buf.append(32, width);
        }
        return buf.getBytes();
    }

    @Specialization(guards={"value == NEGATIVE_INFINITY"})
    byte[] formatNegativeInfinity(int width, int precision, double value) {
        ByteArrayBuilder buf = new ByteArrayBuilder();
        if (width == Integer.MIN_VALUE) {
            width = 0;
        }
        byte[] digits = INFINITY_VALUE;
        int len = INFINITY_VALUE.length;
        byte signChar = 45;
        --width;
        if ((width -= len) > 0 && !this.hasMinusFlag) {
            buf.append(32, width);
            width = 0;
        }
        buf.append(signChar);
        if (width > 0 && !this.hasMinusFlag) {
            buf.append(48, width);
            width = 0;
        }
        buf.append(digits);
        if (width > 0) {
            buf.append(32, width);
        }
        return buf.getBytes();
    }

    @Specialization(guards={"isNaN(value)"})
    byte[] formatNaN(int width, int precision, double value) {
        byte signChar;
        ByteArrayBuilder buf = new ByteArrayBuilder();
        if (width == Integer.MIN_VALUE) {
            width = 0;
        }
        byte[] digits = NAN_VALUE;
        int len = NAN_VALUE.length;
        if (this.hasPlusFlag) {
            signChar = 43;
            --width;
        } else if (this.hasSpaceFlag) {
            signChar = 32;
            --width;
        } else {
            signChar = 0;
        }
        if ((width -= len) > 0 && !this.hasMinusFlag) {
            buf.append(32, width);
            width = 0;
        }
        if (signChar != 0) {
            buf.append(signChar);
        }
        if (width > 0 && !this.hasMinusFlag) {
            buf.append(48, width);
            width = 0;
        }
        buf.append(digits);
        if (width > 0) {
            buf.append(32, width);
        }
        return buf.getBytes();
    }

    protected final byte[] formatNumber(int origWidth, int precision, Object value) {
        byte[] digits = this.doFormat(precision, value);
        ByteArrayBuilder buf = new ByteArrayBuilder();
        int width = origWidth == Integer.MIN_VALUE ? -1 : Math.abs(origWidth);
        if (origWidth > 0 && (width -= digits.length) > 0 && !this.hasMinusFlag) {
            if (this.hasZeroFlag) {
                boolean firstDigit = digits[0] >= 48 && digits[0] <= 57;
                buf.append(digits, 0, this.prefixBytes() + (firstDigit ? 0 : 1));
                buf.append(48, width);
                FormatFloatGenericNode.appendNumber(digits, buf, this.prefixBytes() + (firstDigit ? 0 : 1));
            } else {
                buf.append(32, width);
                FormatFloatGenericNode.appendNumber(digits, buf, 0);
            }
        } else {
            FormatFloatGenericNode.appendNumber(digits, buf, 0);
            if (width > 0) {
                buf.append(32, width);
            }
        }
        return buf.getBytes();
    }

    protected int prefixBytes() {
        return 0;
    }

    protected byte[] doFormat(int precision, Object value) {
        return null;
    }

    private static void appendNumber(byte[] digits, ByteArrayBuilder buf, int start) {
        buf.append(digits, start, digits.length - start);
    }

    protected boolean nonSpecialValue(Object value) {
        if (value instanceof Double) {
            return Double.isFinite((Double)value);
        }
        return true;
    }
}

