/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.format.FormatFloatGenericNode;
import org.truffleruby.core.string.StringOperations;

@ImportStatic(value={Double.class})
public abstract class FormatFFloatNode
extends FormatFloatGenericNode {
    public FormatFFloatNode(boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        super(hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag);
    }

    @Specialization(guards={"nonSpecialValue(dval)"})
    byte[] formatFGeneric(int width, int precision, Object dval) {
        if (precision == Integer.MIN_VALUE) {
            precision = 6;
        }
        return this.formatNumber(width, precision, dval);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected byte[] doFormat(int precision, Object value) {
        DecimalFormat format = this.getLanguage().getCurrentThread().formatFFloat;
        if (format == null) {
            DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
            this.getLanguage().getCurrentThread().formatFFloat = format = new DecimalFormat("", formatSymbols);
        }
        format.setGroupingSize(0);
        if (this.hasPlusFlag) {
            format.setPositivePrefix("+");
        } else if (this.hasSpaceFlag) {
            format.setPositivePrefix(" ");
        } else {
            format.setPositivePrefix("");
        }
        if (precision == 0 && this.hasFSharpFlag) {
            format.setPositiveSuffix(".");
            format.setNegativeSuffix(".");
        } else {
            format.setPositiveSuffix("");
            format.setNegativeSuffix("");
        }
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(precision);
        format.setMaximumFractionDigits(precision);
        if (value instanceof Double && Math.getExponent((Double)value) > 53) {
            double dval = (Double)value;
            long mantissa = Double.doubleToLongBits(dval) & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            BigInteger bi = BigInteger.valueOf(mantissa).shiftLeft(Math.getExponent(dval) - 52);
            if (dval < 0.0) {
                bi = bi.negate();
            }
            value = bi;
        }
        byte[] digits = StringOperations.encodeAsciiBytes(format.format(value));
        if (precision <= 340) {
            return digits;
        }
        ByteArrayBuilder buf = new ByteArrayBuilder();
        buf.append(digits);
        buf.append(48, precision - 340);
        return buf.getBytes();
    }
}

