/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.convert.ToStrNode;
import org.truffleruby.core.format.convert.ToStrNodeGen;
import org.truffleruby.core.format.exceptions.NoImplicitConversionException;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class FormatCharacterNode
extends FormatNode {
    private final RubyEncoding encoding;
    @Node.Child
    private ToStrNode toStrNode;
    @Node.Child
    private TruffleString.FromCodePointNode fromCodePointNode;
    @Node.Child
    private TruffleString.CodePointLengthNode codePointLengthNode;
    @Node.Child
    private TruffleString.ForceEncodingNode forceEncodingNode;

    public FormatCharacterNode(RubyEncoding encoding) {
        this.encoding = encoding;
    }

    @Specialization
    RubyString format(Object value, @Cached ToIntNode toIntNode, @Cached RubyStringLibrary strings) {
        TruffleString character = this.getCharacter(value, strings, toIntNode);
        return this.createString(character, this.encoding);
    }

    @CompilerDirectives.TruffleBoundary
    protected TruffleString getCharacter(Object value, RubyStringLibrary strings, ToIntNode toIntNode) {
        TruffleString character;
        Object stringArgument;
        try {
            stringArgument = this.toStrNode().execute(value);
        }
        catch (NoImplicitConversionException e) {
            stringArgument = null;
        }
        if (stringArgument == null || RubyGuards.isNil(stringArgument)) {
            int codepointArgument = toIntNode.execute(value);
            character = this.fromCodePointNode().execute(codepointArgument, this.encoding.tencoding);
            if (character == null) {
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().charRangeError(codepointArgument, this));
            }
        } else if (strings.isRubyString(stringArgument)) {
            AbstractTruffleString originalCharacter = strings.getTString(stringArgument);
            character = this.forceEncodingNode().execute(originalCharacter, strings.getTEncoding(stringArgument), this.encoding.tencoding);
            int size = this.codePointLengthNode().execute((AbstractTruffleString)character, this.encoding.tencoding);
            if (size != 1) {
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentErrorCharacterRequired(this));
            }
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return character;
    }

    private ToStrNode toStrNode() {
        if (this.toStrNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(null));
        }
        return this.toStrNode;
    }

    private TruffleString.FromCodePointNode fromCodePointNode() {
        if (this.fromCodePointNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fromCodePointNode = (TruffleString.FromCodePointNode)this.insert((Node)TruffleString.FromCodePointNode.create());
        }
        return this.fromCodePointNode;
    }

    private TruffleString.CodePointLengthNode codePointLengthNode() {
        if (this.codePointLengthNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.codePointLengthNode = (TruffleString.CodePointLengthNode)this.insert((Node)TruffleString.CodePointLengthNode.create());
        }
        return this.codePointLengthNode;
    }

    private TruffleString.ForceEncodingNode forceEncodingNode() {
        if (this.forceEncodingNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.forceEncodingNode = (TruffleString.ForceEncodingNode)this.insert((Node)TruffleString.ForceEncodingNode.create());
        }
        return this.forceEncodingNode;
    }
}

