/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.memory.ByteArraySupport;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.MissingValue;
import org.truffleruby.language.Nil;

@NodeChild(value="bytes")
public abstract class BytesToInteger32BigNode
extends FormatNode {
    private final boolean signed;

    protected BytesToInteger32BigNode(boolean signed) {
        this.signed = signed;
    }

    @Specialization
    MissingValue decode(MissingValue missingValue) {
        return missingValue;
    }

    @Specialization
    Object decode(Nil nil) {
        return nil;
    }

    @Specialization
    Object decode(byte[] bytes) {
        int value = ByteArraySupport.bigEndian().getInt(bytes, 0);
        if (this.signed) {
            return value;
        }
        return Integer.toUnsignedLong(value);
    }
}

