/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.OutsideOfStringException;
import org.truffleruby.core.format.exceptions.RangeException;

public final class SetSourcePositionNode
extends FormatNode {
    private final int position;
    private final ConditionProfile rangeProfile = ConditionProfile.create();

    public SetSourcePositionNode(int position) {
        this.position = position;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int positionWithStartOffset = this.getSourceStart(frame) + this.position;
        if (this.rangeProfile.profile(positionWithStartOffset > this.getSourceEnd(frame))) {
            throw new OutsideOfStringException();
        }
        if (this.position < 0) {
            throw new RangeException("pack length too big");
        }
        this.setSourcePosition(frame, positionWithStartOffset);
        return null;
    }
}

