/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

import java.util.Deque;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.control.RepeatExplodedNode;
import org.truffleruby.core.format.control.RepeatLoopNode;
import org.truffleruby.core.format.control.SequenceNode;
import org.truffleruby.core.format.control.StarNode;

public final class SharedTreeBuilder {
    private final RubyLanguage language;

    public SharedTreeBuilder(RubyLanguage language) {
        this.language = language;
    }

    public FormatNode finishSubSequence(Deque<List<FormatNode>> sequenceStack, int count) {
        List<FormatNode> sequence = sequenceStack.pop();
        FormatNode sequenceNode = SharedTreeBuilder.createSequence(sequence.toArray(FormatNode.EMPTY_ARRAY));
        if (count == -1) {
            return sequenceNode;
        }
        return this.createRepeatNode(count, sequenceNode);
    }

    public static FormatNode createSequence(FormatNode ... children) {
        if (children.length == 1) {
            return children[0];
        }
        return new SequenceNode(children);
    }

    public FormatNode applyCount(int count, FormatNode node) {
        switch (count) {
            case -1: {
                return node;
            }
            case -2: {
                return new StarNode(node);
            }
        }
        return this.createRepeatNode(count, node);
    }

    private FormatNode createRepeatNode(int count, FormatNode node) {
        if (count == 1) {
            return node;
        }
        if (count > this.language.options.PACK_UNROLL_LIMIT) {
            return new RepeatLoopNode(count, node);
        }
        return new RepeatExplodedNode(count, node);
    }

    public StarLength parseCountContext(int count) {
        int length;
        boolean star;
        if (count == -1) {
            star = false;
            length = 1;
        } else if (count == -2) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = count;
        }
        return new StarLength(star, length);
    }

    public static final class StarLength {
        private final boolean star;
        private final int length;

        public StarLength(boolean star, int length) {
            this.star = star;
            this.length = length;
        }

        public boolean isStar() {
            return this.star;
        }

        public int getLength() {
            return this.length;
        }
    }
}

