/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.format.FormatFrameDescriptor;
import org.truffleruby.core.format.FormatGuards;
import org.truffleruby.core.format.exceptions.TooFewArgumentsException;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={FormatGuards.class})
public abstract class FormatNode
extends RubyBaseNode {
    public static final FormatNode[] EMPTY_ARRAY = new FormatNode[0];
    private final ConditionProfile writeMoreThanZeroBytes = ConditionProfile.create();
    private final ConditionProfile tooFewArgumentsProfile = ConditionProfile.create();
    private final ConditionProfile sourceRangeProfile = ConditionProfile.create();
    private static final Class<? extends ByteBuffer> HEAP_BYTE_BUFFER_CLASS = ByteBuffer.wrap(TStringConstants.EMPTY_BYTES).getClass();

    public abstract Object execute(VirtualFrame var1);

    public int getSourceEnd(VirtualFrame frame) {
        return frame.getInt(FormatFrameDescriptor.SOURCE_END_POSITION_SLOT);
    }

    public int getSourceStart(VirtualFrame frame) {
        return frame.getInt(FormatFrameDescriptor.SOURCE_START_POSITION_SLOT);
    }

    protected int getSourcePosition(VirtualFrame frame) {
        return frame.getInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT);
    }

    protected void setSourcePosition(VirtualFrame frame, int position) {
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, position);
    }

    protected int advanceSourcePosition(VirtualFrame frame) {
        return this.advanceSourcePosition(frame, 1);
    }

    protected int advanceSourcePosition(VirtualFrame frame, int count) {
        int sourcePosition = this.getSourcePosition(frame);
        if (this.tooFewArgumentsProfile.profile(sourcePosition + count > this.getSourceEnd(frame))) {
            throw new TooFewArgumentsException();
        }
        this.setSourcePosition(frame, sourcePosition + count);
        return sourcePosition;
    }

    protected int advanceSourcePositionNoThrow(VirtualFrame frame) {
        return this.advanceSourcePositionNoThrow(frame, 1, false);
    }

    protected int advanceSourcePositionNoThrow(VirtualFrame frame, int count, boolean consumePartial) {
        int end;
        int sourcePosition = this.getSourcePosition(frame);
        if (this.sourceRangeProfile.profile(sourcePosition + count > (end = this.getSourceEnd(frame)))) {
            if (consumePartial) {
                this.setSourcePosition(frame, end);
            }
            return -1;
        }
        this.setSourcePosition(frame, sourcePosition + count);
        return sourcePosition;
    }

    protected Object getOutput(VirtualFrame frame) {
        return frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
    }

    protected void setOutput(VirtualFrame frame, Object output) {
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, output);
    }

    protected int getOutputPosition(VirtualFrame frame) {
        return frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
    }

    protected void setOutputPosition(VirtualFrame frame, int position) {
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, position);
    }

    protected void writeByte(VirtualFrame frame, byte value) {
        byte[] output = this.ensureCapacity(frame, 1);
        int outputPosition = this.getOutputPosition(frame);
        output[outputPosition] = value;
        this.setOutputPosition(frame, outputPosition + 1);
    }

    protected void writeBytes(VirtualFrame frame, byte[] values) {
        this.writeBytes(frame, values, 0, values.length);
    }

    protected void writeBytes(VirtualFrame frame, byte[] values, int valuesOffset, int valuesLength) {
        byte[] output = this.ensureCapacity(frame, valuesLength);
        int outputPosition = this.getOutputPosition(frame);
        System.arraycopy(values, valuesOffset, output, outputPosition, valuesLength);
        this.setOutputPosition(frame, outputPosition + valuesLength);
    }

    protected void writeNullBytes(VirtualFrame frame, int length) {
        if (this.writeMoreThanZeroBytes.profile(length > 0)) {
            this.ensureCapacity(frame, length);
            int outputPosition = this.getOutputPosition(frame);
            this.setOutputPosition(frame, outputPosition + length);
        }
    }

    private byte[] ensureCapacity(VirtualFrame frame, int length) {
        byte[] output = (byte[])this.getOutput(frame);
        int outputPosition = this.getOutputPosition(frame);
        if (outputPosition + length > output.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            output = Arrays.copyOf(output, ArrayUtils.capacity(this.getLanguage(), output.length, outputPosition + length));
            this.setOutput(frame, output);
        }
        return output;
    }

    public ByteBuffer wrapByteBuffer(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        int end = this.getSourceEnd(frame);
        return (ByteBuffer)CompilerDirectives.castExact((Object)FormatNode.wrapByteBuffer(source, position, end - position), HEAP_BYTE_BUFFER_CLASS);
    }

    @CompilerDirectives.TruffleBoundary
    private static ByteBuffer wrapByteBuffer(byte[] source, int position, int length) {
        return ByteBuffer.wrap(source, position, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static int safeGet(ByteBuffer encode) {
        while (encode.hasRemaining()) {
            int got = encode.get() & 0xFF;
            if (got == 0) continue;
            return got;
        }
        return 0;
    }
}

