/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.fiber;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.ObjectGraphNode;

public final class RubyFiber
extends RubyDynamicObject
implements ObjectGraphNode {
    private Object lastException = RubyBaseNode.nil;
    public Object errorInfo = RubyBaseNode.nil;
    public final RubyBasicObject fiberLocals;
    public final RubyArray catchTags;
    public final CountDownLatch initializedLatch = new CountDownLatch(1);
    public CountDownLatch finishedLatch = new CountDownLatch(1);
    final BlockingQueue<FiberManager.FiberMessage> messageQueue = RubyFiber.newMessageQueue();
    public final RubyThread rubyThread;
    volatile RubyFiber lastResumedByFiber = null;
    volatile RubyFiber resumingFiber = null;
    volatile boolean yielding = false;
    volatile FiberStatus status;
    public Thread thread = null;
    public volatile Throwable uncaughtException = null;
    String sourceLocation;
    RubyProc body;
    Node initializeNode;
    public final MarkingService.ExtensionCallStack extensionCallStack;
    public final ValueWrapperManager.HandleBlockHolder handleData;
    boolean blocking = true;
    public RubyArray cGlobalVariablesDuringInitFunction;
    FiberManager.FiberMessage firstMessage;
    RubyFiber returnFiber;
    FiberManager.FiberMessage lastMessage;

    public RubyFiber(RubyClass rubyClass, Shape shape, RubyContext context, RubyLanguage language, RubyThread rubyThread, FiberStatus status, String sourceLocation) {
        super(rubyClass, shape);
        assert (rubyThread != null);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)language));
        this.fiberLocals = new RubyBasicObject(context.getCoreLibrary().objectClass, language.basicObjectShape);
        this.catchTags = ArrayHelpers.createEmptyArray(context, language);
        this.rubyThread = rubyThread;
        this.status = status;
        this.sourceLocation = sourceLocation;
        this.extensionCallStack = new MarkingService.ExtensionCallStack(null, Nil.INSTANCE);
        this.handleData = new ValueWrapperManager.HandleBlockHolder();
    }

    public boolean isRootFiber() {
        return this.rubyThread.getRootFiber() == this;
    }

    public boolean isActive() {
        return this == this.rubyThread.getCurrentFiber();
    }

    public boolean isTerminated() {
        return this.status == FiberStatus.TERMINATED;
    }

    public void restart() {
        this.status = FiberStatus.CREATED;
    }

    @CompilerDirectives.TruffleBoundary
    private static LinkedBlockingQueue<FiberManager.FiberMessage> newMessageQueue() {
        return new LinkedBlockingQueue<FiberManager.FiberMessage>();
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        reachable.add((Object)this.fiberLocals);
        reachable.add(this.rubyThread);
    }

    public Object getLastException() {
        return this.lastException;
    }

    public void setLastException(Object exception) {
        assert (!(exception instanceof KillException)) : "$? should never be a KillException: " + String.valueOf(exception);
        assert (!(exception instanceof RaiseException)) : "$? should never be a RaiseException: " + String.valueOf(exception);
        assert (exception == RubyBaseNode.nil || exception instanceof RubyException || exception instanceof AbstractTruffleException) : "Unexpected exception object for $!: " + String.valueOf(exception);
        this.lastException = exception;
    }

    public static enum FiberStatus {
        CREATED("created"),
        RESUMED("resumed"),
        SUSPENDED("suspended"),
        TERMINATED("terminated");

        public final String label;

        private FiberStatus(String label) {
            this.label = label;
        }
    }
}

