/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.fiber;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.basicobject.BasicObjectNodes;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberOperation;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.SafepointAction;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.TerminationException;
import org.truffleruby.language.objects.shared.SharedObjects;

public final class FiberManager {
    public static final String NAME_PREFIX = "Ruby Fiber";
    public static final Object[] SAFEPOINT_ARGS = new Object[]{FiberSafepointMessage.class};
    private final RubyLanguage language;
    private final RubyContext context;
    private static final InlinedBranchProfile UNPROFILED = InlinedBranchProfile.getUncached();

    public FiberManager(RubyLanguage language, RubyContext context) {
        this.language = language;
        this.context = context;
    }

    public void initialize(RubyFiber fiber, boolean blocking, RubyProc block, Node currentNode) {
        SourceSection sourceSection = block.getSharedMethodInfo().getSourceSection();
        fiber.sourceLocation = this.context.fileLine(sourceSection);
        fiber.body = block;
        fiber.initializeNode = currentNode;
        fiber.blocking = blocking;
    }

    private void createThreadToReceiveFirstMessage(RubyFiber fiber, Node currentNode) {
        assert (fiber.thread == null);
        RubyProc block = Objects.requireNonNull(fiber.body);
        fiber.body = null;
        Node initializeNode = Objects.requireNonNull(fiber.initializeNode);
        fiber.initializeNode = null;
        SourceSection sourceSection = block.getSharedMethodInfo().getSourceSection();
        this.context.getThreadManager().leaveAndEnter(currentNode, TruffleSafepoint.Interrupter.THREAD_INTERRUPT, unused -> {
            Thread thread;
            fiber.thread = thread = this.context.getThreadManager().createFiberJavaThread(fiber, sourceSection, () -> this.beforeEnter(fiber, initializeNode), () -> this.fiberMain(this.context, fiber, block, initializeNode), () -> this.afterLeave(fiber), currentNode);
            thread.start();
            FiberManager.waitForInitializationUnentered(this.context, fiber, currentNode);
            return true;
        }, null);
    }

    public static void waitForInitializationEntered(RubyContext context, RubyFiber fiber, Node currentNode) {
        assert (context.getEnv().getContext().isEntered());
        CountDownLatch initializedLatch = fiber.initializedLatch;
        context.getThreadManager().runUntilResultKeepStatus(currentNode, latch -> {
            latch.await();
            return true;
        }, initializedLatch);
        Throwable uncaughtException = fiber.uncaughtException;
        if (uncaughtException != null) {
            ExceptionOperations.rethrow(uncaughtException);
        }
    }

    public static void waitForInitializationUnentered(RubyContext context, RubyFiber fiber, Node currentNode) throws InterruptedException {
        assert (!context.getEnv().getContext().isEntered());
        CountDownLatch initializedLatch = fiber.initializedLatch;
        initializedLatch.await();
        Throwable uncaughtException = fiber.uncaughtException;
        if (uncaughtException != null) {
            ExceptionOperations.rethrow(uncaughtException);
        }
    }

    private void beforeEnter(RubyFiber fiber, Node currentNode) {
        assert (!fiber.isRootFiber()) : "Root Fibers execute threadMain() and not fiberMain()";
        this.assertNotEntered("Fibers should start unentered to avoid triggering multithreading");
        Thread thread = Thread.currentThread();
        this.start(fiber, thread);
        fiber.initializedLatch.countDown();
        try {
            fiber.firstMessage = this.waitMessage(fiber, currentNode);
        }
        catch (InterruptedException e) {
            throw CompilerDirectives.shouldNotReachHere((String)"unexpected interrupt in Fiber beforeEnter()");
        }
    }

    /*
     * Exception decompiling
     */
    private void fiberMain(RubyContext context, RubyFiber fiber, RubyProc block, Node currentNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void afterLeave(RubyFiber fiber) {
        if (fiber.lastMessage != null) {
            this.addToMessageQueue(fiber.returnFiber, fiber.lastMessage);
            fiber.returnFiber = null;
            fiber.lastMessage = null;
        }
    }

    public RubyFiber getReturnFiber(RubyFiber currentFiber, Node currentNode, InlinedBranchProfile errorProfile) {
        assert (currentFiber.isActive());
        RubyFiber rootFiber = currentFiber.rubyThread.getRootFiber();
        RubyFiber previousFiber = currentFiber.lastResumedByFiber;
        if (previousFiber != null) {
            currentFiber.lastResumedByFiber = null;
            previousFiber.resumingFiber = null;
            return previousFiber;
        }
        if (currentFiber == rootFiber) {
            errorProfile.enter(currentNode);
            throw new RaiseException(this.context, this.context.getCoreExceptions().yieldFromRootFiberError(currentNode));
        }
        RubyFiber fiber = rootFiber;
        while (fiber.resumingFiber != null) {
            fiber = fiber.resumingFiber;
        }
        return fiber;
    }

    @CompilerDirectives.TruffleBoundary
    private void addToMessageQueue(RubyFiber fiber, FiberMessage message) {
        this.assertNotEntered("should have left context when sending message to fiber");
        fiber.messageQueue.add(message);
    }

    @CompilerDirectives.TruffleBoundary
    private FiberMessage waitMessage(RubyFiber fiber, Node currentNode) throws InterruptedException {
        this.assertNotEntered("should have left context while waiting fiber message");
        return Objects.requireNonNull(fiber.messageQueue.take());
    }

    private void assertNotEntered(String reason) {
        assert (!this.context.getEnv().getContext().isEntered()) : reason;
    }

    @CompilerDirectives.TruffleBoundary
    private DescriptorAndArgs handleMessage(RubyFiber fiber, FiberMessage message, Node currentNode) {
        while (message instanceof FiberSafepointMessage) {
            FiberSafepointMessage safepointMessage = (FiberSafepointMessage)message;
            safepointMessage.action.run(fiber.rubyThread, currentNode);
            RubyFiber sendingFiber = safepointMessage.sendingFiber;
            message = this.resumeAndWait(fiber, sendingFiber, FiberOperation.TRANSFER, NoKeywordArgumentsDescriptor.INSTANCE, SAFEPOINT_ARGS, currentNode);
        }
        if (message instanceof FiberShutdownMessage) {
            throw new FiberShutdownException(currentNode);
        }
        if (message instanceof FiberExceptionMessage) {
            throw ((FiberExceptionMessage)message).getException();
        }
        if (message instanceof FiberResumeMessage) {
            FiberResumeMessage resumeMessage = (FiberResumeMessage)message;
            assert (this.language.getCurrentThread() == resumeMessage.getSendingFiber().rubyThread);
            FiberOperation operation = resumeMessage.getOperation();
            if (operation == FiberOperation.RESUME) {
                fiber.yielding = false;
            }
            fiber.status = RubyFiber.FiberStatus.RESUMED;
            if (operation == FiberOperation.RESUME || operation == FiberOperation.RAISE) {
                fiber.lastResumedByFiber = resumeMessage.getSendingFiber();
            }
            if (operation == FiberOperation.RAISE) {
                throw new RaiseException(this.context, (RubyException)resumeMessage.getArgs()[0]);
            }
            return resumeMessage.getDescriptorAndArgs();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private void resume(RubyFiber fromFiber, RubyFiber fiber, FiberOperation operation, ArgumentsDescriptor descriptor, Object ... args) {
        this.addToMessageQueue(fiber, new FiberResumeMessage(operation, fromFiber, descriptor, args));
    }

    @CompilerDirectives.TruffleBoundary
    public DescriptorAndArgs transferControlTo(RubyFiber fromFiber, RubyFiber toFiber, FiberOperation operation, ArgumentsDescriptor descriptor, Object[] args, Node currentNode) {
        assert (fromFiber.resumingFiber == null);
        if (operation == FiberOperation.RESUME) {
            fromFiber.resumingFiber = toFiber;
        }
        assert (!fromFiber.yielding);
        if (operation == FiberOperation.YIELD) {
            fromFiber.yielding = true;
        }
        if (fromFiber.status == RubyFiber.FiberStatus.RESUMED) {
            fromFiber.status = RubyFiber.FiberStatus.SUSPENDED;
        }
        FiberMessage message = this.resumeAndWait(fromFiber, toFiber, operation, descriptor, args, currentNode);
        return this.handleMessage(fromFiber, message, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    private FiberMessage resumeAndWait(RubyFiber fromFiber, RubyFiber toFiber, FiberOperation operation, ArgumentsDescriptor descriptor, Object[] args, Node currentNode) {
        if (toFiber.body != null) {
            this.context.fiberManager.createThreadToReceiveFirstMessage(toFiber, currentNode);
        }
        FiberMessage message = (FiberMessage)this.context.getThreadManager().leaveAndEnter(currentNode, TruffleSafepoint.Interrupter.THREAD_INTERRUPT, unused -> {
            this.resume(fromFiber, toFiber, operation, descriptor, args);
            return this.waitMessage(fromFiber, currentNode);
        }, null);
        fromFiber.rubyThread.setCurrentFiber(fromFiber);
        return message;
    }

    @CompilerDirectives.TruffleBoundary
    public void safepoint(RubyFiber fromFiber, RubyFiber fiber, SafepointAction action, Node currentNode) {
        FiberResumeMessage returnMessage = (FiberResumeMessage)this.context.getThreadManager().leaveAndEnter(currentNode, TruffleSafepoint.Interrupter.THREAD_INTERRUPT, unused -> {
            this.addToMessageQueue(fiber, new FiberSafepointMessage(fromFiber, action));
            return this.waitMessage(fromFiber, currentNode);
        }, null);
        fromFiber.rubyThread.setCurrentFiber(fromFiber);
        if (returnMessage.getArgs() != SAFEPOINT_ARGS) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public void start(RubyFiber fiber, Thread javaThread) {
        if (fiber.isRootFiber()) {
            fiber.thread = javaThread;
        }
        RubyThread rubyThread = fiber.rubyThread;
        SharedObjects.propagate(this.language, rubyThread, fiber);
        rubyThread.runningFibers.add(fiber);
    }

    public void cleanup(RubyFiber fiber, Thread javaThread) {
        this.context.getValueWrapperManager().cleanup(fiber.handleData);
        fiber.status = RubyFiber.FiberStatus.TERMINATED;
        fiber.rubyThread.runningFibers.remove(fiber);
        fiber.thread = null;
        fiber.finishedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void killOtherFibers(RubyThread thread) {
        if (thread.runningFibers.size() <= 1) {
            return;
        }
        TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
        boolean allowSideEffects = safepoint.setAllowSideEffects(false);
        try {
            this.context.getThreadManager().leaveAndEnter(DummyNode.INSTANCE, TruffleSafepoint.Interrupter.THREAD_INTERRUPT, unused -> {
                this.doKillOtherFibers(thread);
                return true;
            }, null);
        }
        finally {
            safepoint.setAllowSideEffects(allowSideEffects);
        }
    }

    private void doKillOtherFibers(RubyThread thread) throws InterruptedException {
        for (RubyFiber fiber : thread.runningFibers) {
            if (fiber.isRootFiber()) continue;
            this.addToMessageQueue(fiber, new FiberShutdownMessage());
            CountDownLatch finishedLatch = fiber.finishedLatch;
            finishedLatch.await();
            Throwable uncaughtException = fiber.uncaughtException;
            if (uncaughtException == null) continue;
            ExceptionOperations.rethrow(uncaughtException);
        }
    }

    public String getFiberDebugInfo(RubyThread rubyThread) {
        StringBuilder builder = new StringBuilder();
        for (RubyFiber fiber : rubyThread.runningFibers) {
            builder.append("  fiber @");
            builder.append(BasicObjectNodes.ObjectIDNode.getUncached().execute(fiber));
            Thread thread = fiber.thread;
            if (thread == null) {
                builder.append(" (no Java thread)");
            } else {
                builder.append(" #").append(RubyLanguage.getThreadId(thread)).append(' ').append(thread);
            }
            if (fiber.isRootFiber()) {
                builder.append(" (root)");
            }
            if (fiber.isActive()) {
                builder.append(" (current)");
            }
            builder.append("\n");
        }
        if (builder.length() == 0) {
            return "  no fibers\n";
        }
        return builder.toString();
    }

    public static interface FiberMessage {
    }

    public static final class DescriptorAndArgs {
        public final ArgumentsDescriptor descriptor;
        public final Object[] args;

        public DescriptorAndArgs(ArgumentsDescriptor descriptor, Object[] args) {
            this.descriptor = descriptor;
            this.args = args;
        }
    }

    private static final class FiberResumeMessage
    implements FiberMessage {
        private final FiberOperation operation;
        private final RubyFiber sendingFiber;
        private final ArgumentsDescriptor descriptor;
        private final Object[] args;

        public FiberResumeMessage(FiberOperation operation, RubyFiber sendingFiber, ArgumentsDescriptor descriptor, Object[] args) {
            this.operation = operation;
            this.sendingFiber = sendingFiber;
            this.descriptor = descriptor;
            this.args = args;
        }

        public FiberOperation getOperation() {
            return this.operation;
        }

        public RubyFiber getSendingFiber() {
            return this.sendingFiber;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public DescriptorAndArgs getDescriptorAndArgs() {
            return new DescriptorAndArgs(this.descriptor, this.args);
        }
    }

    private static final class FiberExceptionMessage
    implements FiberMessage {
        private final RuntimeException exception;

        public FiberExceptionMessage(RuntimeException exception) {
            this.exception = exception;
        }

        public RuntimeException getException() {
            return this.exception;
        }
    }

    public static final class FiberShutdownException
    extends TerminationException {
        public FiberShutdownException(Node location) {
            super("terminate Fiber", location);
        }
    }

    private static final class FiberSafepointMessage
    implements FiberMessage {
        private final RubyFiber sendingFiber;
        private final SafepointAction action;

        private FiberSafepointMessage(RubyFiber sendingFiber, SafepointAction action) {
            this.sendingFiber = sendingFiber;
            this.action = action;
        }
    }

    private static final class FiberShutdownMessage
    implements FiberMessage {
        private FiberShutdownMessage() {
        }
    }
}

