/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.exception.RubyNameError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="NameError", isClass=true)
public abstract class NameErrorNodes {

    @Primitive(name="name_error_set_receiver")
    public static abstract class ReceiverSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setReceiver(RubyNameError error, Object receiver) {
            error.receiver = receiver;
            return receiver;
        }
    }

    @Primitive(name="name_error_set_name")
    public static abstract class NameSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setName(RubyNameError error, Object name) {
            error.name = name;
            return name;
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object receiver(RubyNameError self) {
            Object receiver = self.receiver;
            if (receiver == null) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorNoReceiver(this));
            }
            return receiver;
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object name(RubyNameError self) {
            return self.name;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyNameError allocateNameError(RubyClass rubyClass) {
            Shape shape = this.getLanguage().nameErrorShape;
            RubyNameError instance = new RubyNameError(rubyClass, shape, nil, null, nil, null, nil);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

