/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.CannotConvertBinaryRubyStringToJavaString;
import org.truffleruby.core.string.StringGuards;

public final class TStringUtils {
    private static final boolean DEBUG_NON_ZERO_OFFSET = Boolean.getBoolean("truffle.strings.debug-non-zero-offset-arrays");

    public static TruffleString.Encoding jcodingToTEncoding(Encoding jcoding) {
        String jcodingName = jcoding.toString();
        if (jcodingName.equals("UTF-16")) {
            return TruffleString.Encoding.UTF_16BE;
        }
        if (jcodingName.equals("UTF-32")) {
            return TruffleString.Encoding.UTF_32BE;
        }
        return TruffleString.Encoding.fromJCodingName((String)jcodingName);
    }

    public static TruffleString fromByteArray(byte[] bytes, TruffleString.Encoding tencoding) {
        return TStringUtils.fromByteArray(bytes, 0, bytes.length, tencoding);
    }

    public static TruffleString fromByteArray(byte[] bytes, int offset, int length, TruffleString.Encoding tencoding) {
        CompilerAsserts.neverPartOfCompilation((String)"Use createString(TruffleString.FromByteArrayNode, byte[], RubyEncoding) instead");
        return TruffleString.fromByteArrayUncached((byte[])bytes, (int)offset, (int)length, (TruffleString.Encoding)tencoding, (boolean)false);
    }

    public static TruffleString fromByteArray(byte[] bytes, RubyEncoding rubyEncoding) {
        return TStringUtils.fromByteArray(bytes, rubyEncoding.tencoding);
    }

    public static TruffleString utf8TString(String javaString) {
        return TStringUtils.fromJavaString(javaString, TruffleString.Encoding.UTF_8);
    }

    public static TruffleString usAsciiString(String javaString) {
        return TStringUtils.fromJavaString(javaString, TruffleString.Encoding.US_ASCII);
    }

    public static TruffleString fromJavaString(String javaString, TruffleString.Encoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"Use createString(TruffleString.FromJavaStringNode, String, RubyEncoding) instead");
        return TruffleString.fromJavaStringUncached((String)javaString, (TruffleString.Encoding)encoding);
    }

    public static TruffleString fromJavaString(String javaString, RubyEncoding encoding) {
        return TStringUtils.fromJavaString(javaString, encoding.tencoding);
    }

    public static byte[] getBytesOrCopy(AbstractTruffleString tstring, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached");
        InternalByteArray bytes = tstring.getInternalByteArrayUncached(encoding.tencoding);
        if (tstring.isImmutable() && bytes.getOffset() == 0 && bytes.getLength() == bytes.getArray().length) {
            return bytes.getArray();
        }
        return ArrayUtils.extractRange(bytes.getArray(), bytes.getOffset(), bytes.getEnd());
    }

    public static byte[] getBytesOrCopy(Node node, AbstractTruffleString tstring, TruffleString.Encoding encoding, TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, InlinedConditionProfile noCopyProfile) {
        InternalByteArray bytes = getInternalByteArrayNode.execute(tstring, encoding);
        if (noCopyProfile.profile(node, tstring.isImmutable() && bytes.getOffset() == 0 && bytes.getLength() == bytes.getArray().length)) {
            return bytes.getArray();
        }
        return ArrayUtils.extractRange(bytes.getArray(), bytes.getOffset(), bytes.getEnd());
    }

    public static byte[] getBytesOrFail(AbstractTruffleString tstring, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached");
        if (DEBUG_NON_ZERO_OFFSET) {
            return TStringUtils.getBytesOrCopy(tstring, encoding);
        }
        InternalByteArray byteArray = tstring.getInternalByteArrayUncached(encoding.tencoding);
        if (byteArray.getOffset() != 0 || byteArray.getLength() != byteArray.getArray().length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return byteArray.getArray();
    }

    public static byte[] getBytesOrFail(AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.GetInternalByteArrayNode byteArrayNode) {
        if (DEBUG_NON_ZERO_OFFSET) {
            return TStringUtils.getBytesOrCopy(tstring, encoding);
        }
        InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
        if (byteArray.getOffset() != 0 || byteArray.getLength() != byteArray.getArray().length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return byteArray.getArray();
    }

    public static byte[] javaStringToBytes(String value, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached");
        TruffleString tstring = TStringUtils.fromJavaString(value, encoding);
        return TStringUtils.getBytesOrCopy((AbstractTruffleString)tstring, encoding);
    }

    public static String bytesToJavaStringOrThrow(byte[] bytes, int offset, int length, RubyEncoding encoding) {
        TruffleString tstring = TStringUtils.fromByteArray(bytes, offset, length, encoding.tencoding);
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)tstring, encoding);
    }

    public static boolean isSingleByteOptimizable(AbstractTruffleString truffleString, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"Use SingleByteOptimizableNode instead");
        return truffleString.getByteCodeRangeUncached(encoding.tencoding) == TruffleString.CodeRange.ASCII || encoding.isSingleByte;
    }

    public static String toJavaStringOrThrow(byte[] bytes, RubyEncoding encoding) {
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)TStringUtils.fromByteArray(bytes, encoding), encoding);
    }

    public static String toJavaStringOrThrow(AbstractTruffleString tstring, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached");
        if (encoding == Encodings.BINARY && !StringGuards.is7BitUncached(tstring, encoding)) {
            int length = tstring.byteLength(encoding.tencoding);
            for (int i = 0; i < length; ++i) {
                int b = tstring.readByteUncached(i, encoding.tencoding);
                if (Encoding.isAscii((int)b)) continue;
                throw new CannotConvertBinaryRubyStringToJavaString(b);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        return tstring.toJavaStringUncached();
    }

    public static boolean hasImmutableInternalByteArray(AbstractTruffleString string) {
        return string.isImmutable() || string.isNative();
    }
}

