/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToRubyEncodingNode;
import org.truffleruby.core.cast.ToRubyEncodingNodeGen;
import org.truffleruby.core.encoding.EncodingNodes;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.ToJavaStringNodeGen;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.language.yield.CallBlockNodeGen;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString.CodeRange[] CODE_RANGE_VALUES = (TruffleString.CodeRange[])DSLSupport.lookupEnumConstants(TruffleString.CodeRange.class);

    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return List.of(AsciiCompatibleNodeFactory.getInstance(), CompatibleQueryNodeFactory.getInstance(), AreStringsCompatibleNodeFactory.getInstance(), ListNodeFactory.getInstance(), LocaleCharacterMapNodeFactory.getInstance(), DummyNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), EachAliasNodeFactory.getInstance(), DefineAliasNodeFactory.getInstance(), IsUnicodeNodeFactory.getInstance(), GetActualEncodingPrimitiveNodeFactory.getInstance(), GetDefaultEncodingNodeFactory.getInstance(), SetDefaultExternalNodeFactory.getInstance(), SetDefaultInternalNodeFactory.getInstance(), EncodingGetObjectEncodingNodeFactory.getInstance(), EncodingReplicateNodeFactory.getInstance(), DummyEncodingNodeFactory.getInstance(), GetEncodingObjectByIndexNodeFactory.getInstance(), GetEncodingIndexNodeFactory.getInstance(), CheckStringEncodingPrimitiveNodeFactory.getInstance(), EncodingCheckEncodingNodeFactory.getInstance(), UnicodeVersionNodeFactory.getInstance(), UnicodeEmojiVersionNodeFactory.getInstance());
    }

    private static TruffleString.CodeRange decodeCodeRange(int state) {
        if (state >= 0) {
            return CODE_RANGE_VALUES[state];
        }
        return null;
    }

    private static int encodeCodeRange(TruffleString.CodeRange e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
    public static final class AsciiCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AsciiCompatibleNode> {
        private static final AsciiCompatibleNodeFactory ASCII_COMPATIBLE_NODE_FACTORY_INSTANCE = new AsciiCompatibleNodeFactory();

        private AsciiCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AsciiCompatibleNode> getNodeClass() {
            return EncodingNodes.AsciiCompatibleNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AsciiCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AsciiCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AsciiCompatibleNode> getInstance() {
            return ASCII_COMPATIBLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AsciiCompatibleNode create(RubyNode[] argumentNodes) {
            return new AsciiCompatibleNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
        public static final class AsciiCompatibleNodeGen
        extends EncodingNodes.AsciiCompatibleNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AsciiCompatibleNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isAsciiCompatible(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isAsciiCompatible(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    implements NodeFactory<EncodingNodes.CompatibleQueryNode> {
        private static final CompatibleQueryNodeFactory COMPATIBLE_QUERY_NODE_FACTORY_INSTANCE = new CompatibleQueryNodeFactory();

        private CompatibleQueryNodeFactory() {
        }

        public Class<EncodingNodes.CompatibleQueryNode> getNodeClass() {
            return EncodingNodes.CompatibleQueryNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompatibleQueryNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            return COMPATIBLE_QUERY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.CompatibleQueryNode create(RubyNode[] argumentNodes) {
            return new CompatibleQueryNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        public static final class CompatibleQueryNodeGen
        extends EncodingNodes.CompatibleQueryNode {
            private static final InlineSupport.StateField STATE_0_CompatibleQueryNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final EncodingNodes.NegotiateCompatibleEncodingNode INLINED_NEGOTIATE_COMPATIBLE_ENCODING_NODE_ = NegotiateCompatibleEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CompatibleQueryNode_UPDATER.subUpdater(0, 8), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field4_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field6_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleEncodingNode__field7_", Object.class)}));
            private static final ToRubyEncodingNode INLINED_TO_RUBY_ENCODING_NODE_ = ToRubyEncodingNodeGen.inline(InlineSupport.InlineTarget.create(ToRubyEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CompatibleQueryNode_UPDATER.subUpdater(8, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toRubyEncodingNode__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toRubyEncodingNode__field2_", Object.class)}));
            private static final InlinedConditionProfile INLINED_NO_NEGOTIATED_ENCODING_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CompatibleQueryNode_UPDATER.subUpdater(14, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleEncodingNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleEncodingNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleEncodingNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleEncodingNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleEncodingNode__field5_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleEncodingNode__field6_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleEncodingNode__field7_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object toRubyEncodingNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object toRubyEncodingNode__field2_;

            private CompatibleQueryNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                return this.isCompatible(argumentNodes0Value_, argumentNodes1Value_, INLINED_NEGOTIATE_COMPATIBLE_ENCODING_NODE_, INLINED_TO_RUBY_ENCODING_NODE_, INLINED_NO_NEGOTIATED_ENCODING_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AreStringsCompatibleNode.class)
    public static final class AreStringsCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AreStringsCompatibleNode> {
        private static final AreStringsCompatibleNodeFactory ARE_STRINGS_COMPATIBLE_NODE_FACTORY_INSTANCE = new AreStringsCompatibleNodeFactory();

        private AreStringsCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AreStringsCompatibleNode> getNodeClass() {
            return EncodingNodes.AreStringsCompatibleNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AreStringsCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AreStringsCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AreStringsCompatibleNode> getInstance() {
            return ARE_STRINGS_COMPATIBLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AreStringsCompatibleNode create(RubyNode[] argumentNodes) {
            return new AreStringsCompatibleNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AreStringsCompatibleNode.class)
        public static final class AreStringsCompatibleNodeGen
        extends EncodingNodes.AreStringsCompatibleNode {
            private static final InlineSupport.StateField STATE_0_AreStringsCompatibleNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final EncodingNodes.NegotiateCompatibleStringEncodingNode INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(1, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field3_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"negotiateCompatibleStringEncodingNode__field4_", Object.class)}));
            private static final InlinedConditionProfile INLINED_NO_NEGOTIATED_ENCODING_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AreStringsCompatibleNode_UPDATER.subUpdater(6, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private RubyStringLibrary libFirst_;
            @CompilerDirectives.CompilationFinal
            private RubyStringLibrary libSecond_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateCompatibleStringEncodingNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleStringEncodingNode__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleStringEncodingNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateCompatibleStringEncodingNode__field4_;

            private AreStringsCompatibleNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyStringLibrary libSecond__;
                RubyStringLibrary libFirst__;
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && (libFirst__ = this.libFirst_) != null && (libSecond__ = this.libSecond_) != null) {
                    return this.areCompatible(argumentNodes0Value_, argumentNodes1Value_, libFirst__, libSecond__, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, INLINED_NO_NEGOTIATED_ENCODING_PROFILE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                RubyStringLibrary libFirst__ = RubyStringLibrary.create();
                Objects.requireNonNull(libFirst__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.libFirst_ = libFirst__;
                RubyStringLibrary libSecond__ = RubyStringLibrary.create();
                Objects.requireNonNull(libSecond__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.libSecond_ = libSecond__;
                this.state_0_ = state_0 |= 1;
                return this.areCompatible(argumentNodes0Value, argumentNodes1Value, libFirst__, libSecond__, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, INLINED_NO_NEGOTIATED_ENCODING_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<EncodingNodes.ListNode> {
        private static final ListNodeFactory LIST_NODE_FACTORY_INSTANCE = new ListNodeFactory();

        private ListNodeFactory() {
        }

        public Class<EncodingNodes.ListNode> getNodeClass() {
            return EncodingNodes.ListNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            return LIST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.ListNode create(RubyNode[] argumentNodes) {
            return new ListNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        public static final class ListNodeGen
        extends EncodingNodes.ListNode {
            private ListNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
    public static final class LocaleCharacterMapNodeFactory
    implements NodeFactory<EncodingNodes.LocaleCharacterMapNode> {
        private static final LocaleCharacterMapNodeFactory LOCALE_CHARACTER_MAP_NODE_FACTORY_INSTANCE = new LocaleCharacterMapNodeFactory();

        private LocaleCharacterMapNodeFactory() {
        }

        public Class<EncodingNodes.LocaleCharacterMapNode> getNodeClass() {
            return EncodingNodes.LocaleCharacterMapNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.LocaleCharacterMapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocaleCharacterMapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.LocaleCharacterMapNode> getInstance() {
            return LOCALE_CHARACTER_MAP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.LocaleCharacterMapNode create(RubyNode[] argumentNodes) {
            return new LocaleCharacterMapNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
        public static final class LocaleCharacterMapNodeGen
        extends EncodingNodes.LocaleCharacterMapNode {
            private LocaleCharacterMapNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localeCharacterMap();
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    implements NodeFactory<EncodingNodes.DummyNode> {
        private static final DummyNodeFactory DUMMY_NODE_FACTORY_INSTANCE = new DummyNodeFactory();

        private DummyNodeFactory() {
        }

        public Class<EncodingNodes.DummyNode> getNodeClass() {
            return EncodingNodes.DummyNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            return DUMMY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DummyNode create(RubyNode[] argumentNodes) {
            return new DummyNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        public static final class DummyNodeGen
        extends EncodingNodes.DummyNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DummyNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isDummy(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isDummy(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    implements NodeFactory<EncodingNodes.ToSNode> {
        private static final ToSNodeFactory TO_S_NODE_FACTORY_INSTANCE = new ToSNodeFactory();

        private ToSNodeFactory() {
        }

        public Class<EncodingNodes.ToSNode> getNodeClass() {
            return EncodingNodes.ToSNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            return TO_S_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.ToSNode create(RubyNode[] argumentNodes) {
            return new ToSNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends EncodingNodes.ToSNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ToSNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.toS(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private ImmutableRubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.toS(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<EncodingNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<EncodingNodes.AllocateNode> getNodeClass() {
            return EncodingNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
    public static final class EachAliasNodeFactory
    implements NodeFactory<EncodingNodes.EachAliasNode> {
        private static final EachAliasNodeFactory EACH_ALIAS_NODE_FACTORY_INSTANCE = new EachAliasNodeFactory();

        private EachAliasNodeFactory() {
        }

        public Class<EncodingNodes.EachAliasNode> getNodeClass() {
            return EncodingNodes.EachAliasNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EachAliasNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachAliasNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EachAliasNode> getInstance() {
            return EACH_ALIAS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EachAliasNode create(RubyNode[] argumentNodes) {
            return new EachAliasNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
        public static final class EachAliasNodeGen
        extends EncodingNodes.EachAliasNode {
            private static final InlineSupport.StateField STATE_0_EachAliasNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final CallBlockNode INLINED_YIELD_NODE_ = CallBlockNodeGen.inline(InlineSupport.InlineTarget.create(CallBlockNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EachAliasNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field2_;

            private EachAliasNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyProc) {
                    RubyProc argumentNodes0Value__ = (RubyProc)argumentNodes0Value_;
                    return this.eachAlias(argumentNodes0Value__, INLINED_YIELD_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyProc) {
                    RubyProc argumentNodes0Value_ = (RubyProc)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.eachAlias(argumentNodes0Value_, INLINED_YIELD_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DefineAliasNode.class)
    public static final class DefineAliasNodeFactory
    implements NodeFactory<EncodingNodes.DefineAliasNode> {
        private static final DefineAliasNodeFactory DEFINE_ALIAS_NODE_FACTORY_INSTANCE = new DefineAliasNodeFactory();

        private DefineAliasNodeFactory() {
        }

        public Class<EncodingNodes.DefineAliasNode> getNodeClass() {
            return EncodingNodes.DefineAliasNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DefineAliasNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefineAliasNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DefineAliasNode> getInstance() {
            return DEFINE_ALIAS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DefineAliasNode create(RubyNode[] argumentNodes) {
            return new DefineAliasNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DefineAliasNode.class)
        public static final class DefineAliasNodeGen
        extends EncodingNodes.DefineAliasNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DefineAliasNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value__ = (RubySymbol)argumentNodes1Value_;
                        return this.defineAlias(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value_ = (RubySymbol)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.defineAlias(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.IsUnicodeNode.class)
    public static final class IsUnicodeNodeFactory
    implements NodeFactory<EncodingNodes.IsUnicodeNode> {
        private static final IsUnicodeNodeFactory IS_UNICODE_NODE_FACTORY_INSTANCE = new IsUnicodeNodeFactory();

        private IsUnicodeNodeFactory() {
        }

        public Class<EncodingNodes.IsUnicodeNode> getNodeClass() {
            return EncodingNodes.IsUnicodeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.IsUnicodeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsUnicodeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.IsUnicodeNode> getInstance() {
            return IS_UNICODE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.IsUnicodeNode create(RubyNode[] argumentNodes) {
            return new IsUnicodeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.IsUnicodeNode.class)
        public static final class IsUnicodeNodeGen
        extends EncodingNodes.IsUnicodeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsUnicodeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.isUnicode(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isUnicode(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetActualEncodingPrimitiveNode.class)
    public static final class GetActualEncodingPrimitiveNodeFactory
    implements NodeFactory<EncodingNodes.GetActualEncodingPrimitiveNode> {
        private static final GetActualEncodingPrimitiveNodeFactory GET_ACTUAL_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE = new GetActualEncodingPrimitiveNodeFactory();

        private GetActualEncodingPrimitiveNodeFactory() {
        }

        public Class<EncodingNodes.GetActualEncodingPrimitiveNode> getNodeClass() {
            return EncodingNodes.GetActualEncodingPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetActualEncodingPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetActualEncodingPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetActualEncodingPrimitiveNode> getInstance() {
            return GET_ACTUAL_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetActualEncodingPrimitiveNode create(RubyNode[] argumentNodes) {
            return new GetActualEncodingPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetActualEncodingPrimitiveNode.class)
        public static final class GetActualEncodingPrimitiveNodeGen
        extends EncodingNodes.GetActualEncodingPrimitiveNode {
            private static final InlineSupport.StateField GET_ACTUAL_ENCODING__GET_ACTUAL_ENCODING_PRIMITIVE_NODE_GET_ACTUAL_ENCODING_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GetActualEncodingData.lookup_(), (String)"getActualEncoding_state_0_");
            static final InlineSupport.ReferenceField<GetActualEncodingData> GET_ACTUAL_ENCODING_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getActualEncoding_cache", GetActualEncodingData.class);
            private static final EncodingNodes.GetActualEncodingNode INLINED_GET_ACTUAL_ENCODING_NODE_ = GetActualEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.GetActualEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GET_ACTUAL_ENCODING__GET_ACTUAL_ENCODING_PRIMITIVE_NODE_GET_ACTUAL_ENCODING_STATE_0_UPDATER.subUpdater(0, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GetActualEncodingData.lookup_(), (String)"getActualEncodingNode__field1_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private GetActualEncodingData getActualEncoding_cache;

            private GetActualEncodingPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                GetActualEncodingData s0_;
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && (s0_ = this.getActualEncoding_cache) != null && s0_.libString_.isRubyString(argumentNodes0Value_)) {
                    GetActualEncodingData node__ = s0_;
                    return EncodingNodes.GetActualEncodingPrimitiveNode.getActualEncoding(argumentNodes0Value_, INLINED_GET_ACTUAL_ENCODING_NODE_, s0_.libString_, node__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value) {
                GetActualEncodingData s0_;
                GetActualEncodingData node__;
                block5: {
                    GetActualEncodingData s0_original;
                    int state_0 = this.state_0_;
                    node__ = null;
                    do {
                        RubyStringLibrary libString__;
                        int count0_ = 0;
                        s0_original = s0_ = (GetActualEncodingData)((Object)GET_ACTUAL_ENCODING_CACHE_UPDATER.getVolatile((Node)this));
                        if (s0_ != null) {
                            if (s0_.libString_.isRubyString(argumentNodes0Value)) {
                                node__ = s0_;
                            } else {
                                ++count0_;
                                s0_ = null;
                            }
                        }
                        if (s0_ != null || count0_ >= true || !(libString__ = RubyStringLibrary.create()).isRubyString(argumentNodes0Value)) break block5;
                        s0_ = (GetActualEncodingData)this.insert(new GetActualEncodingData());
                        Objects.requireNonNull(libString__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.libString_ = libString__;
                        node__ = s0_;
                    } while (!GET_ACTUAL_ENCODING_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return EncodingNodes.GetActualEncodingPrimitiveNode.getActualEncoding(argumentNodes0Value, INLINED_GET_ACTUAL_ENCODING_NODE_, s0_.libString_, node__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            @GeneratedBy(value=EncodingNodes.GetActualEncodingPrimitiveNode.class)
            @DenyReplace
            private static final class GetActualEncodingData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int getActualEncoding_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node getActualEncodingNode__field1_;
                @CompilerDirectives.CompilationFinal
                RubyStringLibrary libString_;

                GetActualEncodingData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
    public static final class GetDefaultEncodingNodeFactory
    implements NodeFactory<EncodingNodes.GetDefaultEncodingNode> {
        private static final GetDefaultEncodingNodeFactory GET_DEFAULT_ENCODING_NODE_FACTORY_INSTANCE = new GetDefaultEncodingNodeFactory();

        private GetDefaultEncodingNodeFactory() {
        }

        public Class<EncodingNodes.GetDefaultEncodingNode> getNodeClass() {
            return EncodingNodes.GetDefaultEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetDefaultEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetDefaultEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetDefaultEncodingNode> getInstance() {
            return GET_DEFAULT_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetDefaultEncodingNode create(RubyNode[] argumentNodes) {
            return new GetDefaultEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
        public static final class GetDefaultEncodingNodeGen
        extends EncodingNodes.GetDefaultEncodingNode {
            @Node.Child
            private RubyNode argumentNodes0_;

            private GetDefaultEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.getDefaultEncoding(argumentNodes0Value_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
    public static final class SetDefaultExternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultExternalNode> {
        private static final SetDefaultExternalNodeFactory SET_DEFAULT_EXTERNAL_NODE_FACTORY_INSTANCE = new SetDefaultExternalNodeFactory();

        private SetDefaultExternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultExternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultExternalNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultExternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultExternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultExternalNode> getInstance() {
            return SET_DEFAULT_EXTERNAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.SetDefaultExternalNode create(RubyNode[] argumentNodes) {
            return new SetDefaultExternalNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        public static final class SetDefaultExternalNodeGen
        extends EncodingNodes.SetDefaultExternalNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SetDefaultExternalNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                        RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                        return this.setDefaultExternal(argumentNodes0Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes0Value_)) {
                        Nil argumentNodes0Value__ = RubyTypes.asNil(argumentNodes0Value_);
                        return this.noDefaultExternal(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setDefaultExternal(argumentNodes0Value_);
                }
                if (RubyTypes.isNil(argumentNodes0Value)) {
                    Nil argumentNodes0Value_ = RubyTypes.asNil(argumentNodes0Value);
                    this.state_0_ = state_0 |= 2;
                    return this.noDefaultExternal(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
    public static final class SetDefaultInternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultInternalNode> {
        private static final SetDefaultInternalNodeFactory SET_DEFAULT_INTERNAL_NODE_FACTORY_INSTANCE = new SetDefaultInternalNodeFactory();

        private SetDefaultInternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultInternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultInternalNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultInternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultInternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultInternalNode> getInstance() {
            return SET_DEFAULT_INTERNAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.SetDefaultInternalNode create(RubyNode[] argumentNodes) {
            return new SetDefaultInternalNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        public static final class SetDefaultInternalNodeGen
        extends EncodingNodes.SetDefaultInternalNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SetDefaultInternalNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                        RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                        return this.setDefaultInternal(argumentNodes0Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes0Value_)) {
                        Nil argumentNodes0Value__ = RubyTypes.asNil(argumentNodes0Value_);
                        return this.noDefaultInternal(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setDefaultInternal(argumentNodes0Value_);
                }
                if (RubyTypes.isNil(argumentNodes0Value)) {
                    Nil argumentNodes0Value_ = RubyTypes.asNil(argumentNodes0Value);
                    this.state_0_ = state_0 |= 2;
                    return this.noDefaultInternal(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
    public static final class EncodingGetObjectEncodingNodeFactory
    implements NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> {
        private static final EncodingGetObjectEncodingNodeFactory ENCODING_GET_OBJECT_ENCODING_NODE_FACTORY_INSTANCE = new EncodingGetObjectEncodingNodeFactory();

        private EncodingGetObjectEncodingNodeFactory() {
        }

        public Class<EncodingNodes.EncodingGetObjectEncodingNode> getNodeClass() {
            return EncodingNodes.EncodingGetObjectEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EncodingGetObjectEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingGetObjectEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> getInstance() {
            return ENCODING_GET_OBJECT_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EncodingGetObjectEncodingNode create(RubyNode[] argumentNodes) {
            return new EncodingGetObjectEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
        public static final class EncodingGetObjectEncodingNodeGen
        extends EncodingNodes.EncodingGetObjectEncodingNode {
            private static final InlineSupport.StateField STATE_0_EncodingGetObjectEncodingNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final ToRubyEncodingNode INLINED_TO_RUBY_ENCODING_NODE_ = ToRubyEncodingNodeGen.inline(InlineSupport.InlineTarget.create(ToRubyEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EncodingGetObjectEncodingNode_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toRubyEncodingNode__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"toRubyEncodingNode__field2_", Object.class)}));
            private static final InlinedConditionProfile INLINED_NULL_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EncodingGetObjectEncodingNode_UPDATER.subUpdater(6, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object toRubyEncodingNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object toRubyEncodingNode__field2_;

            private EncodingGetObjectEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.getObjectEncoding(argumentNodes0Value_, INLINED_TO_RUBY_ENCODING_NODE_, INLINED_NULL_PROFILE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
    public static final class EncodingReplicateNodeFactory
    implements NodeFactory<EncodingNodes.EncodingReplicateNode> {
        private static final EncodingReplicateNodeFactory ENCODING_REPLICATE_NODE_FACTORY_INSTANCE = new EncodingReplicateNodeFactory();

        private EncodingReplicateNodeFactory() {
        }

        public Class<EncodingNodes.EncodingReplicateNode> getNodeClass() {
            return EncodingNodes.EncodingReplicateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EncodingReplicateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingReplicateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingReplicateNode> getInstance() {
            return ENCODING_REPLICATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EncodingReplicateNode create(RubyNode[] argumentNodes) {
            return new EncodingReplicateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
        public static final class EncodingReplicateNodeGen
        extends EncodingNodes.EncodingReplicateNode {
            private static final InlineSupport.StateField ENCODING_REPLICATE__ENCODING_REPLICATE_NODE_ENCODING_REPLICATE_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)EncodingReplicateData.lookup_(), (String)"encodingReplicate_state_0_");
            static final InlineSupport.ReferenceField<EncodingReplicateData> ENCODING_REPLICATE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"encodingReplicate_cache", EncodingReplicateData.class);
            private static final ToJavaStringNode INLINED_TO_JAVA_STRING_NODE_ = ToJavaStringNodeGen.inline(InlineSupport.InlineTarget.create(ToJavaStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{ENCODING_REPLICATE__ENCODING_REPLICATE_NODE_ENCODING_REPLICATE_STATE_0_UPDATER.subUpdater(0, 12), InlineSupport.ReferenceField.create((MethodHandles.Lookup)EncodingReplicateData.lookup_(), (String)"toJavaStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)EncodingReplicateData.lookup_(), (String)"toJavaStringNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private EncodingReplicateData encodingReplicate_cache;

            private EncodingReplicateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    EncodingReplicateData s0_ = this.encodingReplicate_cache;
                    if (s0_ != null && s0_.strings_.isRubyString(argumentNodes1Value_)) {
                        EncodingReplicateData node__ = s0_;
                        return EncodingNodes.EncodingReplicateNode.encodingReplicate(argumentNodes0Value__, argumentNodes1Value_, s0_.strings_, INLINED_TO_JAVA_STRING_NODE_, node__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyArray executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                EncodingReplicateData node__ = null;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    EncodingReplicateData s0_;
                    RubyEncoding argumentNodes0Value_;
                    block6: {
                        EncodingReplicateData s0_original;
                        argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                        do {
                            RubyStringLibrary strings__;
                            int count0_ = 0;
                            s0_original = s0_ = (EncodingReplicateData)((Object)ENCODING_REPLICATE_CACHE_UPDATER.getVolatile((Node)this));
                            if (s0_ != null) {
                                if (s0_.strings_.isRubyString(argumentNodes1Value)) {
                                    node__ = s0_;
                                } else {
                                    ++count0_;
                                    s0_ = null;
                                }
                            }
                            if (s0_ != null || count0_ >= true || !(strings__ = RubyStringLibrary.create()).isRubyString(argumentNodes1Value)) break block6;
                            s0_ = (EncodingReplicateData)this.insert(new EncodingReplicateData());
                            Objects.requireNonNull(strings__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.strings_ = strings__;
                            node__ = s0_;
                        } while (!ENCODING_REPLICATE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        return EncodingNodes.EncodingReplicateNode.encodingReplicate(argumentNodes0Value_, argumentNodes1Value, s0_.strings_, INLINED_TO_JAVA_STRING_NODE_, node__);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
            @DenyReplace
            private static final class EncodingReplicateData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int encodingReplicate_state_0_;
                @CompilerDirectives.CompilationFinal
                RubyStringLibrary strings_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node toJavaStringNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node toJavaStringNode__field2_;

                EncodingReplicateData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyEncodingNode.class)
    public static final class DummyEncodingNodeFactory
    implements NodeFactory<EncodingNodes.DummyEncodingNode> {
        private static final DummyEncodingNodeFactory DUMMY_ENCODING_NODE_FACTORY_INSTANCE = new DummyEncodingNodeFactory();

        private DummyEncodingNodeFactory() {
        }

        public Class<EncodingNodes.DummyEncodingNode> getNodeClass() {
            return EncodingNodes.DummyEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.DummyEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyEncodingNode> getInstance() {
            return DUMMY_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.DummyEncodingNode create(RubyNode[] argumentNodes) {
            return new DummyEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.DummyEncodingNode.class)
        public static final class DummyEncodingNodeGen
        extends EncodingNodes.DummyEncodingNode {
            private static final InlineSupport.StateField CREATE_DUMMY_ENCODING__DUMMY_ENCODING_NODE_CREATE_DUMMY_ENCODING_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CreateDummyEncodingData.lookup_(), (String)"createDummyEncoding_state_0_");
            static final InlineSupport.ReferenceField<CreateDummyEncodingData> CREATE_DUMMY_ENCODING_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"createDummyEncoding_cache", CreateDummyEncodingData.class);
            private static final ToJavaStringNode INLINED_TO_JAVA_STRING_NODE_ = ToJavaStringNodeGen.inline(InlineSupport.InlineTarget.create(ToJavaStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CREATE_DUMMY_ENCODING__DUMMY_ENCODING_NODE_CREATE_DUMMY_ENCODING_STATE_0_UPDATER.subUpdater(0, 12), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CreateDummyEncodingData.lookup_(), (String)"toJavaStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CreateDummyEncodingData.lookup_(), (String)"toJavaStringNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CreateDummyEncodingData createDummyEncoding_cache;

            private DummyEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                CreateDummyEncodingData s0_;
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && (s0_ = this.createDummyEncoding_cache) != null && s0_.strings_.isRubyString(argumentNodes0Value_)) {
                    CreateDummyEncodingData node__ = s0_;
                    return EncodingNodes.DummyEncodingNode.createDummyEncoding(argumentNodes0Value_, s0_.strings_, INLINED_TO_JAVA_STRING_NODE_, node__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyArray executeAndSpecialize(Object argumentNodes0Value) {
                CreateDummyEncodingData s0_;
                CreateDummyEncodingData node__;
                block5: {
                    CreateDummyEncodingData s0_original;
                    int state_0 = this.state_0_;
                    node__ = null;
                    do {
                        RubyStringLibrary strings__;
                        int count0_ = 0;
                        s0_original = s0_ = (CreateDummyEncodingData)((Object)CREATE_DUMMY_ENCODING_CACHE_UPDATER.getVolatile((Node)this));
                        if (s0_ != null) {
                            if (s0_.strings_.isRubyString(argumentNodes0Value)) {
                                node__ = s0_;
                            } else {
                                ++count0_;
                                s0_ = null;
                            }
                        }
                        if (s0_ != null || count0_ >= true || !(strings__ = RubyStringLibrary.create()).isRubyString(argumentNodes0Value)) break block5;
                        s0_ = (CreateDummyEncodingData)this.insert(new CreateDummyEncodingData());
                        Objects.requireNonNull(strings__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.strings_ = strings__;
                        node__ = s0_;
                    } while (!CREATE_DUMMY_ENCODING_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return EncodingNodes.DummyEncodingNode.createDummyEncoding(argumentNodes0Value, s0_.strings_, INLINED_TO_JAVA_STRING_NODE_, node__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            @GeneratedBy(value=EncodingNodes.DummyEncodingNode.class)
            @DenyReplace
            private static final class CreateDummyEncodingData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int createDummyEncoding_state_0_;
                @CompilerDirectives.CompilationFinal
                RubyStringLibrary strings_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node toJavaStringNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node toJavaStringNode__field2_;

                CreateDummyEncodingData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
    public static final class GetEncodingObjectByIndexNodeFactory
    implements NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> {
        private static final GetEncodingObjectByIndexNodeFactory GET_ENCODING_OBJECT_BY_INDEX_NODE_FACTORY_INSTANCE = new GetEncodingObjectByIndexNodeFactory();

        private GetEncodingObjectByIndexNodeFactory() {
        }

        public Class<EncodingNodes.GetEncodingObjectByIndexNode> getNodeClass() {
            return EncodingNodes.GetEncodingObjectByIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetEncodingObjectByIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetEncodingObjectByIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> getInstance() {
            return GET_ENCODING_OBJECT_BY_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetEncodingObjectByIndexNode create(RubyNode[] argumentNodes) {
            return new GetEncodingObjectByIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
        public static final class GetEncodingObjectByIndexNodeGen
        extends EncodingNodes.GetEncodingObjectByIndexNode {
            static final InlineSupport.ReferenceField<GetEncodingData> GET_ENCODING_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getEncoding_cache", GetEncodingData.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private GetEncodingData getEncoding_cache;

            private GetEncodingObjectByIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof Integer) {
                    int argumentNodes0Value__ = (Integer)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)this.isSingleContext()));
                        GetEncodingData s0_ = this.getEncoding_cache;
                        while (s0_ != null) {
                            if (argumentNodes0Value__ == s0_.cachedIndex_) {
                                return this.getEncoding(argumentNodes0Value__, s0_.cachedIndex_, s0_.cachedEncoding_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.getEncodingUncached(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof Integer) {
                    int argumentNodes0Value_ = (Integer)argumentNodes0Value;
                    if ((state_0 & 2) == 0 && this.isSingleContext()) {
                        GetEncodingData s0_;
                        block5: {
                            GetEncodingData s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (GetEncodingData)GET_ENCODING_CACHE_UPDATER.getVolatile((Node)this);
                                while (s0_ != null && argumentNodes0Value_ != s0_.cachedIndex_) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= this.getCacheLimit()) break block5;
                                s0_ = new GetEncodingData(s0_original);
                                s0_.cachedIndex_ = argumentNodes0Value_;
                                s0_.cachedEncoding_ = this.getContext().getEncodingManager().getRubyEncoding(argumentNodes0Value_);
                            } while (!GET_ENCODING_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.getEncoding(argumentNodes0Value_, s0_.cachedIndex_, s0_.cachedEncoding_);
                        }
                    }
                    this.getEncoding_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    return this.getEncodingUncached(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            @DenyReplace
            private static final class GetEncodingData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                final GetEncodingData next_;
                @CompilerDirectives.CompilationFinal
                int cachedIndex_;
                @CompilerDirectives.CompilationFinal
                RubyEncoding cachedEncoding_;

                GetEncodingData(GetEncodingData next_) {
                    this.next_ = next_;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetEncodingIndexNode.class)
    public static final class GetEncodingIndexNodeFactory
    implements NodeFactory<EncodingNodes.GetEncodingIndexNode> {
        private static final GetEncodingIndexNodeFactory GET_ENCODING_INDEX_NODE_FACTORY_INSTANCE = new GetEncodingIndexNodeFactory();

        private GetEncodingIndexNodeFactory() {
        }

        public Class<EncodingNodes.GetEncodingIndexNode> getNodeClass() {
            return EncodingNodes.GetEncodingIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.GetEncodingIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetEncodingIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetEncodingIndexNode> getInstance() {
            return GET_ENCODING_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.GetEncodingIndexNode create(RubyNode[] argumentNodes) {
            return new GetEncodingIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.GetEncodingIndexNode.class)
        public static final class GetEncodingIndexNodeGen
        extends EncodingNodes.GetEncodingIndexNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private GetEncodingIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value__ = (RubyEncoding)argumentNodes0Value_;
                    return this.getIndex(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private int executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncoding) {
                    RubyEncoding argumentNodes0Value_ = (RubyEncoding)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getIndex(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CheckStringEncodingPrimitiveNode.class)
    public static final class CheckStringEncodingPrimitiveNodeFactory
    implements NodeFactory<EncodingNodes.CheckStringEncodingPrimitiveNode> {
        private static final CheckStringEncodingPrimitiveNodeFactory CHECK_STRING_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE = new CheckStringEncodingPrimitiveNodeFactory();

        private CheckStringEncodingPrimitiveNodeFactory() {
        }

        public Class<EncodingNodes.CheckStringEncodingPrimitiveNode> getNodeClass() {
            return EncodingNodes.CheckStringEncodingPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.CheckStringEncodingPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CheckStringEncodingPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CheckStringEncodingPrimitiveNode> getInstance() {
            return CHECK_STRING_ENCODING_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingPrimitiveNode create(RubyNode[] argumentNodes) {
            return new CheckStringEncodingPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingPrimitiveNode.class)
        public static final class CheckStringEncodingPrimitiveNodeGen
        extends EncodingNodes.CheckStringEncodingPrimitiveNode {
            private static final InlineSupport.StateField CHECK_ENCODING_STRING_STRING__CHECK_STRING_ENCODING_PRIMITIVE_NODE_CHECK_ENCODING_STRING_STRING_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CheckEncodingStringStringData.lookup_(), (String)"checkEncodingStringString_state_0_");
            static final InlineSupport.ReferenceField<CheckEncodingStringStringData> CHECK_ENCODING_STRING_STRING_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingStringString_cache", CheckEncodingStringStringData.class);
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CHECK_ENCODING_STRING_STRING__CHECK_STRING_ENCODING_PRIMITIVE_NODE_CHECK_ENCODING_STRING_STRING_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final EncodingNodes.NegotiateCompatibleStringEncodingNode INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CHECK_ENCODING_STRING_STRING__CHECK_STRING_ENCODING_PRIMITIVE_NODE_CHECK_ENCODING_STRING_STRING_STATE_0_UPDATER.subUpdater(1, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CheckEncodingStringStringData.lookup_(), (String)"negotiateCompatibleStringEncodingNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CheckEncodingStringStringData.lookup_(), (String)"negotiateCompatibleStringEncodingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CheckEncodingStringStringData.lookup_(), (String)"negotiateCompatibleStringEncodingNode__field3_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CheckEncodingStringStringData.lookup_(), (String)"negotiateCompatibleStringEncodingNode__field4_", Object.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CheckEncodingStringStringData checkEncodingStringString_cache;

            private CheckStringEncodingPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                CheckEncodingStringStringData s0_;
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && (s0_ = this.checkEncodingStringString_cache) != null && s0_.libFirst_.isRubyString(argumentNodes0Value_) && s0_.libSecond_.isRubyString(argumentNodes1Value_)) {
                    CheckEncodingStringStringData node__ = s0_;
                    return EncodingNodes.CheckStringEncodingPrimitiveNode.checkEncodingStringString(argumentNodes0Value_, argumentNodes1Value_, s0_.libFirst_, s0_.libSecond_, INLINED_ERROR_PROFILE_, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, node__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyEncoding executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                CheckEncodingStringStringData s0_;
                CheckEncodingStringStringData node__;
                block5: {
                    CheckEncodingStringStringData s0_original;
                    int state_0 = this.state_0_;
                    node__ = null;
                    do {
                        RubyStringLibrary libSecond__;
                        RubyStringLibrary libFirst__;
                        int count0_ = 0;
                        s0_original = s0_ = (CheckEncodingStringStringData)((Object)CHECK_ENCODING_STRING_STRING_CACHE_UPDATER.getVolatile((Node)this));
                        if (s0_ != null) {
                            if (s0_.libFirst_.isRubyString(argumentNodes0Value) && s0_.libSecond_.isRubyString(argumentNodes1Value)) {
                                node__ = s0_;
                            } else {
                                ++count0_;
                                s0_ = null;
                            }
                        }
                        if (s0_ != null || count0_ >= true || !(libFirst__ = RubyStringLibrary.create()).isRubyString(argumentNodes0Value) || !(libSecond__ = RubyStringLibrary.create()).isRubyString(argumentNodes1Value)) break block5;
                        s0_ = (CheckEncodingStringStringData)this.insert(new CheckEncodingStringStringData());
                        Objects.requireNonNull(libFirst__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.libFirst_ = libFirst__;
                        Objects.requireNonNull(libSecond__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.libSecond_ = libSecond__;
                        node__ = s0_;
                    } while (!CHECK_ENCODING_STRING_STRING_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return EncodingNodes.CheckStringEncodingPrimitiveNode.checkEncodingStringString(argumentNodes0Value, argumentNodes1Value, s0_.libFirst_, s0_.libSecond_, INLINED_ERROR_PROFILE_, INLINED_NEGOTIATE_COMPATIBLE_STRING_ENCODING_NODE_, node__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            @GeneratedBy(value=EncodingNodes.CheckStringEncodingPrimitiveNode.class)
            @DenyReplace
            private static final class CheckEncodingStringStringData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int checkEncodingStringString_state_0_;
                @CompilerDirectives.CompilationFinal
                RubyStringLibrary libFirst_;
                @CompilerDirectives.CompilationFinal
                RubyStringLibrary libSecond_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node negotiateCompatibleStringEncodingNode__field1_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private Object negotiateCompatibleStringEncodingNode__field2_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private Object negotiateCompatibleStringEncodingNode__field3_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private Object negotiateCompatibleStringEncodingNode__field4_;

                CheckEncodingStringStringData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingCheckEncodingNode.class)
    public static final class EncodingCheckEncodingNodeFactory
    implements NodeFactory<EncodingNodes.EncodingCheckEncodingNode> {
        private static final EncodingCheckEncodingNodeFactory ENCODING_CHECK_ENCODING_NODE_FACTORY_INSTANCE = new EncodingCheckEncodingNodeFactory();

        private EncodingCheckEncodingNodeFactory() {
        }

        public Class<EncodingNodes.EncodingCheckEncodingNode> getNodeClass() {
            return EncodingNodes.EncodingCheckEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.EncodingCheckEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingCheckEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingCheckEncodingNode> getInstance() {
            return ENCODING_CHECK_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.EncodingCheckEncodingNode create(RubyNode[] argumentNodes) {
            return new EncodingCheckEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.EncodingCheckEncodingNode.class)
        public static final class EncodingCheckEncodingNodeGen
        extends EncodingNodes.EncodingCheckEncodingNode {
            private static final InlineSupport.StateField STATE_0_EncodingCheckEncodingNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final EncodingNodes.CheckEncodingNode INLINED_CHECK_ENCODING_NODE_ = CheckEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.CheckEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EncodingCheckEncodingNode_UPDATER.subUpdater(0, 15), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field3_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field4_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field6_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field7_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field8_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"checkEncodingNode__field9_", Object.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node checkEncodingNode__field5_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field6_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node checkEncodingNode__field7_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field8_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object checkEncodingNode__field9_;

            private EncodingCheckEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                return this.checkEncoding(argumentNodes0Value_, argumentNodes1Value_, INLINED_CHECK_ENCODING_NODE_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.UnicodeVersionNode.class)
    public static final class UnicodeVersionNodeFactory
    implements NodeFactory<EncodingNodes.UnicodeVersionNode> {
        private static final UnicodeVersionNodeFactory UNICODE_VERSION_NODE_FACTORY_INSTANCE = new UnicodeVersionNodeFactory();

        private UnicodeVersionNodeFactory() {
        }

        public Class<EncodingNodes.UnicodeVersionNode> getNodeClass() {
            return EncodingNodes.UnicodeVersionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.UnicodeVersionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnicodeVersionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.UnicodeVersionNode> getInstance() {
            return UNICODE_VERSION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.UnicodeVersionNode create(RubyNode[] argumentNodes) {
            return new UnicodeVersionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.UnicodeVersionNode.class)
        public static final class UnicodeVersionNodeGen
        extends EncodingNodes.UnicodeVersionNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private UnicodeVersionNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleString.FromJavaStringNode fromJavaStringNode__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (fromJavaStringNode__ = this.fromJavaStringNode_) != null) {
                    return this.getUnicodeVersion(fromJavaStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize();
            }

            private RubyString executeAndSpecialize() {
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fromJavaStringNode_ = fromJavaStringNode__;
                this.state_0_ = state_0 |= 1;
                return this.getUnicodeVersion(fromJavaStringNode__);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.UnicodeEmojiVersionNode.class)
    public static final class UnicodeEmojiVersionNodeFactory
    implements NodeFactory<EncodingNodes.UnicodeEmojiVersionNode> {
        private static final UnicodeEmojiVersionNodeFactory UNICODE_EMOJI_VERSION_NODE_FACTORY_INSTANCE = new UnicodeEmojiVersionNodeFactory();

        private UnicodeEmojiVersionNodeFactory() {
        }

        public Class<EncodingNodes.UnicodeEmojiVersionNode> getNodeClass() {
            return EncodingNodes.UnicodeEmojiVersionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingNodes.UnicodeEmojiVersionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnicodeEmojiVersionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.UnicodeEmojiVersionNode> getInstance() {
            return UNICODE_EMOJI_VERSION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNodes.UnicodeEmojiVersionNode create(RubyNode[] argumentNodes) {
            return new UnicodeEmojiVersionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingNodes.UnicodeEmojiVersionNode.class)
        public static final class UnicodeEmojiVersionNodeGen
        extends EncodingNodes.UnicodeEmojiVersionNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private UnicodeEmojiVersionNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleString.FromJavaStringNode fromJavaStringNode__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (fromJavaStringNode__ = this.fromJavaStringNode_) != null) {
                    return this.getUnicodeEmojiVersion(fromJavaStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize();
            }

            private RubyString executeAndSpecialize() {
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fromJavaStringNode_ = fromJavaStringNode__;
                this.state_0_ = state_0 |= 1;
                return this.getUnicodeEmojiVersion(fromJavaStringNode__);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
    public static final class CheckEncodingNodeGen {
        @NeverDefault
        public static EncodingNodes.CheckEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=15, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.CheckEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Object> toRubyEncodingNode__field1_;
            private final InlineSupport.ReferenceField<Object> toRubyEncodingNode__field2_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field1_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field2_;
            private final InlineSupport.ReferenceField<Node> negotiateCompatibleEncodingNode__field3_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field4_;
            private final InlineSupport.ReferenceField<Node> negotiateCompatibleEncodingNode__field5_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field6_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field7_;
            private final ToRubyEncodingNode toRubyEncodingNode_;
            private final EncodingNodes.NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode_;
            private final InlinedBranchProfile errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.CheckEncodingNode.class));
                this.state_0_ = target.getState(0, 15);
                this.toRubyEncodingNode__field1_ = target.getReference(1, Object.class);
                this.toRubyEncodingNode__field2_ = target.getReference(2, Object.class);
                this.negotiateCompatibleEncodingNode__field1_ = target.getReference(3, Object.class);
                this.negotiateCompatibleEncodingNode__field2_ = target.getReference(4, Object.class);
                this.negotiateCompatibleEncodingNode__field3_ = target.getReference(5, Node.class);
                this.negotiateCompatibleEncodingNode__field4_ = target.getReference(6, Object.class);
                this.negotiateCompatibleEncodingNode__field5_ = target.getReference(7, Node.class);
                this.negotiateCompatibleEncodingNode__field6_ = target.getReference(8, Object.class);
                this.negotiateCompatibleEncodingNode__field7_ = target.getReference(9, Object.class);
                this.toRubyEncodingNode_ = ToRubyEncodingNodeGen.inline(InlineSupport.InlineTarget.create(ToRubyEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 6), this.toRubyEncodingNode__field1_, this.toRubyEncodingNode__field2_}));
                this.negotiateCompatibleEncodingNode_ = NegotiateCompatibleEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(6, 8), this.negotiateCompatibleEncodingNode__field1_, this.negotiateCompatibleEncodingNode__field2_, this.negotiateCompatibleEncodingNode__field3_, this.negotiateCompatibleEncodingNode__field4_, this.negotiateCompatibleEncodingNode__field5_, this.negotiateCompatibleEncodingNode__field6_, this.negotiateCompatibleEncodingNode__field7_}));
                this.errorProfile_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(14, 1)}));
            }

            @Override
            public RubyEncoding execute(Node arg0Value, Object arg1Value, Object arg2Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.toRubyEncodingNode__field1_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.toRubyEncodingNode__field2_, this.state_0_, this.negotiateCompatibleEncodingNode__field1_, this.negotiateCompatibleEncodingNode__field2_, this.negotiateCompatibleEncodingNode__field3_, this.negotiateCompatibleEncodingNode__field4_, this.negotiateCompatibleEncodingNode__field5_, this.negotiateCompatibleEncodingNode__field6_, this.negotiateCompatibleEncodingNode__field7_, this.state_0_}));
                return EncodingNodes.CheckEncodingNode.checkEncoding(arg0Value, arg1Value, arg2Value, this.toRubyEncodingNode_, this.negotiateCompatibleEncodingNode_, this.errorProfile_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
    public static final class CheckStringEncodingNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static EncodingNodes.CheckStringEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
        @DenyReplace
        private static final class Uncached
        extends EncodingNodes.CheckStringEncodingNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyEncoding executeCheckEncoding(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                return EncodingNodes.CheckStringEncodingNode.checkEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedBranchProfile.getUncached(), NegotiateCompatibleStringEncodingNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckStringEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.CheckStringEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> negotiateCompatibleEncodingNode__field1_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field2_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field3_;
            private final InlineSupport.ReferenceField<Object> negotiateCompatibleEncodingNode__field4_;
            private final InlinedBranchProfile errorProfile_;
            private final EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.CheckStringEncodingNode.class));
                this.state_0_ = target.getState(0, 6);
                this.negotiateCompatibleEncodingNode__field1_ = target.getReference(1, Node.class);
                this.negotiateCompatibleEncodingNode__field2_ = target.getReference(2, Object.class);
                this.negotiateCompatibleEncodingNode__field3_ = target.getReference(3, Object.class);
                this.negotiateCompatibleEncodingNode__field4_ = target.getReference(4, Object.class);
                this.errorProfile_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 1)}));
                this.negotiateCompatibleEncodingNode_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(1, 5), this.negotiateCompatibleEncodingNode__field1_, this.negotiateCompatibleEncodingNode__field2_, this.negotiateCompatibleEncodingNode__field3_, this.negotiateCompatibleEncodingNode__field4_}));
            }

            @Override
            public RubyEncoding executeCheckEncoding(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.negotiateCompatibleEncodingNode__field1_, this.negotiateCompatibleEncodingNode__field2_, this.negotiateCompatibleEncodingNode__field3_, this.negotiateCompatibleEncodingNode__field4_}));
                return EncodingNodes.CheckStringEncodingNode.checkEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.errorProfile_, this.negotiateCompatibleEncodingNode_);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetActualEncodingNode.class)
    public static final class GetActualEncodingNodeGen {
        @NeverDefault
        public static EncodingNodes.GetActualEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.GetActualEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.GetActualEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<TruffleString.ReadByteNode> getActualEncodingDummy_readByteNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.GetActualEncodingNode.class));
                this.state_0_ = target.getState(0, 2);
                this.getActualEncodingDummy_readByteNode_ = target.getReference(1, TruffleString.ReadByteNode.class);
            }

            @Override
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    TruffleString.ReadByteNode readByteNode__;
                    if ((state_0 & 1) != 0 && !arg2Value.isDummy) {
                        return EncodingNodes.GetActualEncodingNode.getActualEncoding(arg1Value, arg2Value);
                    }
                    if ((state_0 & 2) != 0 && (readByteNode__ = (TruffleString.ReadByteNode)this.getActualEncodingDummy_readByteNode_.get(arg0Value)) != null && arg2Value.isDummy) {
                        return EncodingNodes.GetActualEncodingNode.getActualEncodingDummy(arg1Value, arg2Value, readByteNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (!arg2Value.isDummy) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return EncodingNodes.GetActualEncodingNode.getActualEncoding(arg1Value, arg2Value);
                }
                if (arg2Value.isDummy) {
                    TruffleString.ReadByteNode readByteNode__ = (TruffleString.ReadByteNode)arg0Value.insert((Node)TruffleString.ReadByteNode.create());
                    Objects.requireNonNull(readByteNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getActualEncodingDummy_readByteNode_.set(arg0Value, (Object)readByteNode__);
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return EncodingNodes.GetActualEncodingNode.getActualEncodingDummy(arg1Value, arg2Value, readByteNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
    public static final class NegotiateCompatibleEncodingNodeGen {
        private static final InlineSupport.StateField NEGOTIATE_STRING_STRING_ENCODING__NEGOTIATE_COMPATIBLE_ENCODING_NODE_NEGOTIATE_STRING_STRING_ENCODING_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)NegotiateStringStringEncodingData.lookup_(), (String)"negotiateStringStringEncoding_state_0_");

        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=8, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.NegotiateCompatibleEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<RubyStringLibrary> libFirst;
            private final InlineSupport.ReferenceField<RubyStringLibrary> libSecond;
            private final InlineSupport.ReferenceField<TruffleString.GetByteCodeRangeNode> codeRangeNode;
            private final InlineSupport.ReferenceField<NegotiateSameEncodingCachedData> negotiateSameEncodingCached_cache;
            private final InlineSupport.ReferenceField<NegotiateStringStringEncodingData> negotiateStringStringEncoding_cache;
            private final InlineSupport.ReferenceField<NegotiateStringObjectCachedData> negotiateStringObjectCached_cache;
            private final InlineSupport.ReferenceField<NegotiateObjectObjectCachedData> negotiateObjectObjectCached_cache;
            private final EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateStringStringEncoding_negotiateNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.NegotiateCompatibleEncodingNode.class));
                this.state_0_ = target.getState(0, 8);
                this.libFirst = target.getReference(1, RubyStringLibrary.class);
                this.libSecond = target.getReference(2, RubyStringLibrary.class);
                this.codeRangeNode = target.getReference(3, TruffleString.GetByteCodeRangeNode.class);
                this.negotiateSameEncodingCached_cache = target.getReference(4, NegotiateSameEncodingCachedData.class);
                this.negotiateStringStringEncoding_cache = target.getReference(5, NegotiateStringStringEncodingData.class);
                this.negotiateStringObjectCached_cache = target.getReference(6, NegotiateStringObjectCachedData.class);
                this.negotiateObjectObjectCached_cache = target.getReference(7, NegotiateObjectObjectCachedData.class);
                this.negotiateStringStringEncoding_negotiateNode_ = NegotiateCompatibleStringEncodingNodeGen.inline(InlineSupport.InlineTarget.create(EncodingNodes.NegotiateCompatibleStringEncodingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NEGOTIATE_STRING_STRING_ENCODING__NEGOTIATE_COMPATIBLE_ENCODING_NODE_NEGOTIATE_STRING_STRING_ENCODING_STATE_0_UPDATER.subUpdater(0, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NegotiateStringStringEncodingData.lookup_(), (String)"negotiateStringStringEncoding_negotiateNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NegotiateStringStringEncodingData.lookup_(), (String)"negotiateStringStringEncoding_negotiateNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NegotiateStringStringEncodingData.lookup_(), (String)"negotiateStringStringEncoding_negotiateNode__field3_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NegotiateStringStringEncodingData.lookup_(), (String)"negotiateStringStringEncoding_negotiateNode__field4_", Object.class)}));
            }

            @Override
            @ExplodeLoop
            public RubyEncoding execute(Node arg0Value, Object arg1Value, RubyEncoding arg2Value, Object arg3Value, RubyEncoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2;
                    RubyStringLibrary libSecond_1;
                    RubyStringLibrary libFirst_2;
                    TruffleString.GetByteCodeRangeNode codeRangeNode_1;
                    RubyStringLibrary libSecond_;
                    RubyStringLibrary libFirst_;
                    NegotiateStringStringEncodingData s2_;
                    if ((state_0 & 1) != 0) {
                        NegotiateSameEncodingCachedData s0_ = (NegotiateSameEncodingCachedData)this.negotiateSameEncodingCached_cache.get(arg0Value);
                        while (s0_ != null) {
                            if (arg2Value == s0_.cachedEncoding_ && arg4Value == s0_.cachedEncoding_) {
                                assert (DSLSupport.assertIdempotence((s0_.cachedEncoding_ != null ? 1 : 0) != 0));
                                return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateSameEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedEncoding_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && arg2Value == arg4Value && arg2Value != null) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateSameEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                    if ((state_0 & 4) != 0 && (s2_ = (NegotiateStringStringEncodingData)((Object)this.negotiateStringStringEncoding_cache.get(arg0Value))) != null && (libFirst_ = (RubyStringLibrary)this.libFirst.get(arg0Value)) != null && (libSecond_ = (RubyStringLibrary)this.libSecond.get(arg0Value)) != null && libFirst_.isRubyString(arg1Value) && libSecond_.isRubyString(arg3Value)) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringStringEncoding(s2_, arg1Value, arg2Value, arg3Value, arg4Value, libFirst_, libSecond_, this.negotiateStringStringEncoding_negotiateNode_);
                    }
                    if ((state_0 & 8) != 0) {
                        NegotiateStringObjectCachedData s3_ = (NegotiateStringObjectCachedData)this.negotiateStringObjectCached_cache.get(arg0Value);
                        while (s3_ != null) {
                            TruffleString.CodeRange codeRange__;
                            TruffleString.GetByteCodeRangeNode codeRangeNode_;
                            RubyStringLibrary libFirst_1 = (RubyStringLibrary)this.libFirst.get(arg0Value);
                            if (libFirst_1 != null && (codeRangeNode_ = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null && libFirst_1.isRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value) && (codeRange__ = EncodingNodes.NegotiateCompatibleEncodingNode.getCodeRange(codeRangeNode_, arg1Value, libFirst_1)) == EncodingNodesFactory.decodeCodeRange((s3_.negotiateStringObjectCached_state_0_ >>> 0) - 2) && arg2Value == s3_.firstEncodingCached_ && arg4Value == s3_.secondEncodingCached_) {
                                assert (DSLSupport.assertIdempotence((s3_.firstEncodingCached_ != s3_.secondEncodingCached_ ? 1 : 0) != 0));
                                return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringObjectCached(arg1Value, arg2Value, arg3Value, arg4Value, libFirst_1, s3_.firstEncodingCached_, s3_.secondEncodingCached_, codeRangeNode_, codeRange__, EncodingNodesFactory.decodeCodeRange((s3_.negotiateStringObjectCached_state_0_ >>> 0) - 2), s3_.negotiatedEncoding_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (codeRangeNode_1 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null && (libFirst_2 = (RubyStringLibrary)this.libFirst.get(arg0Value)) != null && libFirst_2.isRubyString(arg1Value) && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg3Value)) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringObjectUncached(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_1, libFirst_2);
                    }
                    if ((state_0 & 0x20) != 0 && (libSecond_1 = (RubyStringLibrary)this.libSecond.get(arg0Value)) != null && (codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null && libSecond_1.isRubyString(arg3Value) && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value)) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectString(arg1Value, arg2Value, arg3Value, arg4Value, libSecond_1, codeRangeNode_2);
                    }
                    if ((state_0 & 0x40) != 0 && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value) && arg2Value != null && arg4Value != null) {
                        NegotiateObjectObjectCachedData s6_ = (NegotiateObjectObjectCachedData)this.negotiateObjectObjectCached_cache.get(arg0Value);
                        while (s6_ != null) {
                            if (arg2Value == s6_.firstEncodingCached_ && arg4Value == s6_.secondEncodingCached_) {
                                return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectObjectCached(arg1Value, arg2Value, arg3Value, arg4Value, s6_.firstEncodingCached_, s6_.secondEncodingCached_, s6_.negotiatedEncoding_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state_0 & 0x80) != 0 && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value)) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectObjectUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, Object arg1Value, RubyEncoding arg2Value, Object arg3Value, RubyEncoding arg4Value) {
                RubyStringLibrary libSecond_1;
                RubyStringLibrary libFirst_2;
                RubyStringLibrary libFirst_2_shared;
                RubyStringLibrary libFirst_;
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 2) == 0) {
                    NegotiateSameEncodingCachedData s0_;
                    block54: {
                        NegotiateSameEncodingCachedData s0_original;
                        do {
                            RubyEncoding cachedEncoding__;
                            int count0_ = 0;
                            s0_original = s0_ = (NegotiateSameEncodingCachedData)this.negotiateSameEncodingCached_cache.getVolatile(arg0Value);
                            while (s0_ != null) {
                                if (arg2Value == s0_.cachedEncoding_ && arg4Value == s0_.cachedEncoding_) {
                                    assert (DSLSupport.assertIdempotence((s0_.cachedEncoding_ != null ? 1 : 0) != 0));
                                    break;
                                }
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || arg4Value != (cachedEncoding__ = arg2Value) || cachedEncoding__ == null || count0_ >= this.getCacheLimit()) break block54;
                            s0_ = new NegotiateSameEncodingCachedData(s0_original);
                            s0_.cachedEncoding_ = cachedEncoding__;
                        } while (!this.negotiateSameEncodingCached_cache.compareAndSet(arg0Value, (Object)s0_original, (Object)s0_));
                        this.state_0_.set(arg0Value, state_0 |= 1);
                    }
                    if (s0_ != null) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateSameEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedEncoding_);
                    }
                }
                if (arg2Value == arg4Value && arg2Value != null) {
                    this.negotiateSameEncodingCached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateSameEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                RubyStringLibrary libFirst__shared = (RubyStringLibrary)this.libFirst.get(arg0Value);
                if (libFirst__shared != null) {
                    libFirst_ = libFirst__shared;
                } else {
                    libFirst_ = RubyStringLibrary.create();
                    if (libFirst_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (libFirst_.isRubyString(arg1Value)) {
                    RubyStringLibrary libSecond_;
                    RubyStringLibrary libSecond__shared = (RubyStringLibrary)this.libSecond.get(arg0Value);
                    if (libSecond__shared != null) {
                        libSecond_ = libSecond__shared;
                    } else {
                        libSecond_ = RubyStringLibrary.create();
                        if (libSecond_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (libSecond_.isRubyString(arg3Value)) {
                        NegotiateStringStringEncodingData s2_ = (NegotiateStringStringEncodingData)arg0Value.insert((Node)new NegotiateStringStringEncodingData());
                        if (this.libFirst.get(arg0Value) == null) {
                            this.libFirst.set(arg0Value, (Object)libFirst_);
                        }
                        if (this.libSecond.get(arg0Value) == null) {
                            this.libSecond.set(arg0Value, (Object)libSecond_);
                        }
                        VarHandle.storeStoreFence();
                        this.negotiateStringStringEncoding_cache.set(arg0Value, (Object)s2_);
                        this.state_0_.set(arg0Value, state_0 |= 4);
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringStringEncoding(s2_, arg1Value, arg2Value, arg3Value, arg4Value, libFirst_, libSecond_, this.negotiateStringStringEncoding_negotiateNode_);
                    }
                }
                TruffleString.CodeRange codeRange__ = null;
                if ((state_0 & 0x10) == 0) {
                    NegotiateStringObjectCachedData s3_;
                    block55: {
                        NegotiateStringObjectCachedData s3_original;
                        do {
                            TruffleString.GetByteCodeRangeNode codeRangeNode_;
                            RubyEncoding secondEncodingCached__;
                            RubyEncoding firstEncodingCached__;
                            RubyStringLibrary libFirst_1;
                            int count3_ = 0;
                            s3_original = s3_ = (NegotiateStringObjectCachedData)this.negotiateStringObjectCached_cache.getVolatile(arg0Value);
                            while (s3_ != null) {
                                TruffleString.GetByteCodeRangeNode codeRangeNode_2;
                                libFirst_1 = (RubyStringLibrary)this.libFirst.get(arg0Value);
                                if (libFirst_1 != null && (codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null && libFirst_1.isRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value) && (codeRange__ = EncodingNodes.NegotiateCompatibleEncodingNode.getCodeRange(codeRangeNode_2, arg1Value, libFirst_1)) == EncodingNodesFactory.decodeCodeRange((s3_.negotiateStringObjectCached_state_0_ >>> 0) - 2) && arg2Value == s3_.firstEncodingCached_ && arg4Value == s3_.secondEncodingCached_) {
                                    assert (DSLSupport.assertIdempotence((s3_.firstEncodingCached_ != s3_.secondEncodingCached_ ? 1 : 0) != 0));
                                    break;
                                }
                                ++count3_;
                                s3_ = s3_.next_;
                            }
                            if (s3_ != null) break block55;
                            RubyStringLibrary libFirst_1_shared = (RubyStringLibrary)this.libFirst.get(arg0Value);
                            if (libFirst_1_shared != null) {
                                libFirst_1 = libFirst_1_shared;
                            } else {
                                libFirst_1 = RubyStringLibrary.create();
                                if (libFirst_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (!libFirst_1.isRubyString(arg1Value) || !RubyGuards.isNotRubyString(arg3Value) || (firstEncodingCached__ = arg2Value) == (secondEncodingCached__ = arg4Value) || count3_ >= this.getCacheLimit()) break block55;
                            s3_ = new NegotiateStringObjectCachedData(s3_original);
                            if (this.libFirst.get(arg0Value) == null) {
                                this.libFirst.set(arg0Value, (Object)libFirst_1);
                            }
                            s3_.firstEncodingCached_ = firstEncodingCached__;
                            s3_.secondEncodingCached_ = secondEncodingCached__;
                            TruffleString.GetByteCodeRangeNode codeRangeNode__shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                            if (codeRangeNode__shared != null) {
                                codeRangeNode_ = codeRangeNode__shared;
                            } else {
                                codeRangeNode_ = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                                if (codeRangeNode_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.codeRangeNode.get(arg0Value) == null) {
                                this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_);
                            }
                            codeRange__ = EncodingNodes.NegotiateCompatibleEncodingNode.getCodeRange(codeRangeNode_, arg1Value, libFirst_1);
                            s3_.negotiateStringObjectCached_state_0_ |= EncodingNodesFactory.encodeCodeRange(codeRange__) + 2 << 0;
                            s3_.negotiatedEncoding_ = EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringObjectUncached(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_, libFirst_1);
                        } while (!this.negotiateStringObjectCached_cache.compareAndSet(arg0Value, (Object)s3_original, (Object)s3_));
                        this.state_0_.set(arg0Value, state_0 |= 8);
                    }
                    if (s3_ != null) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringObjectCached(arg1Value, arg2Value, arg3Value, arg4Value, (RubyStringLibrary)this.libFirst.get(arg0Value), s3_.firstEncodingCached_, s3_.secondEncodingCached_, (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value), codeRange__, EncodingNodesFactory.decodeCodeRange((s3_.negotiateStringObjectCached_state_0_ >>> 0) - 2), s3_.negotiatedEncoding_);
                    }
                }
                if ((libFirst_2_shared = (RubyStringLibrary)this.libFirst.get(arg0Value)) != null) {
                    libFirst_2 = libFirst_2_shared;
                } else {
                    libFirst_2 = RubyStringLibrary.create();
                    if (libFirst_2 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (libFirst_2.isRubyString(arg1Value) && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg3Value)) {
                    TruffleString.GetByteCodeRangeNode codeRangeNode_1;
                    TruffleString.GetByteCodeRangeNode codeRangeNode_1_shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                    if (codeRangeNode_1_shared != null) {
                        codeRangeNode_1 = codeRangeNode_1_shared;
                    } else {
                        codeRangeNode_1 = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                        if (codeRangeNode_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.codeRangeNode.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_1);
                    }
                    if (this.libFirst.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.libFirst.set(arg0Value, (Object)libFirst_2);
                    }
                    this.negotiateStringObjectCached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFF7;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateStringObjectUncached(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_1, libFirst_2);
                }
                RubyStringLibrary libSecond_1_shared = (RubyStringLibrary)this.libSecond.get(arg0Value);
                if (libSecond_1_shared != null) {
                    libSecond_1 = libSecond_1_shared;
                } else {
                    libSecond_1 = RubyStringLibrary.create();
                    if (libSecond_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (libSecond_1.isRubyString(arg3Value) && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value)) {
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2;
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2_shared;
                    if (this.libSecond.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.libSecond.set(arg0Value, (Object)libSecond_1);
                    }
                    if ((codeRangeNode_2_shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null) {
                        codeRangeNode_2 = codeRangeNode_2_shared;
                    } else {
                        codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                        if (codeRangeNode_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.codeRangeNode.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_2);
                    }
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectString(arg1Value, arg2Value, arg3Value, arg4Value, libSecond_1, codeRangeNode_2);
                }
                if ((state_0 & 0x80) == 0 && arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value) && arg2Value != null && arg4Value != null) {
                    NegotiateObjectObjectCachedData s6_;
                    block56: {
                        NegotiateObjectObjectCachedData s6_original;
                        do {
                            int count6_ = 0;
                            s6_original = s6_ = (NegotiateObjectObjectCachedData)this.negotiateObjectObjectCached_cache.getVolatile(arg0Value);
                            while (s6_ != null && (arg2Value != s6_.firstEncodingCached_ || arg4Value != s6_.secondEncodingCached_)) {
                                ++count6_;
                                s6_ = s6_.next_;
                            }
                            if (s6_ != null || count6_ >= this.getCacheLimit()) break block56;
                            s6_ = new NegotiateObjectObjectCachedData(s6_original);
                            s6_.firstEncodingCached_ = arg2Value;
                            s6_.secondEncodingCached_ = arg4Value;
                            s6_.negotiatedEncoding_ = EncodingNodes.NegotiateCompatibleEncodingNode.areCompatible(s6_.firstEncodingCached_, s6_.secondEncodingCached_);
                        } while (!this.negotiateObjectObjectCached_cache.compareAndSet(arg0Value, (Object)s6_original, (Object)s6_));
                        this.state_0_.set(arg0Value, state_0 |= 0x40);
                    }
                    if (s6_ != null) {
                        return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectObjectCached(arg1Value, arg2Value, arg3Value, arg4Value, s6_.firstEncodingCached_, s6_.secondEncodingCached_, s6_.negotiatedEncoding_);
                    }
                }
                if (arg2Value != arg4Value && RubyGuards.isNotRubyString(arg1Value) && RubyGuards.isNotRubyString(arg3Value)) {
                    this.negotiateObjectObjectCached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFBF;
                    this.state_0_.set(arg0Value, state_0 |= 0x80);
                    return EncodingNodes.NegotiateCompatibleEncodingNode.negotiateObjectObjectUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class NegotiateStringStringEncodingData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int negotiateStringStringEncoding_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node negotiateStringStringEncoding_negotiateNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateStringStringEncoding_negotiateNode__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateStringStringEncoding_negotiateNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object negotiateStringStringEncoding_negotiateNode__field4_;

            NegotiateStringStringEncodingData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class NegotiateObjectObjectCachedData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateObjectObjectCachedData next_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding firstEncodingCached_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding secondEncodingCached_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding negotiatedEncoding_;

            NegotiateObjectObjectCachedData(NegotiateObjectObjectCachedData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class NegotiateStringObjectCachedData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateStringObjectCachedData next_;
            @CompilerDirectives.CompilationFinal
            private int negotiateStringObjectCached_state_0_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding firstEncodingCached_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding secondEncodingCached_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding negotiatedEncoding_;

            NegotiateStringObjectCachedData(NegotiateStringObjectCachedData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        @DenyReplace
        private static final class NegotiateSameEncodingCachedData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateSameEncodingCachedData next_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding cachedEncoding_;

            NegotiateSameEncodingCachedData(NegotiateSameEncodingCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
    public static final class NegotiateCompatibleStringEncodingNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException5(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
        }

        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleStringEncodingNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static EncodingNodes.NegotiateCompatibleStringEncodingNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class Uncached
        extends EncodingNodes.NegotiateCompatibleStringEncodingNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                if (arg2Value == arg4Value) {
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateSameEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if (arg2Value != arg4Value && this.isStandardEncoding(arg2Value) && TruffleString.GetByteCodeRangeNode.getUncached().execute(arg3Value, arg4Value.tencoding) == TruffleString.CodeRange.ASCII) {
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateStandardEncodingAndCr7Bit(arg1Value, arg2Value, arg3Value, arg4Value, TruffleString.GetByteCodeRangeNode.getUncached(), arg2Value);
                }
                if (arg2Value != arg4Value) {
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value, TruffleString.GetByteCodeRangeNode.getUncached());
                }
                throw NegotiateCompatibleStringEncodingNodeGen.newUnsupportedSpecializationException5(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class Inlined
        extends EncodingNodes.NegotiateCompatibleStringEncodingNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<TruffleString.GetByteCodeRangeNode> codeRangeNode;
            private final InlineSupport.ReferenceField<NegotiateSameEncodingCachedData> negotiateSameEncodingCached_cache;
            private final InlineSupport.ReferenceField<NegotiateStandardEncodingAndCr7BitData> negotiateStandardEncodingAndCr7Bit_cache;
            private final InlineSupport.ReferenceField<NegotiateEncodingCachedData> negotiateEncodingCached_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(EncodingNodes.NegotiateCompatibleStringEncodingNode.class));
                this.state_0_ = target.getState(0, 5);
                this.codeRangeNode = target.getReference(1, TruffleString.GetByteCodeRangeNode.class);
                this.negotiateSameEncodingCached_cache = target.getReference(2, NegotiateSameEncodingCachedData.class);
                this.negotiateStandardEncodingAndCr7Bit_cache = target.getReference(3, NegotiateStandardEncodingAndCr7BitData.class);
                this.negotiateEncodingCached_cache = target.getReference(4, NegotiateEncodingCachedData.class);
            }

            @Override
            @ExplodeLoop
            public RubyEncoding execute(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2;
                    if ((state_0 & 1) != 0) {
                        NegotiateSameEncodingCachedData s0_ = (NegotiateSameEncodingCachedData)this.negotiateSameEncodingCached_cache.get(arg0Value);
                        while (s0_ != null) {
                            if (arg2Value == s0_.cachedEncoding_ && arg4Value == s0_.cachedEncoding_) {
                                return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateSameEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedEncoding_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && arg2Value == arg4Value) {
                        return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateSameEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value != arg4Value) {
                        NegotiateStandardEncodingAndCr7BitData s2_ = (NegotiateStandardEncodingAndCr7BitData)this.negotiateStandardEncodingAndCr7Bit_cache.get(arg0Value);
                        while (s2_ != null) {
                            TruffleString.GetByteCodeRangeNode codeRangeNode_ = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                            if (codeRangeNode_ != null && arg2Value == s2_.cachedEncoding_) {
                                assert (DSLSupport.assertIdempotence((boolean)this.isStandardEncoding(s2_.cachedEncoding_)));
                                if (codeRangeNode_.execute(arg3Value, arg4Value.tencoding) == TruffleString.CodeRange.ASCII) {
                                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateStandardEncodingAndCr7Bit(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_, s2_.cachedEncoding_);
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0 && arg2Value != arg4Value) {
                        NegotiateEncodingCachedData s3_ = (NegotiateEncodingCachedData)this.negotiateEncodingCached_cache.get(arg0Value);
                        while (s3_ != null) {
                            TruffleString.CodeRange secondCodeRange__;
                            TruffleString.CodeRange firstCodeRange__;
                            TruffleString.GetByteCodeRangeNode codeRangeNode_1 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                            if (codeRangeNode_1 != null && arg1Value.isEmpty() == s3_.isFirstEmpty_ && arg3Value.isEmpty() == s3_.isSecondEmpty_ && s3_.cachedFirstEncoding_ == arg2Value && s3_.cachedSecondEncoding_ == arg4Value && (firstCodeRange__ = codeRangeNode_1.execute(arg1Value, arg2Value.tencoding)) == EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 7) >>> 0) - 2) && (secondCodeRange__ = codeRangeNode_1.execute(arg3Value, arg4Value.tencoding)) == EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 0x38) >>> 3) - 2)) {
                                return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s3_.isFirstEmpty_, s3_.isSecondEmpty_, codeRangeNode_1, firstCodeRange__, secondCodeRange__, EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 7) >>> 0) - 2), EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 0x38) >>> 3) - 2), s3_.cachedFirstEncoding_, s3_.cachedSecondEncoding_, s3_.negotiatedEncoding_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) != null && arg2Value != arg4Value) {
                        return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_2);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private RubyEncoding executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, RubyEncoding arg2Value, AbstractTruffleString arg3Value, RubyEncoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 2) == 0) {
                    NegotiateSameEncodingCachedData s0_;
                    block28: {
                        NegotiateSameEncodingCachedData s0_original;
                        do {
                            RubyEncoding cachedEncoding__;
                            int count0_ = 0;
                            s0_original = s0_ = (NegotiateSameEncodingCachedData)this.negotiateSameEncodingCached_cache.getVolatile(arg0Value);
                            while (s0_ != null && (arg2Value != s0_.cachedEncoding_ || arg4Value != s0_.cachedEncoding_)) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || arg4Value != (cachedEncoding__ = arg2Value) || count0_ >= this.getCacheLimit()) break block28;
                            s0_ = new NegotiateSameEncodingCachedData(s0_original);
                            s0_.cachedEncoding_ = cachedEncoding__;
                        } while (!this.negotiateSameEncodingCached_cache.compareAndSet(arg0Value, (Object)s0_original, (Object)s0_));
                        this.state_0_.set(arg0Value, state_0 |= 1);
                    }
                    if (s0_ != null) {
                        return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateSameEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedEncoding_);
                    }
                }
                if (arg2Value == arg4Value) {
                    this.negotiateSameEncodingCached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateSameEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if (arg2Value != arg4Value) {
                    NegotiateStandardEncodingAndCr7BitData s2_;
                    block29: {
                        NegotiateStandardEncodingAndCr7BitData s2_original;
                        do {
                            TruffleString.GetByteCodeRangeNode codeRangeNode_;
                            RubyEncoding cachedEncoding__1;
                            int count2_ = 0;
                            s2_original = s2_ = (NegotiateStandardEncodingAndCr7BitData)this.negotiateStandardEncodingAndCr7Bit_cache.getVolatile(arg0Value);
                            while (s2_ != null) {
                                TruffleString.GetByteCodeRangeNode codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                                if (codeRangeNode_2 != null && arg2Value == s2_.cachedEncoding_) {
                                    assert (DSLSupport.assertIdempotence((boolean)this.isStandardEncoding(s2_.cachedEncoding_)));
                                    if (codeRangeNode_2.execute(arg3Value, arg4Value.tencoding) == TruffleString.CodeRange.ASCII) break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !this.isStandardEncoding(cachedEncoding__1 = arg2Value)) break block29;
                            TruffleString.GetByteCodeRangeNode codeRangeNode__shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                            if (codeRangeNode__shared != null) {
                                codeRangeNode_ = codeRangeNode__shared;
                            } else {
                                codeRangeNode_ = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                                if (codeRangeNode_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (codeRangeNode_.execute(arg3Value, arg4Value.tencoding) != TruffleString.CodeRange.ASCII || count2_ >= 3) break block29;
                            s2_ = new NegotiateStandardEncodingAndCr7BitData(s2_original);
                            if (this.codeRangeNode.get(arg0Value) == null) {
                                this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_);
                            }
                            s2_.cachedEncoding_ = cachedEncoding__1;
                        } while (!this.negotiateStandardEncodingAndCr7Bit_cache.compareAndSet(arg0Value, (Object)s2_original, (Object)s2_));
                        this.state_0_.set(arg0Value, state_0 |= 4);
                    }
                    if (s2_ != null) {
                        return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateStandardEncodingAndCr7Bit(arg1Value, arg2Value, arg3Value, arg4Value, (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value), s2_.cachedEncoding_);
                    }
                }
                TruffleString.CodeRange secondCodeRange__ = null;
                TruffleString.CodeRange firstCodeRange__ = null;
                if ((state_0 & 0x10) == 0 && arg2Value != arg4Value) {
                    NegotiateEncodingCachedData s3_;
                    block30: {
                        NegotiateEncodingCachedData s3_original;
                        do {
                            TruffleString.GetByteCodeRangeNode codeRangeNode_1;
                            TruffleString.GetByteCodeRangeNode codeRangeNode_12;
                            int count3_ = 0;
                            s3_original = s3_ = (NegotiateEncodingCachedData)this.negotiateEncodingCached_cache.getVolatile(arg0Value);
                            while (s3_ != null && ((codeRangeNode_12 = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value)) == null || arg1Value.isEmpty() != s3_.isFirstEmpty_ || arg3Value.isEmpty() != s3_.isSecondEmpty_ || s3_.cachedFirstEncoding_ != arg2Value || s3_.cachedSecondEncoding_ != arg4Value || (firstCodeRange__ = codeRangeNode_12.execute(arg1Value, arg2Value.tencoding)) != EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 7) >>> 0) - 2) || (secondCodeRange__ = codeRangeNode_12.execute(arg3Value, arg4Value.tencoding)) != EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 0x38) >>> 3) - 2))) {
                                ++count3_;
                                s3_ = s3_.next_;
                            }
                            if (s3_ != null) break block30;
                            boolean isFirstEmpty__ = arg1Value.isEmpty();
                            if (arg1Value.isEmpty() != isFirstEmpty__) break block30;
                            boolean isSecondEmpty__ = arg3Value.isEmpty();
                            if (arg3Value.isEmpty() != isSecondEmpty__ || count3_ >= this.getCacheLimit()) break block30;
                            s3_ = new NegotiateEncodingCachedData(s3_original);
                            s3_.isFirstEmpty_ = isFirstEmpty__;
                            s3_.isSecondEmpty_ = isSecondEmpty__;
                            TruffleString.GetByteCodeRangeNode codeRangeNode_1_shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                            if (codeRangeNode_1_shared != null) {
                                codeRangeNode_1 = codeRangeNode_1_shared;
                            } else {
                                codeRangeNode_1 = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                                if (codeRangeNode_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.codeRangeNode.get(arg0Value) == null) {
                                this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_1);
                            }
                            firstCodeRange__ = codeRangeNode_1.execute(arg1Value, arg2Value.tencoding);
                            secondCodeRange__ = codeRangeNode_1.execute(arg3Value, arg4Value.tencoding);
                            s3_.negotiateEncodingCached_state_0_ |= EncodingNodesFactory.encodeCodeRange(firstCodeRange__) + 2 << 0;
                            s3_.negotiateEncodingCached_state_0_ |= EncodingNodesFactory.encodeCodeRange(secondCodeRange__) + 2 << 3;
                            s3_.cachedFirstEncoding_ = arg2Value;
                            s3_.cachedSecondEncoding_ = arg4Value;
                            s3_.negotiatedEncoding_ = EncodingNodes.NegotiateCompatibleStringEncodingNode.compatibleEncodingForStrings(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_1);
                        } while (!this.negotiateEncodingCached_cache.compareAndSet(arg0Value, (Object)s3_original, (Object)s3_));
                        this.state_0_.set(arg0Value, state_0 |= 8);
                    }
                    if (s3_ != null) {
                        return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncodingCached(arg1Value, arg2Value, arg3Value, arg4Value, s3_.isFirstEmpty_, s3_.isSecondEmpty_, (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value), firstCodeRange__, secondCodeRange__, EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 7) >>> 0) - 2), EncodingNodesFactory.decodeCodeRange(((s3_.negotiateEncodingCached_state_0_ & 0x38) >>> 3) - 2), s3_.cachedFirstEncoding_, s3_.cachedSecondEncoding_, s3_.negotiatedEncoding_);
                    }
                }
                if (arg2Value != arg4Value) {
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2;
                    TruffleString.GetByteCodeRangeNode codeRangeNode_2_shared = (TruffleString.GetByteCodeRangeNode)this.codeRangeNode.get(arg0Value);
                    if (codeRangeNode_2_shared != null) {
                        codeRangeNode_2 = codeRangeNode_2_shared;
                    } else {
                        codeRangeNode_2 = (TruffleString.GetByteCodeRangeNode)arg0Value.insert((Node)TruffleString.GetByteCodeRangeNode.create());
                        if (codeRangeNode_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.codeRangeNode.get(arg0Value) == null) {
                        VarHandle.storeStoreFence();
                        this.codeRangeNode.set(arg0Value, (Object)codeRangeNode_2);
                    }
                    this.negotiateEncodingCached_cache.set(arg0Value, null);
                    state_0 &= 0xFFFFFFF7;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return EncodingNodes.NegotiateCompatibleStringEncodingNode.negotiateEncodingUncached(arg1Value, arg2Value, arg3Value, arg4Value, codeRangeNode_2);
                }
                throw NegotiateCompatibleStringEncodingNodeGen.newUnsupportedSpecializationException5(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class NegotiateEncodingCachedData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateEncodingCachedData next_;
            @CompilerDirectives.CompilationFinal
            private int negotiateEncodingCached_state_0_;
            @CompilerDirectives.CompilationFinal
            boolean isFirstEmpty_;
            @CompilerDirectives.CompilationFinal
            boolean isSecondEmpty_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding cachedFirstEncoding_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding cachedSecondEncoding_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding negotiatedEncoding_;

            NegotiateEncodingCachedData(NegotiateEncodingCachedData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class NegotiateStandardEncodingAndCr7BitData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateStandardEncodingAndCr7BitData next_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding cachedEncoding_;

            NegotiateStandardEncodingAndCr7BitData(NegotiateStandardEncodingAndCr7BitData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleStringEncodingNode.class)
        @DenyReplace
        private static final class NegotiateSameEncodingCachedData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final NegotiateSameEncodingCachedData next_;
            @CompilerDirectives.CompilationFinal
            RubyEncoding cachedEncoding_;

            NegotiateSameEncodingCachedData(NegotiateSameEncodingCachedData next_) {
                this.next_ = next_;
            }
        }
    }
}

