/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.EncodingDB;
import org.graalvm.shadowed.org.jcodings.util.CaseInsensitiveBytesHash;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.EncodingUtils;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.platform.NativeConfiguration;
import org.truffleruby.platform.TruffleNFIPlatform;

public final class EncodingManager {
    private RubyEncoding[] ENCODING_LIST_BY_ENCODING_INDEX = new RubyEncoding[Encodings.INITIAL_NUMBER_OF_ENCODINGS];
    private final Map<String, RubyEncoding> LOOKUP = new ConcurrentHashMap<String, RubyEncoding>();
    private final RubyContext context;
    private final RubyLanguage language;
    @CompilerDirectives.CompilationFinal
    private RubyEncoding localeEncoding;
    private RubyEncoding defaultExternalEncoding;
    private RubyEncoding defaultInternalEncoding;

    public EncodingManager(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public void defineEncodings() {
        RubyClass encodingClass = this.context.getCoreLibrary().encodingClass;
        this.initializeEncodings(encodingClass);
        this.initializeEncodingAliases(encodingClass);
    }

    private void initializeEncodings(RubyClass encodingClass) {
        for (RubyEncoding encoding : Encodings.BUILT_IN_ENCODINGS) {
            this.defineBuiltInEncoding(encoding);
            byte[] name = encoding.jcoding.getName();
            for (String constName : EncodingUtils.encodingNames(name, 0, name.length)) {
                encodingClass.fields.setConstant(this.context, null, constName, encoding);
            }
        }
    }

    private void initializeEncodingAliases(RubyClass encodingClass) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator iterator = EncodingDB.getAliases().entryIterator();
        while (iterator.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry entry = iterator.next();
            EncodingDB.Entry encodingEntry = (EncodingDB.Entry)entry.value;
            Encoding encoding = encodingEntry.getEncoding();
            RubyEncoding rubyEncoding = this.defineAlias(encoding, new String(entry.bytes, entry.p, entry.end - entry.p, StandardCharsets.US_ASCII));
            for (String constName : EncodingUtils.encodingNames(entry.bytes, entry.p, entry.end)) {
                encodingClass.fields.setConstant(this.context, null, constName, rubyEncoding);
            }
        }
    }

    public void initializeDefaultEncodings(TruffleNFIPlatform nfi, NativeConfiguration nativeConfiguration) {
        this.initializeLocaleEncoding(nfi, nativeConfiguration);
        String externalEncodingName = this.context.getOptions().EXTERNAL_ENCODING;
        if (!externalEncodingName.isEmpty()) {
            RubyEncoding loadedEncoding = this.getRubyEncoding(externalEncodingName);
            if (loadedEncoding == null) {
                throw new RuntimeException("unknown encoding name - " + externalEncodingName);
            }
            this.setDefaultExternalEncoding(loadedEncoding);
        } else {
            this.setDefaultExternalEncoding(this.getLocaleEncoding());
        }
        String internalEncodingName = this.context.getOptions().INTERNAL_ENCODING;
        if (!internalEncodingName.isEmpty()) {
            RubyEncoding rubyEncoding = this.getRubyEncoding(internalEncodingName);
            if (rubyEncoding == null) {
                throw new RuntimeException("unknown encoding name - " + internalEncodingName);
            }
            this.setDefaultInternalEncoding(rubyEncoding);
        }
    }

    private void initializeLocaleEncoding(TruffleNFIPlatform nfi, NativeConfiguration nativeConfiguration) {
        String localeEncodingName;
        String detector;
        if (nfi != null) {
            long address;
            int codeset = (Integer)nativeConfiguration.get("platform.langinfo.CODESET");
            Object nl_langinfo = nfi.getFunction(this.context, "nl_langinfo", "(sint32):string");
            try {
                address = nfi.asPointer(InteropLibrary.getUncached().execute(nl_langinfo, new Object[]{codeset}));
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            byte[] bytes = new Pointer(this.context, address).readZeroTerminatedByteArray(this.context, InteropLibrary.getUncached(), 0L);
            detector = "nl_langinfo(CODESET)";
            localeEncodingName = new String(bytes, StandardCharsets.US_ASCII);
        } else {
            detector = "Charset.defaultCharset()";
            localeEncodingName = Charset.defaultCharset().name();
        }
        RubyEncoding rubyEncoding = this.getRubyEncoding(localeEncodingName);
        if (rubyEncoding == null) {
            rubyEncoding = Encodings.US_ASCII;
        }
        if (this.context.getOptions().WARN_LOCALE && rubyEncoding == Encodings.US_ASCII) {
            String firstLine = "Encoding.find('locale') is US-ASCII (due to " + detector + " which returned " + localeEncodingName + "), this often indicates that the system locale is not set properly. ";
            if ("C".equals(System.getenv("LANG")) && "C".equals(System.getenv("LC_ALL"))) {
                RubyLanguage.LOGGER.config(firstLine + "Warning at level=CONFIG because LANG=C and LC_ALL=C are set. Set LANG=en_US.UTF-8 and see https://www.graalvm.org/dev/reference-manual/ruby/UTF8Locale/ for details.");
            } else {
                RubyLanguage.LOGGER.warning(firstLine + "Set LANG=en_US.UTF-8 and see https://www.graalvm.org/dev/reference-manual/ruby/UTF8Locale/ for details.");
            }
        }
        this.localeEncoding = rubyEncoding;
    }

    public synchronized Object[] getEncodingList() {
        return ArrayUtils.copyOf(this.ENCODING_LIST_BY_ENCODING_INDEX, this.ENCODING_LIST_BY_ENCODING_INDEX.length);
    }

    public int getNumberOfEncodings() {
        return this.ENCODING_LIST_BY_ENCODING_INDEX.length;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyEncoding getRubyEncoding(String name) {
        String normalizedName;
        switch (normalizedName = name.toLowerCase(Locale.ENGLISH)) {
            case "internal": {
                RubyEncoding encoding = this.getDefaultInternalEncoding();
                return encoding == null ? Encodings.BINARY : encoding;
            }
            case "external": 
            case "filesystem": {
                RubyEncoding encoding = this.getDefaultExternalEncoding();
                return encoding == null ? Encodings.BINARY : encoding;
            }
            case "locale": {
                RubyEncoding encoding = this.getLocaleEncoding();
                return encoding == null ? Encodings.BINARY : encoding;
            }
        }
        return this.LOOKUP.get(normalizedName);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    RubyEncoding getRubyEncoding(int encodingIndex) {
        return this.ENCODING_LIST_BY_ENCODING_INDEX[encodingIndex];
    }

    @CompilerDirectives.TruffleBoundary
    public void defineBuiltInEncoding(RubyEncoding rubyEncoding) {
        int encodingIndex = rubyEncoding.index;
        assert (this.ENCODING_LIST_BY_ENCODING_INDEX[encodingIndex] == null);
        this.ENCODING_LIST_BY_ENCODING_INDEX[encodingIndex] = rubyEncoding;
        this.addToLookup(rubyEncoding.toString(), rubyEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized RubyEncoding defineDynamicEncoding(Encoding encoding, byte[] name) {
        int encodingIndex = this.ENCODING_LIST_BY_ENCODING_INDEX.length;
        RubyEncoding rubyEncoding = Encodings.newRubyEncoding(this.language, encoding, encodingIndex, name);
        this.ENCODING_LIST_BY_ENCODING_INDEX = Arrays.copyOf(this.ENCODING_LIST_BY_ENCODING_INDEX, encodingIndex + 1);
        this.ENCODING_LIST_BY_ENCODING_INDEX[encodingIndex] = rubyEncoding;
        this.addToLookup(rubyEncoding.name.getJavaString(), rubyEncoding);
        return rubyEncoding;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyEncoding defineAlias(Encoding encoding, String name) {
        RubyEncoding rubyEncoding = Encodings.getBuiltInEncoding(encoding);
        this.addToLookup(name, rubyEncoding);
        return rubyEncoding;
    }

    @CompilerDirectives.TruffleBoundary
    private void addToLookup(String name, RubyEncoding rubyEncoding) {
        this.LOOKUP.put(name.toLowerCase(Locale.ENGLISH), rubyEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized RubyEncoding createDummyEncoding(String name) {
        if (this.getRubyEncoding(name) != null) {
            return null;
        }
        byte[] nameBytes = StringOperations.encodeAsciiBytes(name);
        return this.defineDynamicEncoding(Encodings.DUMMY_ENCODING_BASE, nameBytes);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized RubyEncoding replicateEncoding(RubyEncoding encoding, String name) {
        if (this.getRubyEncoding(name) != null) {
            return null;
        }
        byte[] nameBytes = StringOperations.encodeAsciiBytes(name);
        return this.defineDynamicEncoding(encoding.jcoding, nameBytes);
    }

    public RubyEncoding getLocaleEncoding() {
        return this.localeEncoding;
    }

    public void setDefaultExternalEncoding(RubyEncoding defaultExternalEncoding) {
        this.defaultExternalEncoding = defaultExternalEncoding;
    }

    public RubyEncoding getDefaultExternalEncoding() {
        return this.defaultExternalEncoding;
    }

    public void setDefaultInternalEncoding(RubyEncoding defaultInternalEncoding) {
        this.defaultInternalEncoding = defaultInternalEncoding;
    }

    public RubyEncoding getDefaultInternalEncoding() {
        return this.defaultInternalEncoding;
    }
}

