/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.cast.ToSymbolNodeGen;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
public abstract class ToSymbolNode
extends RubyBaseNode {
    public final RubySymbol executeCached(Object object) {
        return this.execute(this, object);
    }

    public static RubySymbol executeUncached(Object object) {
        return ToSymbolNodeGen.getUncached().execute(null, object);
    }

    public abstract RubySymbol execute(Node var1, Object var2);

    @Specialization
    static RubySymbol symbol(RubySymbol symbol) {
        return symbol;
    }

    @Specialization(guards={"str == cachedStr"}, limit="getCacheLimit()")
    static RubySymbol javaString(String str, @Cached(value="str") String cachedStr, @Cached(value="getSymbol(cachedStr)") RubySymbol rubySymbol) {
        return rubySymbol;
    }

    @Specialization(replaces={"javaString"})
    static RubySymbol javaStringUncached(Node node, String str) {
        return ToSymbolNode.getSymbol(node, str);
    }

    @Specialization(guards={"strings.isRubyString(str)", "equalNode.execute(node, strings, str, cachedTString, cachedEncoding)"}, limit="getCacheLimit()")
    static RubySymbol rubyString(Node node, Object str, @Cached @Cached.Shared RubyStringLibrary strings, @Cached(value="asTruffleStringUncached(str)") TruffleString cachedTString, @Cached(value="strings.getEncoding(str)") RubyEncoding cachedEncoding, @Cached StringHelperNodes.EqualSameEncodingNode equalNode, @Cached(value="getSymbol(node, cachedTString, cachedEncoding)") RubySymbol rubySymbol) {
        return rubySymbol;
    }

    @Specialization(guards={"strings.isRubyString(str)"}, replaces={"rubyString"})
    static RubySymbol rubyStringUncached(Node node, Object str, @Cached @Cached.Shared RubyStringLibrary strings) {
        return ToSymbolNode.getSymbol(node, strings.getTString(str), strings.getEncoding(str));
    }

    @Specialization(guards={"!isRubySymbol(object)", "!isString(object)", "isNotRubyString(object)"})
    static RubySymbol toStr(Node node, Object object, @Cached InlinedBranchProfile errorProfile, @Cached(inline=false) DispatchNode toStrNode, @Cached @Cached.Exclusive RubyStringLibrary strings, @Cached(inline=false) ToSymbolNode toSymbolNode) {
        Object coerced = toStrNode.call(ToSymbolNode.coreLibrary((Node)node).truffleTypeModule, "rb_convert_type", object, (Object)ToSymbolNode.coreLibrary((Node)node).stringClass, (Object)ToSymbolNode.coreSymbols((Node)node).TO_STR);
        if (strings.isRubyString(coerced)) {
            return toSymbolNode.executeCached(coerced);
        }
        errorProfile.enter(node);
        throw new RaiseException(ToSymbolNode.getContext(node), ToSymbolNode.coreExceptions(node).typeErrorBadCoercion(object, "String", "to_str", coerced, node));
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.DISPATCH_CACHE;
    }
}

