/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;

@GenerateInline
@GenerateCached(value=false)
public abstract class ToCallTargetNode
extends RubyBaseNode {
    public abstract RootCallTarget execute(Node var1, Object var2);

    @Specialization
    static RootCallTarget boundMethod(RubyMethod method) {
        return method.method.getCallTarget();
    }

    @Specialization
    static RootCallTarget unboundMethod(RubyUnboundMethod method) {
        return method.method.getCallTarget();
    }

    @Specialization
    static RootCallTarget proc(RubyProc proc) {
        return proc.callTarget;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    static RootCallTarget string(Node node, Object string) {
        TStringWithEncoding code = new TStringWithEncoding(RubyGuards.asTruffleStringUncached(string), RubyStringLibrary.getUncached().getEncoding(string));
        Source source = Source.newBuilder((String)"ruby", (CharSequence)new ByteBasedCharSequence(code), (String)"<parse_ast>").build();
        TranslatorEnvironment.resetTemporaryVariablesIndex();
        ParserContext parserContext = ParserContext.TOP_LEVEL;
        return ToCallTargetNode.getContext(node).getCodeLoader().parse(new RubySource(source, source.getName()), parserContext, null, ToCallTargetNode.getContext(node).getRootLexicalScope(), node);
    }
}

