/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import org.truffleruby.core.cast.IntegerCastNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyTypesGen;

@GeneratedBy(value=IntegerCastNode.class)
public final class IntegerCastNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
    }

    @NeverDefault
    public static IntegerCastNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static IntegerCastNode inline(@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=IntegerCastNode.class)
    @DenyReplace
    private static final class Uncached
    extends IntegerCastNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                return IntegerCastNode.doInt(arg1Value_);
            }
            if (RubyTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = RubyTypesGen.asImplicitLong(arg1Value);
                if (RubyGuards.fitsInInteger(arg1Value_)) {
                    return IntegerCastNode.doLong(arg1Value_);
                }
                if (!RubyGuards.fitsInInteger(arg1Value_)) {
                    return IntegerCastNode.doLongToBig(arg0Value, arg1Value_);
                }
            }
            if (!RubyGuards.isImplicitLong(arg1Value)) {
                return IntegerCastNode.doBasicObject(arg0Value, arg1Value);
            }
            throw IntegerCastNodeGen.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
        }
    }

    @GeneratedBy(value=IntegerCastNode.class)
    @DenyReplace
    private static final class Inlined
    extends IntegerCastNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(IntegerCastNode.class));
            this.state_0_ = target.getState(0, 6);
        }

        @Override
        public int execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0xF) != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return IntegerCastNode.doInt(arg1Value_);
                }
                if ((state_0 & 6) != 0 && RubyTypesGen.isImplicitLong((state_0 & 0x30) >>> 4, arg1Value)) {
                    long arg1Value_ = RubyTypesGen.asImplicitLong((state_0 & 0x30) >>> 4, arg1Value);
                    if ((state_0 & 2) != 0 && RubyGuards.fitsInInteger(arg1Value_)) {
                        return IntegerCastNode.doLong(arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && !RubyGuards.fitsInInteger(arg1Value_)) {
                        return IntegerCastNode.doLongToBig(arg0Value, arg1Value_);
                    }
                }
                if ((state_0 & 8) != 0 && !RubyGuards.isImplicitLong(arg1Value)) {
                    return IntegerCastNode.doBasicObject(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return IntegerCastNode.doInt(arg1Value_);
            }
            int longCast1 = RubyTypesGen.specializeImplicitLong(arg1Value);
            if (longCast1 != 0) {
                long arg1Value_ = RubyTypesGen.asImplicitLong(longCast1, arg1Value);
                if (RubyGuards.fitsInInteger(arg1Value_)) {
                    state_0 |= longCast1 << 4;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return IntegerCastNode.doLong(arg1Value_);
                }
                if (!RubyGuards.fitsInInteger(arg1Value_)) {
                    state_0 |= longCast1 << 4;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return IntegerCastNode.doLongToBig(arg0Value, arg1Value_);
                }
            }
            if (!RubyGuards.isImplicitLong(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 8);
                return IntegerCastNode.doBasicObject(arg0Value, arg1Value);
            }
            throw IntegerCastNodeGen.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
        }
    }
}

