/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateCached(value=false)
@GenerateInline
public abstract class BigIntegerCastNode
extends RubyBaseNode {
    public abstract BigInteger execute(Node var1, Object var2);

    @Specialization
    BigInteger doInt(int value) {
        return BigIntegerOps.valueOf(value);
    }

    @Specialization
    BigInteger doLong(long value) {
        return BigIntegerOps.valueOf(value);
    }

    @Specialization
    BigInteger doBignum(RubyBignum value) {
        return value.value;
    }

    @Specialization(guards={"!isRubyInteger(value)"})
    BigInteger doBasicObject(Object value) {
        throw new RaiseException(this.getContext(), this.notAnInteger(value));
    }

    @CompilerDirectives.TruffleBoundary
    private RubyException notAnInteger(Object object) {
        return this.coreExceptions().typeErrorIsNotA(object.toString(), "Integer", (Node)this);
    }
}

