/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.Collections;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.DoubleArrayStore;
import org.truffleruby.core.array.library.IntegerArrayStore;
import org.truffleruby.core.array.library.LongArrayStore;
import org.truffleruby.core.array.library.ObjectArrayStore;
import org.truffleruby.core.array.library.SharedArrayStorage;

@ExportLibrary(value=ArrayStoreLibrary.class)
@GenerateUncached
public final class ZeroLengthArrayStore {
    public static final ZeroLengthArrayStore ZERO_LENGTH_STORE = new ZeroLengthArrayStore();
    static final ArrayStoreLibrary.ArrayAllocator ZERO_LENGTH_ALLOCATOR = new ZeroLengthAllocator();

    private ZeroLengthArrayStore() {
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected Object read(int index) {
        throw new UnsupportedOperationException();
    }

    @ExportMessage
    protected boolean isPrimitive() {
        return true;
    }

    @ExportMessage
    static String toString(ZeroLengthArrayStore store) {
        return "empty";
    }

    @ExportMessage
    protected int capacity() {
        return 0;
    }

    @ExportMessage
    protected Object[] expand(int newCapacity) {
        return new Object[newCapacity];
    }

    @ExportMessage
    protected Object extractRange(int start, int end) {
        assert (start == 0);
        assert (end == 0);
        return this;
    }

    @ExportMessage
    protected Object[] boxedCopyOfRange(int start, int length) {
        assert (start == 0);
        assert (length == 0);
        return ArrayUtils.EMPTY_ARRAY;
    }

    @ExportMessage
    protected void copyContents(int srcStart, Object destStore, int destStart, int length) {
        assert (srcStart == 0);
        assert (length == 0);
    }

    @ExportMessage
    protected void clear(int start, int length) {
    }

    @ExportMessage
    protected Object[] toJavaArrayCopy(int length) {
        assert (length == 0);
        return new Object[length];
    }

    @ExportMessage
    protected void sort(int size) {
        assert (size == 0);
    }

    @ExportMessage
    protected Iterable<Object> getIterable(int from, int length) {
        return () -> Collections.emptyIterator();
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator generalizeForSharing(ZeroLengthArrayStore store) {
        return SharedArrayStorage.SHARED_ZERO_LENGTH_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    protected boolean isDefaultValue(Object value) {
        return false;
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator allocator(ZeroLengthArrayStore store) {
        return ZERO_LENGTH_ALLOCATOR;
    }

    static final class ZeroLengthAllocator
    extends ArrayStoreLibrary.ArrayAllocator {
        ZeroLengthAllocator() {
        }

        @Override
        public Object allocate(int capacity) {
            assert (capacity == 0);
            return ZERO_LENGTH_STORE;
        }

        @Override
        public boolean accepts(Object value) {
            return false;
        }

        @Override
        public boolean specializesFor(Object value) {
            return false;
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return value == null;
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class AllocateForNewStore {
        AllocateForNewStore() {
        }

        @Specialization
        static Object allocateForNewStore(ZeroLengthArrayStore store, ZeroLengthArrayStore newStore, int length) {
            return ZERO_LENGTH_ALLOCATOR.allocate(length);
        }

        @Specialization(guards={"!zeroLengthStore(newStore)"}, limit="storageStrategyLimit()")
        static Object allocateForNewStore(ZeroLengthArrayStore store, Object newStore, int length, @CachedLibrary(value="newStore") ArrayStoreLibrary newStores) {
            return newStores.unsharedAllocateForNewStore(newStore, store, length);
        }

        protected static boolean zeroLengthStore(Object store) {
            return store instanceof ZeroLengthArrayStore;
        }
    }

    @ExportMessage
    static final class AllocateForNewValue {
        AllocateForNewValue() {
        }

        @Specialization
        static Object allocateForNewValue(ZeroLengthArrayStore store, int newValue, int length) {
            return IntegerArrayStore.INTEGER_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocateForNewValue(ZeroLengthArrayStore store, long newValue, int length) {
            return LongArrayStore.LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocateForNewValue(ZeroLengthArrayStore store, double newValue, int length) {
            return DoubleArrayStore.DOUBLE_ARRAY_ALLOCATOR.allocate(length);
        }

        @Fallback
        static Object allocateForNewValue(ZeroLengthArrayStore store, Object newValue, int length) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class GeneralizeForStore {
        GeneralizeForStore() {
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, ZeroLengthArrayStore newStore) {
            return ZERO_LENGTH_ALLOCATOR;
        }

        @Specialization(limit="storageStrategyLimit()")
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, Object newStore, @CachedLibrary(value="newStore") ArrayStoreLibrary newStores) {
            return newStores.allocator(newStore);
        }
    }

    @ExportMessage
    static final class GeneralizeForValue {
        GeneralizeForValue() {
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, int newValue) {
            return IntegerArrayStore.INTEGER_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, long newValue) {
            return LongArrayStore.LONG_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, double newValue) {
            return DoubleArrayStore.DOUBLE_ARRAY_ALLOCATOR;
        }

        @Fallback
        static ArrayStoreLibrary.ArrayAllocator generalize(ZeroLengthArrayStore store, Object newValue) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
        }
    }
}

