/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Set;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyArray
extends RubyDynamicObject
implements ObjectGraphNode {
    private Object store;
    public int size;

    public RubyArray(RubyClass rubyClass, Shape shape, Object store, int size) {
        super(rubyClass, shape);
        this.store = store;
        this.size = size;
    }

    public Object getStore() {
        return this.store;
    }

    public void setStore(Object store) {
        assert (store instanceof SharedArrayStorage == this.getShape().isShared());
        this.store = store;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.store);
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.size;
    }

    @ExportMessage
    public Object readArrayElement(long index, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive DispatchNode dispatch) throws InvalidArrayIndexException {
        if (this.inBounds(index)) {
            return dispatch.call((Object)this, "[]", index);
        }
        errorProfile.enter();
        throw InvalidArrayIndexException.create((long)index);
    }

    @ExportMessage
    public void writeArrayElement(long index, Object value, @Cached @Cached.Shared BranchProfile errorProfile, @Cached @Cached.Exclusive DispatchNode dispatch) throws InvalidArrayIndexException {
        if (index < 0L || !RubyGuards.fitsInInteger(index)) {
            errorProfile.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
        dispatch.call(this, "[]=", index, value);
    }

    @ExportMessage
    public void removeArrayElement(long index, @Cached @Cached.Exclusive DispatchNode dispatch, @Cached @Cached.Shared BranchProfile errorProfile) throws InvalidArrayIndexException {
        if (!this.inBounds(index)) {
            errorProfile.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
        dispatch.call((Object)this, "delete_at", index);
    }

    @ExportMessage
    public boolean isArrayElementReadable(long index) {
        return this.inBounds(index);
    }

    @ExportMessage
    public boolean isArrayElementModifiable(long index, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
        return !isFrozenNode.execute(this) && this.inBounds(index);
    }

    @ExportMessage
    public boolean isArrayElementRemovable(long index, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
        return !isFrozenNode.execute(this) && this.inBounds(index);
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long index, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
        return !isFrozenNode.execute(this) && RubyGuards.fitsInInteger(index) && index >= (long)this.size;
    }

    @ExportMessage
    public boolean hasIterator() {
        return true;
    }

    @ExportMessage
    public ArrayIterator getIterator() {
        return new ArrayIterator(this);
    }

    private boolean inBounds(long index) {
        return index >= 0L && index < (long)this.size;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArrayIterator
    implements TruffleObject {
        final RubyArray array;
        private long currentItemIndex;

        ArrayIterator(RubyArray array) {
            this.array = array;
        }

        @ExportMessage
        boolean isIterator() {
            return true;
        }

        @ExportMessage
        boolean hasIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary arrays) {
            try {
                return this.currentItemIndex < arrays.getArraySize((Object)this.array);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @ExportMessage
        Object getIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary arrays, @Cached BranchProfile concurrentModification) throws StopIterationException {
            try {
                long size = arrays.getArraySize((Object)this.array);
                if (this.currentItemIndex >= size) {
                    throw StopIterationException.create();
                }
                Object element = arrays.readArrayElement((Object)this.array, this.currentItemIndex);
                ++this.currentItemIndex;
                return element;
            }
            catch (InvalidArrayIndexException e) {
                concurrentModification.enter();
                throw StopIterationException.create();
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }
}

