/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;

public final class ArrayStaticLiteralNode
extends RubyContextSourceNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] values;

    public ArrayStaticLiteralNode(Object[] values) {
        assert (ArrayStaticLiteralNode.allValuesArePrimitiveOrImmutable(values));
        this.values = values;
    }

    private static boolean allValuesArePrimitiveOrImmutable(Object[] values) {
        for (Object value : values) {
            assert (RubyGuards.isPrimitiveOrImmutable(value));
        }
        return true;
    }

    @Override
    public RubyArray execute(VirtualFrame frame) {
        return this.createArray(ArrayUtils.copy(this.values));
    }

    @Override
    public RubyNode cloneUninitialized() {
        return new ArrayStaticLiteralNode(this.values);
    }
}

