/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArraySliceNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="arrayNode", type=RubyNode.class)
@ImportStatic(value={ArrayGuards.class})
public abstract class ArraySliceNode
extends RubyContextSourceNode {
    final int from;
    final int to;

    public ArraySliceNode(int from, int to) {
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    public abstract RubyArray execute(RubyArray var1);

    public abstract RubyNode getArrayNode();

    @Specialization
    RubyArray readSlice(RubyArray array, @Cached ArrayCopyOnWriteNode cowNode, @Cached ConditionProfile emptyArray) {
        int length = array.size + this.to - this.from;
        if (emptyArray.profile(length <= 0)) {
            return this.createEmptyArray();
        }
        Object slice = cowNode.execute(array, this.from, length);
        return this.createArray(slice, length);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ArraySliceNode copy = ArraySliceNodeGen.create(this.from, this.to, this.getArrayNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

