/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import java.util.Arrays;
import org.truffleruby.core.array.ArrayEnsureCapacityNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayPrepareForCopyNodeGen;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ReportPolymorphism
@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayPrepareForCopyNode
extends RubyBaseNode {
    public static ArrayPrepareForCopyNode create() {
        return ArrayPrepareForCopyNodeGen.create();
    }

    public abstract Object execute(RubyArray var1, RubyArray var2, int var3, int var4);

    @Specialization(guards={"length == 0", "start <= dst.size"})
    @ReportPolymorphism.Exclude
    Object noChange(RubyArray dst, RubyArray src, int start, int length) {
        return dst.getStore();
    }

    @Specialization(guards={"start > dst.size"}, limit="storageStrategyLimit()")
    Object nilPad(RubyArray dst, RubyArray src, int start, int length, @Bind(value="dst.getStore()") Object dstStore, @CachedLibrary(value="dstStore") ArrayStoreLibrary dstStores) {
        int oldSize = dst.size;
        Object[] newStore = new Object[ArrayUtils.capacity(this.getLanguage(), oldSize, start + length)];
        dstStores.copyContents(dstStore, 0, newStore, 0, oldSize);
        Arrays.fill(newStore, oldSize, start, nil);
        dst.setStore(newStore);
        dst.size = start + length;
        return newStore;
    }

    @Specialization(guards={"length > 0", "start <= dst.size", "compatible(dstStores, dstStore, srcStore)"}, limit="storageStrategyLimit()")
    Object resizeCompatible(RubyArray dst, RubyArray src, int start, int length, @Bind(value="dst.getStore()") Object dstStore, @Bind(value="src.getStore()") Object srcStore, @Cached ArrayEnsureCapacityNode ensureCapacityNode, @CachedLibrary(value="dstStore") ArrayStoreLibrary dstStores) {
        Object newStore = ensureCapacityNode.executeEnsureCapacity(dst, start + length);
        if (start + length > dst.size) {
            dst.size = start + length;
        }
        return newStore;
    }

    @Specialization(guards={"length > 0", "start <= dst.size", "!compatible(dstStores, dstStore, srcStore)"}, limit="storageStrategyLimit()")
    Object resizeGeneralize(RubyArray dst, RubyArray src, int start, int length, @Bind(value="dst.getStore()") Object dstStore, @Bind(value="src.getStore()") Object srcStore, @CachedLibrary(value="dstStore") ArrayStoreLibrary dstStores) {
        int oldDstSize = dst.size;
        int newDstSize = Math.max(oldDstSize, start + length);
        Object newDstStore = dstStores.allocateForNewStore(dstStore, srcStore, newDstSize);
        dstStores.copyContents(dstStore, 0, newDstStore, 0, oldDstSize);
        dst.setStore(newDstStore);
        if (newDstSize > oldDstSize) {
            dst.size = newDstSize;
        }
        return newDstStore;
    }

    protected static boolean compatible(ArrayStoreLibrary stores, Object dstStore, Object srcStore) {
        return stores.acceptsAllValues(dstStore, srcStore);
    }
}

