/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.array.ArrayPatternLengthCheckNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="valueNode", type=RubyNode.class)
public abstract class ArrayPatternLengthCheckNode
extends RubyContextSourceNode {
    final int patternLength;
    final boolean hasRest;

    public ArrayPatternLengthCheckNode(int patternLength, boolean hasRest) {
        this.patternLength = patternLength;
        this.hasRest = hasRest;
    }

    abstract RubyNode getValueNode();

    @Specialization
    boolean arrayLengthCheck(RubyArray matchArray) {
        int size = matchArray.size;
        if (this.hasRest) {
            return this.patternLength <= size;
        }
        return this.patternLength == size;
    }

    @Fallback
    boolean notArray(Object value) {
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return ArrayPatternLengthCheckNodeGen.create(this.patternLength, this.hasRest, this.getValueNode().cloneUninitialized()).copyFlags(this);
    }
}

