/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.ZeroLengthArrayStore;

public final class ArrayGuards {
    public static int storageStrategyLimit() {
        return RubyLanguage.getCurrentLanguage().options.ARRAY_STRATEGY_CACHE;
    }

    public static boolean isObjectArray(RubyArray array) {
        Object store = array.getStore();
        return store.getClass() == Object[].class;
    }

    public static boolean isEmptyArray(RubyArray array) {
        return array.size == 0;
    }

    public static boolean basicStore(Object store) {
        assert (!(store instanceof Object[]) || store.getClass() == Object[].class) : "Must be Object[], not a subclass: " + String.valueOf(store);
        return store instanceof int[] || store instanceof long[] || store instanceof double[] || store instanceof Object[];
    }

    public static boolean zeroLengthStore(Object store) {
        return store == ZeroLengthArrayStore.ZERO_LENGTH_STORE;
    }

    public static boolean isZeroLengthArrayStore(Object store) {
        return store == ZeroLengthArrayStore.ZERO_LENGTH_STORE || store == ArrayStoreLibrary.SHARED_INITIAL_STORE;
    }
}

