/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayEnsureCapacityNode
extends RubyBaseNode {
    public abstract Object executeEnsureCapacity(RubyArray var1, int var2);

    @Specialization(guards={"!stores.isMutable(store)"}, limit="storageStrategyLimit()")
    Object ensureCapacityAndMakeMutable(RubyArray array, int requiredCapacity, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared CountingConditionProfile extendProfile) {
        int currentCapacity = stores.capacity(store);
        int capacity = extendProfile.profile(currentCapacity < requiredCapacity) ? ArrayUtils.capacity(this.getLanguage(), currentCapacity, requiredCapacity) : currentCapacity;
        Object newStore = stores.allocator(store).allocate(capacity);
        stores.copyContents(store, 0, newStore, 0, currentCapacity);
        array.setStore(newStore);
        return newStore;
    }

    @Specialization(guards={"stores.isMutable(store)"}, limit="storageStrategyLimit()")
    Object ensureCapacity(RubyArray array, int requiredCapacity, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared CountingConditionProfile extendProfile) {
        int length = stores.capacity(store);
        if (extendProfile.profile(length < requiredCapacity)) {
            int capacity = ArrayUtils.capacity(this.getLanguage(), length, requiredCapacity);
            Object newStore = stores.expand(store, capacity);
            array.setStore(newStore);
            return newStore;
        }
        return store;
    }
}

